from Ft.Rdf.Drivers import Memory
from Ft.Rdf import Model
def CreateInfEng():
    from Ft.Rdf.Inference import InferenceEngine
    db = Memory.DbAdapter('kb')
    db.begin()
    kb = Model.Model(db)
    return InferenceEngine.InferenceEngine(kb)

def Test(test):
    test.startGroup('InferenceEngine')
    
    test.startTest('Syntax')
    from Ft.Rdf.Inference import InferenceEngine
    from Ft.Rdf.Parsers.Ril import RilParserImp
    test.testDone()

    exp = """<?xml version = "1.0"?>
<ril:expression xmlns:ril = "http://namespaces.rdfinference.org/ril" xmlns:ft = "http://namespaces.fourthought.com/test">
  <ril:assert>
    <ft:wet>
        <ril:string-list>
          <ril:string>Mike</ril:string>
          <ril:string>Uche</ril:string>
        </ril:string-list>
    </ft:wet>
    <ft:creator>
        <ril:string>Mike</ril:string>
        <ril:string-list>
          <ril:string>A Book</ril:string>
          <ril:string>Another Book</ril:string>
        </ril:string-list>
    </ft:creator>
  </ril:assert>
  <ril:query>
    <ft:wet>
      <ril:variable name="X"/>
    </ft:wet>
  </ril:query>
  <ril:query>
    <ft:wet>
      <ril:string>Mike</ril:string>
    </ft:wet>
  </ril:query>
  <ril:query>
    <ft:creator>
      <ril:variable name="X"/>
      <ril:variable name="X"/>
    </ft:creator>
  </ril:query>
  <ril:query>
    <ft:creator>
      <ril:variable name="X"/>
      <ril:variable name="Y"/>
    </ft:creator>
  </ril:query>
  <ril:query>
    <ft:creator>
      <ril:string>Mike</ril:string>
      <ril:variable name="X"/>
    </ft:creator>
  </ril:query>
  <ril:query>
    <ft:creator>
      <ril:variable name="X"/>
      <ril:string>A Book</ril:string>
    </ft:creator>
  </ril:query>
  <ril:query>
    <ft:creator>
      <ril:string>Mike</ril:string>
      <ril:string>A Book</ril:string>
    </ft:creator>
  </ril:query>
</ril:expression>
"""

    p = RilParserImp.RilParserImp()

    defs = p.parse(exp)

    test.startTest('Parsed Queries')
    infeng = CreateInfEng()

    results = infeng.execute(defs)

    test.compare([[('Mike', 'http://namespaces.fourthought.com/test#wet', '1'), ('Uche', 'http://namespaces.fourthought.com/test#wet', '1')], [('Mike', 'http://namespaces.fourthought.com/test#wet', '1')], [], [('Mike', 'http://namespaces.fourthought.com/test#creator', 'A Book'), ('Mike', 'http://namespaces.fourthought.com/test#creator', 'Another Book')], [('Mike', 'http://namespaces.fourthought.com/test#creator', 'A Book'), ('Mike', 'http://namespaces.fourthought.com/test#creator', 'Another Book')], [('Mike', 'http://namespaces.fourthought.com/test#creator', 'A Book')], [('Mike', 'http://namespaces.fourthought.com/test#creator', 'A Book')]], results)

    test.testDone()
    test.groupDone()




if __name__ == '__main__':
    from Ft.Lib.TestSuite import Tester
    tester = Tester.Tester()
    Test(tester)

