
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import Module
from Ft.Ods.MetaData import Interface
from Ft.Ods.MetaData import Class
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_type
import test_definingscope, test_metadata_util

def Test(tester,useKlass=Interface.Interface):

    if useKlass == Interface.Interface:
        manager = Adapters.GetManager()
        adapter = Adapters.GetAdapter()
        if manager.exists(DBNAME):
            manager.reinitRepo(DBNAME,adapter)
        else:
            manager.new(DBNAME,adapter)
            
    db = Database.Database()
    db.open(DBNAME)
    try:
    
        test_type.Test(tester,db,useKlass)
        test_definingscope.Test(tester,db,useKlass)

        tester.startGroup("Interface test on %s Driver %s" % (useKlass.__name__,tester.test_data['driver']))

        def GetInterface(db,values):
            from Ft.Ods.MetaData import Interface
            i = Interface.Interface(db,None)
            i.name='i1'
            return i
        test_metadata_util.test_form_drop(tester,db,useKlass,'inherits',GetInterface,nSided=1)
        def GetInterface(db,values):
            from Ft.Ods.MetaData import Interface
            i = Interface.Interface(db,None)
            i.name='i2'
            return i
        test_metadata_util.test_form_drop(tester,db,useKlass,'derives',GetInterface,nSided=1)

        def CreateParams(db,values):
            from Ft.Ods.MetaData import Parameter
            from Ft.Ods.MetaData import Direction
            param = Parameter.Parameter(db,None,parameter_mode=Direction.mode_inout)
            param.name = 'param'
            return param
        test_metadata_util.test_add_remove(tester,db,useKlass,'operation',
                                  ("Operation","opResult","Params"),
                                  argFactory={"opResult":Class.Class},
                                  argListFactory={"Params":CreateParams},
                                  argResolve={},
                                  testValues={"name":"Operation",
                                              "meta_kind":MetaKind.mk_operation,
                                              "result":"opResult",
                                              },
                                  testListValues={'signature':"Params"},
                                  testIn="defines",
                                  testResolve="Operation",
                                  )


        def GetInterface(db,values):
            from Ft.Ods.MetaData import Interface
            i = Interface.Interface(db,None)
            i.name='i3'
            return i
        test_metadata_util.test_add_remove(tester,db,useKlass,'attribute',
                                  ("Attribute","aType"),
                                  argFactory={"aType":GetInterface},
                                  argListFactory={},
                                  argResolve={},
                                  testValues={"name":"Attribute",
                                              "meta_kind":MetaKind.mk_attribute,
                                              "type":"aType",
                                              },
                                  testListValues={},
                                  testIn="defines",
                                  testResolve="Attribute",
                                  )
        def GetInterface(db,values):
            from Ft.Ods.MetaData import Interface
            i = Interface.Interface(db,None)
            i.name='i4'
            return i
        def GetInterface2(db,values):
            from Ft.Ods.MetaData import Interface
            i = Interface.Interface(db,None)
            i.name='i42'
            return i
        def GetInterface3(db,values):
            from Ft.Ods.MetaData import Interface
            i = Interface.Interface(db,None)
            i.name='i43'
            return i
        test_metadata_util.test_add_remove(tester,db,useKlass,'relationship',
                                  ("Relationship","rType","Target","InvRel","InvType"),
                                  argFactory={"rType":GetInterface,
                                              "Target":GetInterface2,
                                              "InvType":GetInterface3,
                                              },
                                  argListFactory={},
                                  argResolve={},
                                  testValues={"name":"Relationship",
                                              "meta_kind":MetaKind.mk_relationship,
                                              "type":"rType",
                                              },
                                  testListValues={},
                                  testIn="defines",
                                  testResolve="Relationship",
                                  )


        tester.groupDone()
    finally:
        db.close()



