########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Http/MessageSource.py,v 1.1 2005/04/06 06:19:15 mbrown Exp $
"""
Misc error codes and messages for the HTTP modules

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft import TranslateMessage as _

class Error:

    # general HTTP processing not covered by HTTP response codes
    BAD_REQUEST_PATH = 10

    # sessions
    SESSIONS_NOT_ENABLED = 20
    BAD_LOGIN_FAILURE_REDIRECT = 21

    # SOAP
    BAD_SOAP_REQUEST = 30
    MISSING_SOAPACTION_HEADER = 31
    MALFORMED_SOAP_MESSAGE = 32
    INVALID_SOAP_ENVELOPE = 33
    MISSING_SOAP_BODY = 34
    NO_SOAP_HANDLER_FOR_NAME = 35
    NO_SOAP_HANDLER_FOR_NS = 36

g_errorMessages = {
    Error.BAD_REQUEST_PATH: _("Request URI path %(path)r cannot be mapped to a repo path"),

    Error.SESSIONS_NOT_ENABLED: _("The server config allows session-based logins when the"
        " '%(login_query_arg)s=login' query arg is provided, but sessions have not been"
        " enabled on this server."),

    Error.BAD_LOGIN_FAILURE_REDIRECT: _("A session-based login was requested and failed,"
        " but you could not be redirected to an appropriate location because"
        " the server configuration does not contain the necessary info."),

    Error.BAD_SOAP_REQUEST: _("Missing required cidr-soap:query child element or its content"),
    Error.MISSING_SOAPACTION_HEADER: _("SOAP request did not contain the soapaction header"),
    Error.MALFORMED_SOAP_MESSAGE: _("SOAP message could not be parsed; %(errmsg)s"),
    Error.INVALID_SOAP_ENVELOPE: _("Invalid SOAP request envelope"),
    Error.MISSING_SOAP_BODY: _("SOAP message contains no body"),
    Error.NO_SOAP_HANDLER_FOR_NAME: _("No handler for SOAP request %(name)s, namespace %(ns)s"),
    Error.NO_SOAP_HANDLER_FOR_NS: _("No handler for SOAP request namespace %(ns)s"),
}

