############################################################################
#
# File Name: 		__init__.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/StorageManager/Adapter/__init__.py/html
#
"""
Manages data storage
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""


import os
g_driverName=""
def GetDriver(driverName=None):
    if driverName is None:
        if g_driverName:
            driverName = g_driverName
        elif os.environ.has_key('FTODS_DB_DRIVER'):
            driverName = os.environ['FTODS_DB_DRIVER']
        else:
            driverName = 'Dbm'

    return __import__("Ft.Ods.StorageManager.Adapters." + driverName,
                      globals(), locals(), ["*"])

def GetAdapter(driverName = None):
    return GetDriver(driverName).adapter

def GetManager(driverName = None):
    return GetDriver(driverName).adapter.manager


