/*
 * srmv2.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/srmv2/srmv2/srmv2.h,v 1.16 2002/02/03 03:05:47 lim Exp $
 */

#ifndef srmv2_h
#define srmv2_h

#include "net/config.h"
#include <stdio.h>
#include "iohandler/timer.h"
#include "net/pktbuf.h"

#define PROTOTYPES 1 
#include "net/global.h"
extern "C" {
#include "net/md5.h"
}

#ifdef _MSC_VER
/*warning C4200: nonstandard extension used : zero-sized array in ...*/
#pragma warning( disable : 4200 )
#endif

#define SRMv2_FRAG    1



/*
 * Since local recovery-enabled senders interact badly with
 * receivers using global recovery, we separate them for now using
 * the SRMv2_VERSION number.
 */
#ifndef SRMv2_LOC_REC
#define SRMv2_VERSION 2
#else 
#define SRMv2_VERSION 3
#endif

/* FIXME: remove this, should be internal variable of SRMv2 */
#define SRMv2_MTU 1024
#define INIT_TTL     8 /* Starting TTL value for ERS. */

#define SRMv2_DATA          1
#define SRMv2_ANNOUNCEMENT  2 
#define SRMv2_RREQ          3
#define SRMv2_NSREQUEST     4
#define SRMv2_ANNOUNCE      5 
#define SRMv2_DELAYS        6
#define SRMv2_NSREPAIR      7
#define SRMv2_REXMIT        9 /* We shouldn't have to use this flag. Used to 
				 indicate fragmentation. */

#define SRMv2_DATA_TCID         1
#define SRMv2_ANNOUNCE_TCID     2
#define SRMv2_NACK_TCID         3


#define SRMv2_PROTO    1
#define DUMMY         -1
#define SRMv2_OK       1
#define SRMv2_EXCL     1
#define SRMv2_LOSS     0

#define SRMv2_MULTICAST 0
#define SRMv2_UNICAST   1

#define MAX_BACKOFF_FACTOR 1024
#define MIN_BACKOFF_DELAY  500.0 /* While no RTT ests. are available, return a 
				   one-way delay of 50 ms. This is very 
				   arbitrary! */
#define MAX_ADUNAME_LEN 128
#define NET_MTU         PKTBUF_SIZE
#define SRMv2HDR_SIZE   (sizeof(srmv2_cmnhdr) + sizeof(srmv2_conhdr) + sizeof(srmv2_aduhdr))

#define MAX_NODES 1024
#define MAX_ANNOUNCEMENTS 30
#define SRMv2_CEND 0xffffffff
/* 
 * Common SRMv2 header. 
 */
struct srmv2_cmnhdr {
	u_int8_t   flags;	/* Version : 2, Padding : 1 */
	u_int8_t   type;        /* SRMv2 Pkt type */
	u_int8_t   tcid;
	u_int8_t   unused;
	unsigned int ipaddr;    /* IPv4 address */
};

struct srmv2_conhdr {
	u_int32_t srcid[4];
	u_int32_t cid;
};

struct srmv2_aduhdr {
	u_int8_t  flags;       /* Fragment : 1, LastADU : 1, Reserved : 6 */
	u_int8_t  atype;
	u_int16_t alen;
	u_int32_t seqno;
	u_int32_t ts[2];
};

typedef u_int32_t srmv2_fraghdr; /* MSbit is the "more" flag */

struct srmv2_rreqhdr {
	u_int32_t ss;
	u_int32_t sbytes;
	u_int32_t es;
	u_int32_t ebytes;
};

struct srmv2_rreqfraghdr {
	u_int32_t sbytes;
	u_int32_t ebytes;
};

struct srmv2_announcehdr {
	u_int32_t cid;
	u_int32_t sign;
};

/* 
 * Each component of the node address is encoded 
 * using these records. 
 */
typedef struct {
  unsigned int pcid; /* CID of parent node. */
  unsigned int cid;  /* CID of current node. */
  unsigned int offset;   /* Offset of cid in parent. */
  unsigned int childsig; /* childsig field of signature. */
  unsigned int adu;      /* adu field of signature */
  unsigned int byte;     /* byte field of signature */
} naddr;


typedef struct {
  naddr addr;
  u_int32_t name_len;
  unsigned char name[0];
} naddr_plus_name;


/*
 *   t1
 *    \
 *       t2
 *       |
 *       t3
 *     /
 *  t4
 */

/* Delay Information */
struct srmv2_delayhdr {
	unsigned int ip_addr; /* Host IPv4 address. */
	int ow_diff;          /* td is t1 + t3 - t2, in 2^{-16} sec for the latest sample. */
};

struct srmv2_delays {
	unsigned int rtt_est; /* rtt_est is an EWMA of all the RTT samples 
				 from this host. */
	int ow_diff;          /* ow_diff is t2 - t1. Warning, this may NOT 
				 even be positive! */
};

#define     MAX(a,b) (((a)>(b))?(a):(b))
#define     MIN(a,b) (((a)<(b))?(a):(b))

inline void md5_digest(const char *in, unsigned char *out)
{
	MD5_CTX context;
	unsigned int len = strlen (in);
	
	MD5Init (&context);
	MD5Update (&context, (unsigned char *)in, len);
	MD5Final (out, &context);
}
inline float ntp2msec(unsigned ntptime) {
	return (float)((ntptime >> 16)*1000.0 + (ntptime&0xffff)/65.536);
}
#endif
