/*
 * pkttbl.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/srmv2/net/pkttbl.cc,v 1.4 2002/02/03 03:03:19 lim Exp $";
#endif

#include <stdio.h>
#include "pkttbl.h"
#include "config.h"

#define PKT_TABLE_SIZE	1024

PacketTable::PacketTable()
	:size_(PKT_TABLE_SIZE), pool_(0), last_(-1)
{
	table_ = new pktbuf*[size_];
	bzero((char*)table_, size_*sizeof(pktbuf*));
}

void PacketTable::grow()
{
	int newsize = size_ * 2;
	pktbuf** newtable = new pktbuf*[newsize];
	bzero((char*)newtable, newsize * sizeof(pktbuf*));
	bcopy((char*)table_, (char*)newtable, size_*sizeof(pktbuf*));
	size_ = newsize;
	delete table_;
	table_ = newtable;
}

PacketTable::~PacketTable()
{
	for (int i = 0; i < size_; i++)
		if (table_[i] != 0)
			pool_->release(table_[i]);
	delete table_;
}

int PacketTable::addpkt(const u_char* p, int len)
{
	pktbuf* pb = pool_->alloc();
	bcopy(p, pb->dp, len);
	pb->len = len;
	
	/* 
	 * Linearly search for open hole.  We could hash this, but the 
	 * assumption is that tcl effectively does the has for us in the 
	 * storing of the id and that is the only way we will access the
	 * packet.  Change this if needed.
	 */
	int i = (last_ + 1) % size_;
	while(i != last_) {
		if (table_[i] == 0) {
			last_ = i;
			table_[i] = pb;
			return (i);
		}
		i = (i + 1) % size_;
	}

	/* 
	 * We wrapped around - the table is full.  Grow the table and 
	 * place the new packet in the first slot of the extension.
	 */
	int s = size_;
	grow();
	table_[s] = pb;
	last_ = s;

	return (s);
}

void PacketTable::delpkt(int i)
{
	/* sanity check */
	if (i >= size_) {
		fprintf(stderr, "error: tried to delete packet %d/%d.\n", 
			i, size_);
		return;
	}		
	
	pktbuf** pb = &table_[i];
	if (*pb != 0) {
		pool_->release(*pb);
		*pb = 0;
	}
}

/* FIXME Do we want to return the pktbuf here? */
u_char* PacketTable::getpkt(int i)
{
	/* sanity check */
	if (i >= size_) {
		fprintf(stderr, "error: tried to get packet %d/%d.\n", 
			i, size_);
		return (0);
	}		
	
	pktbuf* pb = table_[i];
	if (pb != 0)
		return (pb->dp);
	else 
		return (0);
}
