# application-rtpgw.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/rtpgw/application-rtpgw.tcl,v 1.24 2002/02/03 04:29:18 lim Exp $


#source tcl/common/observe.tcl
#source tcl/common/util.tcl

#source tcl/common/application.tcl
#source tcl/common/application-rtp.tcl
#source tcl/net/agent-rtp.tcl
#source tcl/net/network.tcl
#source tcl/net/source-rtp.tcl
#source tcl/net/rtp.tcl
#source tcl/mbp/cb-mbp.tcl
#source tcl/rtpgw/agent-rtpgw.tcl
#source tcl/rtpgw/sm-rtpgw.tcl
#source tcl/rtpgw/encoders.tcl
#source tcl/common/timer.tcl
#source tcl/common/sdp.tcl
#source tcl/net/al.tcl
#source tcl/mega/al-mega.tcl
#source tcl/mega/al-gw.tcl
#source tcl/mega/al-client.tcl

import RTPApplication

Class RTPGWApplication -superclass RTPApplication

RTPGWApplication instproc init_args o {

	$o register_option -A sessionType
	$o register_option -I confBusChannel
	$o register_option -g filterGain
	$o register_option -u userhookFile
	$o register_option -usemega megaSession
	$o register_option -megactrl asCtrl
	$o register_option -megaclient megaClient
	$o register_option -maxsbw maxSessionBW
	$o register_option -sbw localSessionBW
	$o register_option -sspec sessionSpec
	$o register_option -ofmt megaFormat
	$o register_option -rport megaRecvPort
}

RTPGWApplication instproc init_resources o {
	$o add_default siteDropTime 300

	$o add_default startupIdleTime 120000

	$o add_default confBusChannel 3
	$o add_default filterGain 0.25
	$o add_default sessionType rtp
	$o add_default defaultTTL 1

	$o add_default maxSessionBW 1000000
	$o add_default asCtrl 224.4.5.24/50000/31
	$o add_default asCtrlBW 20000
}

RTPGWApplication private check_extra { argv } {
	$self instvar name_

	if { $argv != "" } {
		set extra [lindex $argv 0]
		puts stderr "$name_: extra arguments (starting with $extra)"
		exit 1
	}
}
