# temporal-selector-input.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Class TemporalSelectorInput

TemporalSelectorInput instproc init {tselect_obj id} {
    $self next;

    $self instvar tselect_obj_;
    $self instvar callback_;
    $self instvar subgraph_list_;
    $self instvar id_;

    set tselect_obj_ $tselect_obj;
    set callback_ "";
    set id_ $id;
    set subgraph_list_ "";
}

TemporalSelectorInput instproc destroy {} {
    $self next;
}

TemporalSelectorInput instproc set_callback cb {
    $self instvar callback_;

    set callback_ $cb;
}

TemporalSelectorInput instproc add_subgraph s {
    $self instvar subgraph_list_;

    if {[lsearch $subgraph_list_ $s] == -1} {
	lappend subgraph_list_ $s;
    }
}

TemporalSelectorInput instproc del_subgraph s {
    $self instvar subgraph_list_;

    set idx [lsearch $subgraph_list_ $s]
    if {$idx == -1} {
	set subgraph_list_ [lreplace $subgraph_list_ $idx $idx];
    }
}

TemporalSelectorInput instproc update_subgraph s {
}

TemporalSelectorInput instproc get_current_ts {} {
    # No default for this.
}

Class TemporalSelectorInput/JPEG -superclass TemporalSelectorInput

TemporalSelectorInput/JPEG instproc init {args} {
    eval $self next $args;

    $self instvar decoder_;

    set decoder_ [new Module/Selector/Temporal/Indep];
}

TemporalSelectorInput/JPEG instproc destroy {} {

    $self instvar decoder_;

    if {$decoder_ != ""} {
	delete $decoder_;
    }

    $self next;
}

TemporalSelectorInput/JPEG instproc get_decoder {} {
    $self instvar decoder_;

    return $decoder_;
}

TemporalSelectorInput/JPEG instproc set_callback cb {
    $self next $cb;

    $self instvar decoder_;

    $decoder_ set_callback $cb;
}

TemporalSelectorInput/JPEG instproc update_subgraph s {

    $self instvar decoder_;
    $self instvar subgraph_info_;

    if {$s != ""} {
	$decoder_ update $subgraph_info_($s,srcid);
    }
}

TemporalSelectorInput/JPEG instproc add_subgraph s {
    $self next $s;

    $self instvar tselect_obj_;
    $self instvar subgraph_info_;
    $self instvar decoder_;
    $self instvar id_;

    set spec [$tselect_obj_ GenerateSpec];
    set spec_split [split $spec "/"];

    set addr [lindex $spec_split 0];
    set port [lindex $spec_split 1];

    set subgraph_info_($s,vagent) [new PsvpVideoAgent $addr/$port];
    [$subgraph_info_($s,vagent) get_transmitter] set loopback_ 0;

    set subgraph_info_($s,srcid) [$subgraph_info_($s,vagent) get_local_srcid];

    global kpatel_debug;

    if {[info exists kpatel_debug]} {
	set logger [new Module/RTPPktLogger];
	$logger target [$subgraph_info_($s,vagent) get_transmitter];
	$decoder_ register $subgraph_info_($s,srcid) $logger;
    } else {
	$decoder_ register $subgraph_info_($s,srcid) [$subgraph_info_($s,vagent) get_transmitter];
    }

    $tselect_obj_ set_subgraph_input_spec $s $id_ $addr/$port/$subgraph_info_($s,srcid);
}

TemporalSelectorInput/JPEG instproc trigger_sr {src} {
    $self instvar subgraph_list_
    $self instvar subgraph_info_;

    set in_layer [lindex [$src set layers_] 0];

    foreach s $subgraph_list_ {
	if {[info exists subgraph_info_($s,vagent)]} {
	    set out_layer [lindex [[$subgraph_info_($s,vagent) set local_] set layers_] 0];

	    $out_layer set ref_mts_ [$in_layer set mts_];
	    $out_layer set ref_ntp_sec_ [$in_layer set ntp_ts_sec_];
	    $out_layer set ref_ntp_fsec_ [$in_layer set ntp_ts_fsec_];
	}
    }
}

TemporalSelectorInput/JPEG instproc del_subgraph s {
    $self next $s;

    $self instvar decoder_;

    $decoder_ unregister $subgraph_info_($s,srcid);

    delete $subgraph_info_($s,vagent);

    unset subgraph_info_($s,vagent);
    unset subgraph_info_($s,srcid);
}

TemporalSelectorInput/JPEG instproc get_current_ts {} {
    $self instvar decoder_;

    return [$decoder_ get_current_ts];
}


Class TemporalSelectorInput/H261 -superclass TemporalSelectorInput

TemporalSelectorInput/H261 instproc init {args} {
    eval $self next $args;

    $self instvar decoder_;
    $self instvar out_srcid_;

    set out_srcid_ "";
    set decoder_ [new Module/Selector/Temporal/Indep];
}

TemporalSelectorInput/H261 instproc destroy {} {
    $self instvar decoder_;

    if {$decoder_ != ""} {
	delete $decoder;
    }

    $self next;
}

TemporalSelectorInput/H261 instproc get_decoder {} {
    $self instvar decoder_;

    return $decoder_;
}

TemporalSelectorInput/H261 instproc set_callback cb {
    $self next $cb;

    $self instvar decoder_;

    $decoder_ set_callback $cb;
}

TemporalSelectorInput/H261 instproc update_subgraph s {
    $self instvar decoder_;

    $self instvar out_srcid_;

    $decoder_ update $out_srcid_;
}

TemporalSelectorInput/H261 instproc trigger_sr {src} {
    $self instvar out_vagent_;

    if {[info exists out_vagent_]} {
	set in_layer [lindex [$src set layers_] 0];
	set out_layer [lindex [[$out_vagent_ set local_] set layers_] 0];
	$out_layer set ref_mts_ [$in_layer set mts_];
	$out_layer set ref_ntp_sec_ [$in_layer set ntp_ts_sec_];
	$out_layer set ref_ntp_fsec_ [$in_layer set ntp_ts_fsec_];
    }
}

TemporalSelectorInput/H261 instproc add_subgraph s {
    $self next $s;

    $self instvar tselect_obj_;
    $self instvar out_srcid_;
    $self instvar out_vagent_;
    $self instvar id_;
    $self instvar decoder_;
    $self instvar out_addr_;
    $self instvar out_port_;

    if {$out_srcid_ == ""} {
	set spec [$tselect_obj_ GenerateSpec];
	set spec_split [split $spec "/"];

	set out_addr_ [lindex $spec_split 0];
	set out_port_ [lindex $spec_split 1];

	set out_vagent_ [new PsvpVideoAgent $out_addr_/$out_port_];
	[$out_vagent_ get_transmitter] set loopback_ 0;

	set out_srcid_ [$out_vagent_ get_local_srcid];

	global kpatel_debug;

	if {[info exists kpatel_debug]} {
	    set logger [new Module/RTPPktLogger];
	    $logger target [$out_vagent_ get_transmitter];
	    $decoder_ register $out_srcid_ $logger;
	} else {
	    $decoder_ register $out_srcid_ [$out_vagent_ get_transmitter];
	}
    }

    $tselect_obj_ set_subgraph_input_spec $s $id_ $out_addr_/$out_port_/$out_srcid_;
}

TemporalSelectorInput/H261 instproc get_current_ts {} {
    $self instvar decoder_;

    return [$decoder_ get_current_ts];
}

