# datasrc-nam.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#----------------------------------
# DataSrc/Nam
# ~~~~~~~~~~~
#
Class DataSrc/Nam -superclass DataSrc

DataSrc/Nam instproc init {} {
        $self next
        $self set events_(0) "{} 0"
}

# events format: startTime endTime eventType
# (c.r. DataSrc/Local/Nam convert*)
DataSrc/Nam instproc eventST {evId} {
        return [lindex [$self set events_($evId)] 1]
}

DataSrc/Nam instproc eventET {evId} {
        return [lindex [$self set events_($evId)] 2]
}

DataSrc/Nam instproc inRange {eId t} {
        $self instvar events_ lastStatic_
        return [expr [lindex $events_($eId) 1] <= $t && \
                        [lindex $events_($eId) 2] >= $t]
}


#----------------------------------
# DataSrc/Nam/Local
# ~~~~~~~~~~~~~~~~~
# - this is a special data source that reads from a text file
# - one line per data item
# - data items identified by the line number (one event per line)
# - the line number is the event number
Class DataSrc/Local/Nam -superclass {DataSrc/Local DataSrc/Nam}

DataSrc/Local/Nam instproc init {filename} {
        if ![file exists $filename] {
                error "file $filename does not exist!"
        }
        if ![file readable $filename] {
                error "file $filename is not readable!"
        }
        $self set file_ [open $filename r]
        $self next
}

DataSrc/Local/Nam instproc reset {} {
        $self instvar events_ file_ lastRead_ firstEId_
        $self next

        if ![info exists events_] {
                DbgOut "#*************** RESET!!!! *****************#"
                set events_(0) 0
                seek $file_ 0
                set lastRead_ [expr $firstEId_ - 1]
        }
}

DataSrc/Local/Nam instproc attach_layout {nw} {
        $self set layout_ $nw
}

DataSrc/Local/Nam instproc convert_pkt {eId e} {
        # just a shortcut to parse the variables
        $self instvar layout_ events_
        # sT is the start time
        foreach {sT src dest size attr ptype convid id} $e {}

        if ![$layout_ hasEdge $src $dest] {
                DbgOut "data error: edge ($src,$dest) non_existent!"
        }
        set xmitT [$layout_ xmitTime $src $dest $size]
        set delay [$layout_ edgeDelay $src $dest]
        set pos [$layout_ edgePos $src $dest]
        set eT [expr $sT + $xmitT + $delay]

        set events_($eId) [list NamPkt $sT $eT $pos $delay $xmitT \
                        [$layout_ pktHt $src $dest] \
                        $attr [$layout_ get_color $convid] $id]

#        DbgOut "packet e=$eId pid=$id ($src,$dest) : $events_($eId)"
        return 1
}

# converts a raw trace event to an animation object creation event
DataSrc/Local/Nam instproc convert_event {eId e} {
        set type [removeFirst e]
        switch -- $type {
                h {
                        return [$self convert_pkt $eId $e]
                }
                default {
                        return 0
                }
        }
}

DataSrc/Local/Nam instproc get_event {lineN} {
        $self instvar events_ lastRead_ file_

#        DbgVar lineN lastRead_
        # if the event is in front,
        #     we move forward until we find it.
        # elseif it is behind,
        #     we should have it, since right now we only do sequential scan
        if ![info exists events_($lineN)] {
                while {$lastRead_ <= $lineN} {
                        incr lastRead_
                        set e ""
                        set c [gets $file_ e]
                        if {$c==-1} {
                                # EOF
                                $self set lastEId_ $lineN
                                incr lastRead_ -1
                                $self set events_($lineN) [list "END" \
                                                [$self eventST $lastRead_] \
                                                [$self eventET $lastRead_]]
                                return ""
                        }
#                        DbgOut retrieved $e
                        # try again if we cannot convert the event
                        if ![$self convert_event $lastRead_ $e] {
                                incr lastRead_ -1
                        }
                }
                if ![info exists events_($lineN)] {
                        error "line $lineN is not available, should not happen"
                }
        }
        return $events_($lineN)
}

DataSrc/Local/Nam instproc mintime {} {
        $self instvar file_ firstEId_ mintime_
        # use the cached value if possible
        if [info exists mintime_] {
                return $mintime_
        }
        set pos [tell $file_]
        seek $file_ 0
        # the start time of the first event is the min time
        set c [gets $file_ firstEvent]
        DbgOut $firstEvent
        set mintime_ [lindex $firstEvent 1]
        seek $file_ $pos
        DbgOut "[$self info class] mintime -> $mintime_"
        return $mintime_
}

DataSrc/Local/Nam instproc maxtime {} {
        $self instvar file_ maxtime_
        # use the cached value if possible
        if [info exists maxtime_] {
                return $maxtime_
        }

        # REVIEW: assume that each line is less than 300 characters
        set pos [tell $file_]
        seek $file_ -300 end
        set lines [split [read $file_] \n]

        set lastline [lindex $lines end]
        # the last character might be a return
        if {"$lastline" == ""} {
#                DbgOut "last line is null, no. lines = [llength $lines]"
                set lastline [lindex $lines [expr [llength $lines] - 2]]
#                DbgOut "last line: $lastline"
        }
        set maxtime [lindex $lastline 1]

        DbgOut maxtime is $maxtime
        # REVIEW: since we only have packet size in the last line,
        #         we cannot figure out the end_time, so add 0.5 to be save
        #         nothing in a network should last longer than 0.5 secs right?

        set maxtime_ [expr $maxtime + 0.5]
        seek $file_ $pos
        return $maxtime
}

# gives the (data) source a chance to send out any data...
DataSrc/Local/Nam instproc setup {} {
        $self instvar layout_ events_

        # start at event 2, event 1 is reserved for startup information.
        set i 2
        foreach n [$layout_ nodes] {
                set events_($i) [list NamNode 0 0 $n [$layout_ nodePos $n] \
                                [$layout_ nodeSize $n]]
                incr i
        }
        foreach e [$layout_ edges] {
                set events_($i) [list NamEdge 0 0 \
                                [eval $layout_ edgePos [split $e ","]] 0]
                incr i
        }
        set lastStatic [expr $i - 1]
        DbgOut last static is: $lastStatic
        for {set i 2} {$i<=$lastStatic} {incr i} {
                $self handle $i $events_($i)
        }

        # insert setup information
        # format:  type st et firstEvent lastStaticEvent mintime maxtime
        $self instvar view_
        $self set firstEId_ $lastStatic
        $self set lastRead_ $lastStatic

        DbgOut mintime is: [$self mintime]
        set events_(1) [list INIT 0 0 1 $lastStatic \
                        [$self mintime] [$self maxtime] [$view_ bbox]]

        # we send out the initialization after the rest, so as to be
        # consistent with the notion of sending dependencies first.
        # But we want this to be one so that it is a consistent place for
        # initial packet request....
        # REVIEW: should really cast them into the namespace....
        $self handle 1 $events_(1)
        DbgOut mintime is: [$self mintime]

        # note most variables will get initialized during handle event...
        $self instvar now_
        $self hook_updateTime $now_
}
