# al-platform-client.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/as/al-platform-client.tcl,v 1.5 2002/02/03 04:25:20 lim Exp $


import AnnounceListenManager/AS/Client

# Listen-only class
Class AnnounceListenManager/AS/Client/Platform -superclass  \
		AnnounceListenManager/AS/Client



AnnounceListenManager/AS/Client/Platform public init { spec } {
	$self next $spec 0 client

}

AnnounceListenManager/AS/Client/Platform public service_location { } {
	#puts "service_location called!"
	exit
}

AnnounceListenManager/AS/Client/Platform instproc recv_announcement { addr port data size } {
	$self instvar lastann_ sdp_ agentbytype_ agenttab_ atype_
        set t [$self get_timer]
	$t sample_size $size
#puts ""
#puts "$self ($class): recv {$data}"
#puts ""
	set o [split $data \n]
	if { [lindex $o 0] != "ASCP v[AnnounceListenManager/AS version]" } {
		# FIXME
		set msg "$self ($class): received non-ASCP v[$class version] announcement from $addr."
		if { $atype_ == "hm" } {
			$self instvar agent_
			$agent_ log $msg
		} else {
			puts stderr $msg
		}

 		return
	}
	set atype [lindex $o 1]
	set aspec [lindex $o 2]
	set srv_name [lindex $o 3]
	set srv_loc [lindex $o 4]
	set srv_inst [lindex $o 5]
	set ssg_port [lindex $o 6]
	set ad [join [lrange $o 7 end] \n]

	# Special case death packet.
	if { $srv_name == "DEATH" } {
		set msg "Received death packet from $aspec at $addr - exiting."
		if { $srv_loc == $atype_ } {
			if { $atype_ == "hm" } {
				$self instvar agent_
				$agent_ log $msg
			} else {
				puts stderr $msg
			}
			$self announce_death
			exit 0
		}
		$self recv_msg $atype $aspec $addr DEATH $srv_loc \
			$srv_inst $ssg_port "$ad"
		return
	}
	# Synchronous bye
	if { $srv_name == "bye" } {
		$self delete_agent $aspec
		return
	}

	set pid [lindex [split $aspec @] 0]
	#puts "pid=$pid"
	set platformid [lindex [split $aspec @] 1]
	#puts "platformid=$platformid"
	set aspec $platformid
	if ![info exists agenttab_($aspec)] {
		# new agent
		$self instvar avgdelta_
		$self register $atype $aspec $addr $srv_name $srv_inst "$ad"
	        $t incr_nsrcs
		set timeout [$self get_option startupWait]
		set avgdelta_($aspec) [expr $timeout / 8]
		lappend agentbytype_($atype) $aspec
	} else {
		set now [gettimeofday]
		set delta [expr $now - $lastann_($aspec,abs)]
		$self instvar avgdelta_
		set avgdelta_($aspec) \
				[expr 0.875*$avgdelta_($aspec)+0.125*$delta]

	}
	set agenttab_($aspec) "$addr {$ad} $atype $srv_name $srv_inst"
	set lastann_($aspec,abs) [gettimeofday]
	set lastann_($aspec,ascii) [gettimeofday ascii]
	$self recv_msg $atype $aspec $addr $srv_name $srv_loc $srv_inst \
			$ssg_port "$ad"
}

AnnounceListenManager/AS/Client/Platform public get_platform_list {} {
	$self instvar platforms_

	return [array names platforms_]
}

# don't need?
AnnounceListenManager/AS/Client/Platform private recv_msg { atype aspec addr srv_name \
	        srv_loc srv_inst ssg_port msg } {

	# For now, this is the only type of message we should be
	# recving on the global channel
	switch $atype {
		platform {
			#puts "Got $aspec"
		}
		default {
			puts "Error: atype=$atype"
			exit
		}
	}
}

AnnounceListenManager/AS/Client/Platform instproc register { atype aspec addr srv_name srv_inst msg } {
	$self instvar platforms_

	#set platformid [lindex [split $aspec @] 1]
	# Eventually should include location info
	#puts "register $aspec"
	set platforms_($aspec) $aspec
}

# Careful, don't want to unregister whole platform just because one host unregs
AnnounceListenManager/AS/Client/Platform instproc unregister { atype aspec addr srv_name srv_inst ad } {
	$self instvar platforms_
	#set platformid [lindex [split $aspec @] 1]
	#puts "unregister $aspec"
	unset platforms_($aspec)

}
