/*
 * mb-baserreq.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mb/mb-baserreq.cc,v 1.14 2002/02/03 03:16:30 lim Exp $
 */

#include "mb/mb-obj.h"
#include "mb/mb-nethost.h"


static const int cNumMaxRequest = 20; // cancel after asking for 10 times
int MBRequest::fill_ADU(Byte* pb, int /*len*/)
{
  pPage_->UpdateRequest(snStart_, snEnd_);
  if (snStart_ > snEnd_) {
    pPage_->CancelRequest(this); // note: function will kill the object
    return 0;
  }

  numtimes_++;
  // Resend the request up to the maximum, we kill the request for the time
  // being. The sender could be dead or there is a network outage.
  // If more packets arrive indicating that the sender is alive
  // then the request will be re-created as usual.
  if (numtimes_>cNumMaxRequest) {
    pPage_->CancelRequest(this); // note: function will kill the object
    return 0;
  }

  Pkt_request* pPkt = (Pkt_request*) pb;
  host2net(srcId_, pPkt->pr_sid);
  host2net(pPage_->getId(), pPkt->pr_page);
  pPkt->pr_sseq=host2net(snStart_);
  pPkt->pr_eseq=host2net(snEnd_);
  Trace(VERBOSE, ("Send request for %lu to %lu for %d@%s",
	     snStart_, snEnd_, srcId_.ss_uid, intoa(srcId_.ss_addr)));

  char szLog[200];
  describe(szLog, 200);
  MBLOG(("s %s", szLog));
  return (sizeof(Pkt_request));
}

const PageId& MBRequest::PgId()
{
        return pPage_->getId();
}

#ifdef NDEBUG
void MBRequest::describe(char* szDesc, u_int /* len */)
#else
void MBRequest::describe(char* szDesc, u_int len)
#endif
{
        char *szPgId = PgId2Str(pPage_->getId());
        sprintf(szDesc, "rqt %x@%x %s %lu %lu ", srcId_.ss_uid,
                srcId_.ss_addr, szPgId, snStart_, snEnd_);
        assert(strlen(szDesc) < len && "overwrote buffer!");
        delete[] szPgId;
}


int
MBReply::fill_ADU(Byte* pb, int len)
{
  if (isDone_) return 0;
  /*
   * FIXME: this is tricky because of the way it is structured, since we
   * need to inform the application that the reply is done with the
   * ignore backoff period, so that it can remove it and stop the
   * ignore period. When this functionality is moved downwards to SRM,
   * hopefully we can remove this kludge
   */
  if (ignore_) {
         pPage_->CancelReply(this);
         return 0;
  }
  Trace(EXCESSIVE, ("#### fill_ADU(this=%p)", this));
  assert(snStart_<=snEnd_ && "someone should have cancelled this");
  Pkt_reply* pPkt = (Pkt_reply*)pb;
  host2net(origSId_, pPkt->pr_sid);
  int aduLen=0;
  ulong lastFilled =
    pPage_->FillReply(aduLen, (Byte*)(pPkt+1), len - sizeof(Pkt_reply),
		      snStart_, snEnd_);
  assert(aduLen && lastFilled && "should be able to fill it in");
  if (aduLen) {
    // next time, fill starting from the next
    char szLog[200];
    describe(szLog, 200, snStart_, lastFilled);
    MBLOG(("s %s", szLog));
    snStart_ = lastFilled + 1;
  }
  aduLen+=sizeof(Pkt_reply);
  if (snStart_>snEnd_) {
     // REVIEW: for partially filled replies, should also ignore the
     //         parts that have been sent

     // request has been fullfilled, keep this around for a while
     //    to ignore first try requests...
     MBLOG(("(%x) ignore rqt timer = %f", this, reply_done()));
  }
  //} else {
  // should kick the network again ?
  //}
  return aduLen;
}

void
#ifdef NDEBUG
MBReply::describe(char* szDesc, u_int /* len */, ulong snStart, ulong snEnd)
#else
MBReply::describe(char* szDesc, u_int len, ulong snStart, ulong snEnd)
#endif
{
        char *szPgId = PgId2Str(pPage_->getId());
        sprintf(szDesc, "rpy %x@%x %s %ld %ld", origSId_.ss_uid,
                origSId_.ss_addr, szPgId, snStart, snEnd);
        assert(strlen(szDesc) < len && "overwrote buffer!");
        delete[] szPgId;
}

