/*
 * mb-basemgr.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mb/mb-basemgr.cc,v 1.16 2002/02/03 03:16:30 lim Exp $
 */

#include "mb/mb-obj.h"
#include "mb/mb-nethost.h"


MBBaseMgr::MBBaseMgr()
	: SRM_AppMgr(NULL), phtReceivers_(NULL),
	  phtPages_(NULL), pReqSAs_(NULL), pDebugObjName_(NULL)
{
	phtReceivers_ = new Tcl_HashTable;
	if (!phtReceivers_) {
		SignalError(("Out of Memory!"));
		abort();
	}
	// SrcId must be a of size a multiple of int
	// otherwise we would use garbage as part of the keys
	assert((sizeof(SrcId)/sizeof(int))*sizeof(int) == sizeof(SrcId));
	Tcl_InitHashTable(phtReceivers_, sizeof(SrcId)/sizeof(int));


	// page table
	phtPages_ = new Tcl_HashTable;
	if (!phtPages_) {
		SignalError(("Out of Memory!"));
		abort();
	}
	// SrcId must be a of size a multiple of int
	// otherwise we would use garbage as part of the keys
	assert((sizeof(PageId)/sizeof(int))*sizeof(int) == sizeof(PageId));
	Tcl_InitHashTable(phtPages_, sizeof(PageId)/sizeof(int));

	pReqSAs_ = new MBStack<MBBaseRcvr*>(20);
}


/* virtual */
MBBaseMgr::~MBBaseMgr()
{
	// delete the receivers hash table
	Tcl_HashSearch hsearch;
	Tcl_HashEntry *pEntry = Tcl_FirstHashEntry(phtReceivers_, &hsearch);
	while (pEntry) {
		MBBaseRcvr *pRcvr = (MBBaseRcvr*)Tcl_GetHashValue(pEntry);
		delete pRcvr;
		pEntry=Tcl_NextHashEntry(&hsearch);
	}

	Tcl_DeleteHashTable(phtReceivers_);
	delete phtReceivers_;


	// delete the pages hash table
	// note: page objects are deleted in the receivers' destructors
	Tcl_DeleteHashTable(phtPages_);
	delete phtPages_;

	delete pReqSAs_;
}


void
MBBaseMgr::handle_SA(Byte *pb, u_int len)
{
	if (len==0) {
		Trace(VERBOSE,("Got a zero length SA! Ignored."));
		return;
	}
	Pkt_SA* pPkt = (Pkt_SA*) pb;
	SrcId srcId;
	net2host(pPkt->srcid, srcId);
	MBLOG(("r SA from %x@%s", srcId.ss_uid, intoa(srcId.ss_addr)));
	MTrace(trcMB|trcVerbose, ("recv'd SA of %d bytes from %d@%s",
			      len, srcId.ss_uid, intoa(srcId.ss_addr)));

	/*FIXME: should not need to create receivers for those who are
	 * not sources */
	MBBaseRcvr *pRcvr = DefineReceiver(srcId);
	if (pRcvr==NULL) {
		MTrace(trcMB|trcVerbose, ("application decided to ignore receiver"));
		return;
	}
	assert(pRcvr);

	int numPgs = net2host(pPkt->numPgs);
	if (len < sizeof(Pkt_SA) + (sizeof(Pkt_PgStatus)*numPgs)) {
		Trace(ALL,("SA is of wrong length!, ignored"));
		return;
	}
	pRcvr->HandleSA(pPkt->aPgStatus, numPgs);

	if (len > sizeof(Pkt_SA) + (sizeof(Pkt_PgStatus)*numPgs)) {
		Pkt_RcvrInfo* pInfoPkt = (Pkt_RcvrInfo*)
			(pb+sizeof(Pkt_SA)+numPgs*sizeof(Pkt_PgStatus));
		PageId pgId;
		net2host(pInfoPkt->currPageId, pgId);
		notifyCurrPage(srcId, pgId);
	}
}


void
#ifdef MB_DEBUG
MBBaseMgr::RequestSA(MBBaseRcvr *pRcvr)
#else
MBBaseMgr::RequestSA(MBBaseRcvr * /* pRcvr */)
#endif
{
	MTrace(trcMB|trcVerbose,
	       ("Request SA for receiver %d@%s", pRcvr->getSrcId().ss_uid,
		intoa(pRcvr->getSrcId().ss_addr)));

	// REVIEW: what should really happen is for refresh of initial state,
	//         send out the whole block and do supression.
	Tcl_HashSearch hsearch;
	Tcl_HashEntry *pEntry = Tcl_FirstHashEntry(phtReceivers_, &hsearch);
	while (pEntry) {
		MBBaseRcvr *pRcvr = (MBBaseRcvr*)Tcl_GetHashValue(pEntry);
		pReqSAs_->Push(pRcvr);
		pEntry=Tcl_NextHashEntry(&hsearch);
	}

	MB_DefTcl(tcl);
	// make the timers go off faster
	// REVIEW: this is a hack!
	if (session()->sa_timer()!=NULL && session()->sa_timer()->name()!=NULL)
		tcl.evalf("%s faster", session()->sa_timer()->name());
}


MBBaseRcvr*
MBBaseMgr::DefineReceiver(const SrcId &srcId, Bool *newFlag)
{
	int created;
	Tcl_HashEntry *pNewEntry =
		Tcl_CreateHashEntry(phtReceivers_, (char*)&srcId, &created);
	if (newFlag!=NULL) *newFlag = ((created) ? TRUE : FALSE);
	if (created) {
		MBBaseRcvr *pRcvr = NewReceiver(srcId, FALSE);
		if (pRcvr==NULL) {
			Tcl_DeleteHashEntry(pNewEntry);
			return NULL;
		}
		else {
			Tcl_SetHashValue(pNewEntry, (ClientData) pRcvr);
			return pRcvr;
		}
	} else {
		return (MBBaseRcvr*)Tcl_GetHashValue(pNewEntry);
	}
}


MBPageObject *
MBBaseMgr::DefinePage(const PageId &pid)
{
	int created;
	// remember we have seen such a page before
	Tcl_HashEntry* pEntry =
		Tcl_CreateHashEntry(phtPages_, (char*)&pid, &created);
	MBPageObject *pPage = NewPageObject(pid, ((created) ?
						  TRUE:FALSE));
	if (!pPage) {
		SignalError(("out of memory"));
		return NULL;        // return null page id
	}
	if (!created) {
		MBPageObject* pPage1 = (MBPageObject*)Tcl_GetHashValue(pEntry);
		pPage->targetTime(pPage1->targetTime());
	} else {
		Tcl_SetHashValue(pEntry, (ClientData)pPage);
	}

	return pPage;
}


SRM_PacketHandler *
MBBaseMgr::new_source(const srm_src &sid, int islocal)
{
	// just copying this code over from DefineReceiver, so I can pass the
	// correct isLocal flag to NewReceiver

	int created;
	Tcl_HashEntry *pNewEntry =
		Tcl_CreateHashEntry(phtReceivers_, (char*)&sid, &created);
	if (created) {
		MBBaseRcvr *pRcvr = NewReceiver(sid, ((islocal) ? TRUE:FALSE));
		if (pRcvr==NULL) {
			Tcl_DeleteHashEntry(pNewEntry);
			return NULL;
		}
		else {
			Tcl_SetHashValue(pNewEntry, (ClientData) pRcvr);
			return pRcvr;
		}
	} else {
		return (MBBaseRcvr*)Tcl_GetHashValue(pNewEntry);
	}
}


//
// handles a repair request from the net
//
/*virtual*/
void
#ifdef MB_DEBUG
MBBaseMgr::handle_request(const SrcId& sidRqtSrc, Byte *pb, int len)
#else
MBBaseMgr::handle_request(const SrcId& sidRqtSrc, Byte *pb, int /* len */)
#endif
{
	Trace(VERYVERBOSE,("recv request: %d bytes",len));
	Pkt_request* pPkt = (Pkt_request*) pb;
	assert(len==sizeof(Pkt_request));
	SrcId sidRqtTgt;
	net2host(pPkt->pr_sid, sidRqtTgt);
	MBBaseRcvr *pRcvr = DefineReceiver(sidRqtTgt);
	if (pRcvr==NULL) {
		Trace(VERBOSE, ("application decided to ignore receiver"));
		return;
	}
	assert(pRcvr);
	pRcvr->HandleRequest(sidRqtSrc, pPkt);
}


//
// handle a repair reply
//
/*virtual*/
void
MBBaseMgr::handle_reply(const SrcId& /*sidRpySrc*/, Byte *pb, int len)
{
	Pkt_reply* pPkt = (Pkt_reply*) pb;
	SrcId sidRpyTgt;
	net2host(pPkt->pr_sid, sidRpyTgt);
	MTrace(trcMB|trcVerbose,("recv reply: %d bytes from %d@%s\n",len,
			      sidRpyTgt.ss_uid, intoa(sidRpyTgt.ss_addr)));

	MBBaseRcvr *pRcvr = DefineReceiver(sidRpyTgt);
	if (pRcvr==NULL) {
		MTrace(trcMB|trcVerbose,
		       ("application decided to ignore receiver: %d@%s",
			sidRpyTgt.ss_uid, intoa(sidRpyTgt.ss_addr)));
		return;
	}
	assert(pRcvr);
	pRcvr->HandleReply((Byte*)(pPkt+1), len-sizeof(Pkt_reply));
}


// if a receiver has requested a SA, service them first, else
// ask the local receiver to send out the SA
/* virtual */
int
MBBaseMgr::periodic_update(Byte *pb)
{
	MBBaseRcvr* pRcvr=NULL;
	Bool resetTimer=TRUE;
	int len = 0;

	// there shouldn't be a lot of receivers who are requesting SA's
	// at the same time, so we use a stack, since that is easier
	// to implement, it should really be a queue
	if (pReqSAs_ && pReqSAs_->Pop(pRcvr)) {
		resetTimer=FALSE;
	}
	if (pRcvr!=NULL) {
		len = pRcvr->FillSA(pb, getMTU());
		Trace(VERYVERBOSE,("sending sa: of %d bytes",len));
		fprintf(stderr, "*** sending sa for %u@%s of %d bytes\n",
			pRcvr->getSrcId().ss_uid,
			intoa(pRcvr->getSrcId().ss_addr), len);
		MBLOG(("s sa"));
	}
	if (resetTimer) {
		MB_DefTcl(tcl);
		// REVIEW: this is a hack!
		// we accelerate the timer so that the requested SA's goes
		// out quickly one after another
		if (session()->sa_timer()!=NULL
		    && session()->sa_timer()->name()!=NULL)
			tcl.evalf("%s reset", session()->sa_timer()->name());
	}
	return len;
}



int
MBBaseMgr::command(int argc, const char*const* argv)
{
	if (!strcmp(argv[1], "attach_debug")) {
		if (argc < 2) {
			Tcl::instance().add_error("debug object not found");
			return TCL_ERROR;
		}
		if (pDebugObjName_) {
			Tcl_DecrRefCount(pDebugObjName_);
		} else {
			pDebugObjName_ =
				Tcl_NewStringObj((char*)argv[2], -1);
			Tcl_IncrRefCount(pDebugObjName_);
		}
		return TCL_OK;
	}
	return SRM_AppMgr::command(argc, argv);
}


#ifdef MB_DEBUG
// dumps all the timestamps and commands for the current page
void
MBBaseMgr::Dump(int dumptype, Tcl_Obj* pObj)
{
	Tcl_HashSearch hsearch;
	Tcl_HashEntry *pEntry = Tcl_FirstHashEntry(phtReceivers_, &hsearch);
	while (pEntry) {
		MBBaseRcvr *pRcvr = (MBBaseRcvr *)Tcl_GetHashValue(pEntry);
		// note: currMostRecentTS will be set to the more recent value
		//       if the receiver has a more recent item
		char szTmp[200];
		sprintf(szTmp, "\n --- Receiver: %d@%s --- \n",
			pRcvr->getSrcId().ss_uid,
			intoa(pRcvr->getSrcId().ss_addr));
		Tcl_AppendToObj(pObj, szTmp, -1);
		pRcvr->Dump(dumptype, pObj);
		pEntry=Tcl_NextHashEntry(&hsearch);
	}
}
#endif // MB_DEBUG

