# spoofamx-lib.tcl --
#
#       this can be used to spoof a response string from the AMX, to make it
#       look like a panel button was pushed
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

proc spoofResponse { cmd dev chan str } {
    switch -exact $cmd {
	1 -
	2 -
	3 -
	6 -
	7 -
	8 -
	9 - 
	10 -
	15 {
	    set retval [spoofSimpleResponse $cmd $dev $chan]
	}
	4 {
	    set retval [spoofStringResponse $cmd $dev $str]
	}
	default {
	    set retval "spoofing of response code $cmd not supported"
	}
    }
}

# this takes a string and converts the first character in it to an integer
#   in the range 0-255
#
# if the string is empty, returns an empty string
#
proc charToInt { ch } {
    set ascVal ""
    set numConv [binary scan $ch "c" ascVal]
    if {$numConv == 1} {
        if {$ascVal < 0} {
            # this is necessary because Tcl can't handle unsigned chars
            set ascVal [expr $ascVal + 256]
        }
    }
    return "$ascVal"
}

# takes a string and computes the checksum
#
# the checksum is the sum of all the ascii character values, (0-255), mod 255
#
proc computeChecksum { str } {
    set size [string length $str]
    set sum 0
    for {set x 0} {$x < $size} {incr x 1} {
	set tmp [charToInt [string index $str $x]]
	set sum [expr $sum + $tmp]
    }
    set sum [expr $sum % 256]
    return $sum
}

proc spoofSimpleResponse { cmd dev data } {
    set str [binary format "accc" "&" $cmd $dev $data]
    set checkSum [computeChecksum $str]
    set str [binary format "a*c" $str $checkSum]
    # str is now the string we want the computer to receive
    # 4 means send a string; 1 is the device to send it to, the computer
    set retval [send-AMX-command 4 1 $str]
    return $retval
}

proc spoofStringResponse { cmd dev strData } {
    set str [binary format "accc" "&" $cmd $dev [string length $strData]]
    append str $strData
    set checkSum [computeChecksum $str]
    set str [binary format "a*c" $str $checkSum]
    # 4 means send a string; 1 is the device to send it to, the computer
    set retval [send-AMX-command 4 1 $str]
    return $retval
}

