#!perl
#=======================================================================
#    ____  ____  _____              _    ____ ___   ____
#   |  _ \|  _ \|  ___|  _   _     / \  |  _ \_ _| |___ \
#   | |_) | | | | |_    (_) (_)   / _ \ | |_) | |    __) |
#   |  __/| |_| |  _|    _   _   / ___ \|  __/| |   / __/
#   |_|   |____/|_|     (_) (_) /_/   \_\_|  |___| |_____|
#
#   A Perl Module Chain to faciliate the Creation and Modification
#   of High-Quality "Portable Document Format (PDF)" Files.
#
#   Copyright 1999-2005 Alfred Reibenschuh <areibens@cpan.org>.
#
#=======================================================================
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the
#   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#   Boston, MA 02111-1307, USA.
#
#   $Id: Makefile.PL,v 1.26 2005/03/15 17:29:24 fredo Exp $
#
#=======================================================================

require 5.008;

use ExtUtils::MakeMaker;
use Getopt::Long;
use POSIX;

my $versionfile = "lib/PDF/API2/Version.pm";

require "$versionfile";

sub write_version ($) {
    my $hex=shift @_;
    my $tim=POSIX::strftime('%Y-%m-%d %H:%M:%S',localtime());
    my $dat=POSIX::strftime('%Y-%m-%d',localtime());
    my $name='PDF::API2';
    # hexversion = VVRRRTLL
    my $lev=sprintf('%02i',$hex & 0xff);
    my $typ=($hex>>8) & 0xf;
    my $rev=sprintf('%02i',($hex>>12) & 0xfff);
    my $ver=($hex>>24) & 0xff;
    my $ptyp=$typ;
    my $bld=$hex & 0xfff;
    my $tbld='';
    if($typ==0) {
        $ptyp='_'; $tbld="alpha-$bld"; $typ='a'; 
    } elsif($typ<5) {
        $ptyp='_'; $tbld="beta-$bld"; $typ='b'; 
    } elsif($typ<13) {
        $ptyp='_'; $tbld="gamma-$bld"; $typ='c'; 
    } elsif($typ==15) {
        $ptyp='.'; $tbld="fix-$bld"; $typ='.'; 
    } else {
        $ptyp='.'; $tbld="stable-$bld"; $typ='.'; 
    }
    my $triple="$ver.$rev$typ$lev";
    my $ptriple="$ver.$rev$ptyp$lev";
    my %hash=(
        'vHex'     => sprintf('0x%08X',$hex),
        'vShort'   => "$triple",
        'vLong'    => "$triple ($tim)",
        'vTeX'     => "This is $name, Version $triple ($tim)",
        'vGNU'     => "$name $triple ($tim)",
        'vWin'     => "$ver.$rev build $bld",
        'vPerl'    => "$ptriple",
        'vSquid'   => "$ver.$rev-$tbld",
        'vFredo'   => "$name $ptriple ($tbld / $dat)",
        'vWeb'     => "$name/$triple",
    );
    my $fh;
    open($fh,">$versionfile");
    print $fh <<'EOT';
#=======================================================================
#         _   _    :    ____  ____  _____      _    ____ ___   ____
#     _  |_|_|_|   :   |  _ \|  _ \|  ___|    / \  |  _ \_ _| |___ \
#    |_| _|_||_|   :   | |_) | | | | |_      / _ \ | |_) | |    __) |
#    _  |_||_|_|   :   |  __/| |_| |  _|    / ___ \|  __/| |   / __/
#   |_|  |_|_|_|   :   |_|   |____/|_|     /_/   \_\_|  |___| |_____|
#                  : 
#=======================================================================
package PDF::API2::Version;
BEGIN {
    use vars qw( $VERSION %CVersion );
EOT
    print $fh "    \$VERSION = '$hash{vPerl}';\n";
    print $fh "    \%CVersion = (\n";
    foreach my $k (sort keys %hash) {
    print $fh "        '$k' => '$hash{$k}',\n";
    $PDF::API2::Version::CVersion{$k}=$hash{$k};
    }
    print $fh "    );\n";
    print $fh <<'EOT';
}
1;
EOT
    print $fh "\n__END__\n# autogenerated file -- do not edit.\n\n=pod\n\n=head1 NAME\n\nPDF::API2::Version\n\n=head1 VERSION\n\n";
    foreach my $k (sort keys %hash) {
        printf $fh " %7s: $hash{$k} \n",$k;
    }
    print $fh "\n=cut\n\n";
    close($fh);
}

my @manify = qw[
    PDF/API2/Basic/PDF/Filter.pm   
    PDF/API2/Basic/PDF/Objind.pm 
    PDF/API2/Basic/PDF/String.pm
    PDF/API2/Basic/PDF/Number.pm 
    PDF/API2/Basic/PDF/Null.pm   
    PDF/API2/Basic/PDF/Bool.pm 
    PDF/API2/Basic/PDF/Page.pm
    PDF/API2/Basic/PDF/Array.pm 
    PDF/API2/Basic/PDF/Pages.pm   
    PDF/API2/Basic/PDF/Name.pm 
    PDF/API2/Basic/PDF/Utils.pm
    PDF/API2/Basic/PDF/Dict.pm 
    PDF/API2/Basic/PDF/File.pm 
    PDF/API2/Basic/TTF/Mort/Contextual.pm
    PDF/API2/Basic/TTF/Mort/Insertion.pm 
    PDF/API2/Basic/TTF/Mort/Rearrangement.pm 
    PDF/API2/Basic/TTF/Mort/Ligature.pm
    PDF/API2/Basic/TTF/Mort/Noncontextual.pm 
    PDF/API2/Basic/TTF/Mort/Subtable.pm 
    PDF/API2/Basic/TTF/Mort/Chain.pm
    PDF/API2/Basic/TTF/Kern/ClassArray.pm 
    PDF/API2/Basic/TTF/Kern/StateTable.pm
    PDF/API2/Basic/TTF/Kern/CompactClassArray.pm 
    PDF/API2/Basic/TTF/Kern/OrderedList.pm 
    PDF/API2/Basic/TTF/Kern/Subtable.pm
    PDF/API2/Basic/TTF/Maxp.pm   
    PDF/API2/Basic/TTF/Font.pm 
    PDF/API2/Basic/TTF/Ttopen.pm   
    PDF/API2/Basic/TTF/LTSH.pm
    PDF/API2/Basic/TTF/Loca.pm   
    PDF/API2/Basic/TTF/Fmtx.pm 
    PDF/API2/Basic/TTF/Name.pm   
    PDF/API2/Basic/TTF/Hmtx.pm
    PDF/API2/Basic/TTF/OldMort.pm   
    PDF/API2/Basic/TTF/Mort.pm 
    PDF/API2/Basic/TTF/Glyph.pm   
    PDF/API2/Basic/TTF/Post.pm
    PDF/API2/Basic/TTF/AATutils.pm   
    PDF/API2/Basic/TTF/Table.pm 
    PDF/API2/Basic/TTF/Delta.pm   
    PDF/API2/Basic/TTF/Ttc.pm
    PDF/API2/Basic/TTF/XMLparse.pm   
    PDF/API2/Basic/TTF/Vmtx.pm 
    PDF/API2/Basic/TTF/Hdmx.pm   
    PDF/API2/Basic/TTF/GSUB.pm
    PDF/API2/Basic/TTF/Head.pm   
    PDF/API2/Basic/TTF/Glyf.pm 
    PDF/API2/Basic/TTF/OS_2.pm   
    PDF/API2/Basic/TTF/PCLT.pm
    PDF/API2/Basic/TTF/Hhea.pm   
    PDF/API2/Basic/TTF/GDEF.pm 
    PDF/API2/Basic/TTF/GPOS.pm   
    PDF/API2/Basic/TTF/Anchor.pm
    PDF/API2/Basic/TTF/OldCmap.pm   
    PDF/API2/Basic/TTF/Fdsc.pm 
    PDF/API2/Basic/TTF/Feat.pm   
    PDF/API2/Basic/TTF/Cmap.pm
    PDF/API2/Basic/TTF/Prop.pm   
    PDF/API2/Basic/TTF/Segarr.pm 
    PDF/API2/Basic/TTF/Vhea.pm   
    PDF/API2/Basic/TTF/AATKern.pm
    PDF/API2/Basic/TTF/Fpgm.pm   
    PDF/API2/Basic/TTF/Prep.pm 
    PDF/API2/Basic/TTF/Coverage.pm   
    PDF/API2/Basic/TTF/Cvt_.pm
    PDF/API2/Basic/TTF/Bsln.pm   
    PDF/API2/Basic/TTF/Kern.pm 
    PDF/API2/Basic/TTF/Utils.pm
    PDF/API2/Resource/CIDFont/CJKFont.pm 
    PDF/API2/Resource/CIDFont/TrueType.pm 
    PDF/API2/Resource/Font/Postscript.pm
    PDF/API2/Resource/Font/BdFont.pm 
    PDF/API2/Resource/Font/CoreFont.pm 
    PDF/API2/Resource/Font/SynFont.pm
    PDF/API2/Resource/ColorSpace/Indexed/ACTFile.pm 
    PDF/API2/Resource/ColorSpace/Indexed/WebColor.pm
    PDF/API2/Resource/ColorSpace/Indexed/Hue.pm 
    PDF/API2/Resource/ColorSpace/Indexed.pm
    PDF/API2/Resource/XObject/Image/PNG.pm 
    PDF/API2/Resource/XObject/Image/GIF.pm 
    PDF/API2/Resource/XObject/Image/JPEG.pm
    PDF/API2/Resource/XObject/Image/TIFF.pm 
    PDF/API2/Resource/XObject/Image/PNM.pm 
    PDF/API2/Resource/XObject/Form/Hybrid.pm
    PDF/API2/Resource/XObject/Image.pm 
    PDF/API2/Resource/XObject/Form.pm 
    PDF/API2/Resource/CIDFont.pm
    PDF/API2/Resource/Font.pm   
    PDF/API2/Resource/ExtGState.pm 
    PDF/API2/Resource/ColorSpace.pm
    PDF/API2/Resource/XObject.pm 
    PDF/API2/Resource/BaseFont.pm 
    PDF/API2/Content/Text.pm   
    PDF/API2/HOWTO.pod
    PDF/API2/Content.pm   
    PDF/API2/Annotation.pm   
    PDF/API2/Page.pm 
    PDF/API2/Util.pm   
    PDF/API2/Outline.pm
    PDF/API2/Version.pm 
    PDF/API2/NamedDestination.pm   
    PDF/API2/Resource.pm 
    PDF/API2/Lite.pm   
    PDF/API2/Outlines.pm
    PDF/API2.pm
]; 

my %makehash=( 
    NAME         => "PDF::API2", 
    AUTHOR       => "areibens\@cpan.org", 
    ABSTRACT     => "TheNextGen PDF Create/Modify API", 
    dist         => { 
        ZIP      => "zip ", 
        ZIPFLAGS => " -v -o -r -9 ",
        COMPRESS => "gzip -9 -f ", 
    }, 
    MAN1PODS     => {}, 
    MAN3PODS     => 
    { 
        map 
        {
            my $file = "lib/$_";
            my $man = $_;
            $man =~ s!\.(pm|pod)$!!;
            $man =~ s!/!::!g;
            $man = "blib/man3/${man}.3pm";
            $file => $man;
        } 
        @manify
    }, 
    PREREQ_PM    => { 'Compress::Zlib' => 1.0, }, 
    VERSION_FROM => $versionfile, 
);

my $overide=undef;
my $version=undef;
my $build=undef;
my $release=undef;
my $alpha=undef;
my $beta=undef;
my $gamma=undef;
my $stable=undef;
my $fix=undef;
my $remake=undef;
my $usage=undef;

GetOptions(
    "override=s" => \$overide,
    "version|v" => \$version,
    "build|q" => \$build,
    "release|r" => \$release,
    "alpha|a" => \$alpha,
    "beta|b" => \$beta,
    "gamma|g" => \$gamma,
    "stable|s" => \$stable,
    "fix|f" => \$fix,
    "remake|m" => \$remake,
    "help|usage|h" => \$usage,
);

if($usage) {
    print <<EOT;
help for makefile.pl

    --override .version.    specify version
    --version/-v            increment version part
    --release/-r            increment release part
    --build/-q              increment build part
    --alpha/-a              increment to next alpha
    --beta/-b               increment to next beta
    --gamma/-g              increment to next gamma
    --stable/-s             increment to next stable
    --fix/-f                increment to next fix
    --remake/-m             remake version file
    --help/--usage/-h       print this
    
EOT
    exit(0);
}

if($overide) {
    write_version(hex($overide));
} elsif($build) {
    write_version(hex($PDF::API2::Version::CVersion{vHex})+1);
} elsif($release) {
    write_version((hex($PDF::API2::Version::CVersion{vHex}) & 0xffffff00)+(1<<12));
} elsif($version) {
    write_version((hex($PDF::API2::Version::CVersion{vHex}) & 0xff000f00)+(1<<24));
} elsif($alpha) {
    write_version((hex($PDF::API2::Version::CVersion{vHex}) & 0xfffff000)+(1<<12));
} elsif($beta) {
    my $hex=hex($PDF::API2::Version::CVersion{vHex});
    if((($hex>>8)&0xf) == 0) {
        write_version(($hex & 0xfffff0ff)+(1<<8)+1);
    } elsif((($hex>>8)&0xf) < 5) {
        write_version($hex+1);
    } else {
        write_version(($hex & 0xfffff000)+(1<<12)+(1<<8));
    }
} elsif($gamma) {
    my $hex=hex($PDF::API2::Version::CVersion{vHex});
    if((($hex>>8)&0xf) < 5) {
        write_version(($hex & 0xfffff0ff)+(5<<8)+1);
    } elsif((($hex>>8)&0xf) < 13) {
        write_version($hex+1);
    } else {
        write_version(($hex & 0xfffff000)+(1<<12)+(5<<8));
    }
} elsif($stable) {
    my $hex=hex($PDF::API2::Version::CVersion{vHex});
    if((($hex>>8)&0xf) < 13) {
        write_version(($hex & 0xfffff0ff)+(13<<8)+1);
    } else {
        write_version($hex+1);
    }
} elsif($fix) {
    my $hex=hex($PDF::API2::Version::CVersion{vHex});
    if((($hex>>8)&0xf) < 15) {
        write_version(($hex & 0xfffff0ff)+(15<<8)+1);
    } else {
        write_version($hex+1);
    }
} elsif($remake) {
    write_version(hex($PDF::API2::Version::CVersion{vHex}));
}
if($build | $release | $version | $overide | $alpha | $beta | $gamma | $stable | $remake) {
    system('perl ../cvs2cl.pl >NIL 2>NIL2');
}

$makehash{BINARY_LOCATION}=q|PDF-API2-|.$PDF::API2::Version::CVersion{vPerl}.q|.ppm.tar.gz|;

WriteMakefile( %makehash );

print STDERR $PDF::API2::Version::CVersion{vTeX}."\n";

exit;

sub MY::postamble{
    my $y=qq|ppmdist: pm_to_blib ppd dist\n|;
    $y.=qq|\t\$(MKPATH) \$(DISTNAME)-\$(VERSION)-PPM\n|;
    $y.=qq|\t\$(TAR) \$(TARFLAGS) \$(DISTNAME)-\$(VERSION)-PPM/\$(DISTNAME)-\$(VERSION).ppm.tar blib\n|;
    $y.=qq|\t\$(COMPRESS) \$(DISTNAME)-\$(VERSION)-PPM/\$(DISTNAME)-\$(VERSION).ppm.tar\n|;
    $y.=qq|\t\$(CP) \$(DISTNAME).ppd \$(DISTNAME)-\$(VERSION)-PPM/\$(DISTNAME).ppd\n|;
    $y.=qq|\t\$(ZIP) \$(ZIPFLAGS) \$(DISTNAME)-\$(VERSION).\$(OSNAME)-\$(OSVERS).ppm.zip \$(DISTNAME)-\$(VERSION)-PPM/\$(DISTNAME)-\$(VERSION).ppm.tar.gz \$(DISTNAME)-\$(VERSION)-PPM/\$(DISTNAME).ppd\n|;
    $y.=qq|\t\$(RM_RF) \$(DISTNAME)-\$(VERSION)-PPM\n|;
    $y.=qq|\n|;
    return($y);
}
__END__


