/* file generated by oo2c -- do not edit */
#include "__oo2c.h"

#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stddef.h>
#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>
#include "__mini_gc.h"

/* begin -- #include "OS:Files.d" */
#include "OS_Files.h"
#include "CharClass.h"
#include "LongStrings.h"

/* local definitions */
static OS_Files__ErrorContext OS_Files__errorContext;

/* function prototypes */

/* module and type descriptors */
static const struct {
  int length;
  void* pad;
  const char name[9];
} _n0 = {9, NULL, {"OS:Files"}};
static struct _MD OS_Files_md = {
  NULL, 
  &Kernel__ModuleDesc_td.td, 
  {
    NULL, 
    (const unsigned char*)_n0.name, 
    -1, 
    NULL
  }
};

static const struct {
  int length;
  void* pad;
  const char name[17];
} _n1 = {17, NULL, {"ErrorContextDesc"}};
static const struct {
  int length;
  void* pad;
  _Type btypes[2];
} OS_Files__ErrorContextDesc_tdb = {
  2, 
  NULL, 
  {
    &Msg__ContextDesc_td.td, 
    &OS_Files__ErrorContextDesc_td.td
  }
};
static const struct {
  int length;
  void* pad;
  const void* tbprocs[1];
} _tb0 = {1, NULL, {
  (void*)OS_Files__ErrorContextDesc_GetTemplate
}};
struct _TD OS_Files__ErrorContextDesc_td = {
  NULL,
  &Types__TypeDesc_td.td,
  {
    OS_Files__ErrorContextDesc_tdb.btypes,
    _tb0.tbprocs,
    (const unsigned char*)_n1.name,
    &OS_Files_md.md,
    1, 
    '0', '1',
    sizeof(OS_Files__ErrorContextDesc),
    NULL
  }
};

/* local strings */

/* end -- #include "OS:Files.d" */


#define BUFFER_SIZE 1024

static _ModId _mid;

void OS_Files__ErrorContextDesc_GetTemplate(OS_Files__ErrorContext context, Msg__Msg msg, Msg__LString templ, LONGINT templ_0d) {
  char *str;
  LONGINT res = msg->code;
  
  if (res == OS_Files__accessDenied) {
    str = "No write permission for parent directory";
  } else if (res == OS_Files__fileExists) {
    str = "A file of this name already exists";
  } else if (res == OS_Files__writeError) {
    str = "Write error";
  } else if (res == OS_Files__fileBusy) {
    str = "File in use";
  } else if (res == OS_Files__noSuchFile) {
    str = "File does not exist";
  }

  _string_copy2l(templ, str, templ_0d);
  if (msg->attribList) {
    Msg__Attribute attr;
    LONGCHAR eol[2] = {(LONGCHAR)CharClass__eol, (LONGCHAR)0};
    LONGCHAR str16[Msg__sizeAttrName+1];
    
    /*LongStrings__Append(eol, 2, templ, templ_0d);*/
    attr = msg->attribList;
    while (attr) {
      LongStrings__Append(eol, 2, templ, templ_0d);
      _string_copy2l(str16, (char*)attr->name, strlen((char*)attr->name)+1);
      LongStrings__Append(str16, Msg__sizeAttrName+1, templ, templ_0d);
      _string_copy2l(str16, "=${", 4);
      LongStrings__Append(str16, Msg__sizeAttrName+1, templ, templ_0d);
      _string_copy2l(str16, (char*)attr->name, strlen((char*)attr->name)+1);
      LongStrings__Append(str16, Msg__sizeAttrName+1, templ, templ_0d);
      _string_copy2l(str16, "}", 2);
      LongStrings__Append(str16, Msg__sizeAttrName+1, templ, templ_0d);
      attr = attr->nextAttrib;
    }
  }
}


static Msg__Msg get_error(const OS_Files__Path path) {
  Msg__Msg msg;
  LONGINT code;
  
  switch (errno) {
  case EACCES: code = OS_Files__accessDenied; break;
  case EBUSY: code = OS_Files__fileBusy; break;
  case EEXIST: code = OS_Files__fileExists; break;
  case ENOENT: code = OS_Files__noSuchFile; break;
  default: code = OS_Files__writeError;
  }
  
  msg = Msg__New((Msg__Context)OS_Files__errorContext, code);
  DYN_TBCALL(Msg,MsgDesc,SetStringAttrib,msg,
	     (msg, (const Msg__String)"path", 5, (OOC_CHAR*)path));
#if HAVE_STRERROR
  DYN_TBCALL(Msg,MsgDesc,SetStringAttrib,msg,
	     (msg, (const Msg__String)"errstr", 7, (OOC_CHAR*)strerror(errno)));
#endif
  DYN_TBCALL(Msg,MsgDesc,SetIntAttrib,msg,
	     (msg, (const Msg__String)"errno", 6, (LONGINT)errno));
  return msg;
}


static void extend_result(OS_Files__NameArray *result, int *result_len,
			  OS_Files__Name buffer[], int buffer_len) {
  int len=*result_len+buffer_len;
  char* ptr;
  int i;
  OS_Files__NameArray newResult;
  
  ptr = GC_malloc(len*sizeof(OS_Files__Name)+8);
  *((LONGINT*)ptr) = len;
  newResult = (OS_Files__NameArray)(ptr+8);
  
  if (*result != NULL) {
    for(i = 0; i != *result_len; i++) {
      newResult[i] = *result[i];
    }
  }
  for(i = 0; i != buffer_len; i++) {
    newResult[i + *result_len] = buffer[i];
  }
  
  *result = newResult;
  *result_len += buffer_len;
}

#define DIRENT_BUFFER 1024
OS_Files__NameArray OS_Files__listdir(const OS_Files__Path path__ref,
				      LONGINT path_0d, Msg__Msg *res) {
  DIR* dir;

  dir = opendir(path__ref);
  if (dir != NULL) {
    OS_Files__Name buffer[DIRENT_BUFFER];
    OS_Files__NameArray result = NULL;
    int result_len = 0;
    struct dirent *de;
    
    int i=0;
    while (1) {
      int len;
      char* ptr;
      
      de = readdir(dir);
      if (de == NULL) {  /* read all entries */
	break;
      } else if ((de->d_name[0] == '.') && 
	  ((de->d_name[1] == '\000') ||
	   ((de->d_name[1] == '.') && (de->d_name[2] == '\000')))) {
	/* omit "." and ".." */
      } else {
	if (i == DIRENT_BUFFER) {
	  extend_result(&result, &result_len, buffer, i);
	  i = 0;
	}
	len = strlen(de->d_name);
	ptr = GC_malloc(len+1+8);
	*((LONGINT*)ptr) = len+1;
	buffer[i] = (OS_Files__Name)(ptr+8);
	strcpy(buffer[i], de->d_name);
	i++;
      }
    }
    closedir(dir);

    *res = OS_Files__done;
    extend_result(&result, &result_len, buffer, i);
    return result;
  } else {
    *res = get_error(Msg__GetStringPtr(path__ref, path_0d));
    return NULL;
  }
}

void OS_Files__mkdir(const OS_Files__Path path, LONGINT path_0d,
                     OS_Files__Mode mode, Msg__Msg *res) {
  int rc;

  rc = mkdir((const char*)path, mode);
  if (rc) {
    *res = get_error(Msg__GetStringPtr(path, path_0d));
  } else {
    *res = OS_Files__done;
  }
}

void OS_Files__makedirs(const OS_Files__Path path, LONGINT path_0d,
                        OS_Files__Mode mode, Msg__Msg *res) {
  int rc;
  struct stat sbuf;
  
  if (path[0] == '\000') {	/* empty path --> no operation */
    *res = OS_Files__done;
    return;
  }
  
  rc = stat((const char*)path, &sbuf);
  if (rc) {			/* stat failure: file does not exist */
    OOC_CHAR ppath[BUFFER_SIZE];
    int i;
    int last = 0;
    
    for (i = 0; (i < BUFFER_SIZE) && (path[i] != '\000'); i++) {
      ppath[i] = path[i];
      if ((path[i] == '/') && (i > 0) && (path[i-1] != '/')) {
	last = i;
      }
    }
    ppath[last] = '\000';
    OS_Files__makedirs(ppath, BUFFER_SIZE, mode, res);
    if (*res == OS_Files__done) {
      OS_Files__mkdir(path, path_0d, mode, res);
    }
    
  } else {			/* stat successful: file exists */
    if (S_ISDIR(sbuf.st_mode)) {
      *res = OS_Files__done;	/* path exists and is directory */
    } else {
      /* path is not directory: let mkdir get the error message */
      OS_Files__mkdir(path, path_0d, mode, res);
    }
  }
}

void OS_Files__remove(const OS_Files__Path path, LONGINT path_0d,
                      Msg__Msg *res) {
  int rc;

  rc = unlink((const char*)path);
  if (rc) {
    *res = get_error(Msg__GetStringPtr(path, path_0d));
  } else {
    *res = OS_Files__done;
  }
}

void OS_Files_init(void) {
  _mid = _register_module(&OS_Files_md.md, &OS_Files__ErrorContextDesc_td.td);
  
  NEW_REC(OS_Files__errorContext,OS_Files__ErrorContextDesc);
  Msg__InitContext((Msg__Context)OS_Files__errorContext, 
		   (const Msg__String)"OS:Files", 15);
}
