/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.list.UnmodifiableList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IteratorChain
implements Iterator {
    protected final List iteratorChain;
    protected int currentIteratorIndex;
    protected Iterator currentIterator;
    protected Iterator lastUsedIterator;
    protected boolean isLocked;

    public void addIterator(Iterator iterator) {
        this.checkLocked();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iteratorChain.add(iterator);
    }

    public void setIterator(int index, Iterator iterator) throws IndexOutOfBoundsException {
        this.checkLocked();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iteratorChain.set(index, iterator);
    }

    public List getIterators() {
        return UnmodifiableList.decorate(this.iteratorChain);
    }

    public int size() {
        return this.iteratorChain.size();
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    private final void checkLocked() {
        if (this.isLocked) {
            throw new UnsupportedOperationException("IteratorChain cannot be changed after the first use of a method from the Iterator interface");
        }
    }

    private final void lockChain() {
        if (!this.isLocked) {
            this.isLocked = true;
        }
    }

    protected void updateCurrentIterator() {
        if (this.currentIterator == null) {
            this.currentIterator = this.iteratorChain.isEmpty() ? EmptyIterator.INSTANCE : (Iterator)this.iteratorChain.get(0);
            this.lastUsedIterator = this.currentIterator;
        }
        while (!this.currentIterator.hasNext() && this.currentIteratorIndex < this.iteratorChain.size() - 1) {
            ++this.currentIteratorIndex;
            this.currentIterator = (Iterator)this.iteratorChain.get(this.currentIteratorIndex);
        }
    }

    public boolean hasNext() {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.hasNext();
    }

    public Object next() {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.next();
    }

    public void remove() {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator.remove();
    }

    private final /* synthetic */ void this() {
        this.iteratorChain = new ArrayList();
        this.currentIteratorIndex = 0;
        this.currentIterator = null;
        this.lastUsedIterator = null;
        this.isLocked = false;
    }

    public IteratorChain() {
        this.this();
    }

    public IteratorChain(Iterator iterator) {
        this.this();
        this.addIterator(iterator);
    }

    public IteratorChain(Iterator a, Iterator b) {
        this.this();
        this.addIterator(a);
        this.addIterator(b);
    }

    public IteratorChain(Iterator[] iterators) {
        this.this();
        int i = 0;
        while (i < iterators.length) {
            this.addIterator(iterators[i]);
            ++i;
        }
    }

    public IteratorChain(Collection iterators) {
        this.this();
        Iterator it = iterators.iterator();
        while (it.hasNext()) {
            Iterator item = (Iterator)it.next();
            this.addIterator(item);
        }
    }
}

