/***************************************************************************
 $RCSfile: command.h,v $
                             -------------------
    cvs         : $Id: command.h,v 1.3 2003/02/05 11:59:57 aquamaniac Exp $
    begin       : Tue Dec 03 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef CMD_COMMAND_H
#define CMD_COMMAND_H "$Id"

#ifdef __cplusplus
extern "C" {
#endif


#define CTCOMMAND_RESULT_OK                 0
#define CTCOMMAND_RESULT_BAD_TYPE           1
#define CTCOMMAND_RESULT_BAD_ARGNUM         2
#define CTCOMMAND_RESULT_BAD_ARGUMENT       3
#define CTCOMMAND_RESULT_BUFFER_TOO_SMALL   4
#define CTCOMMAND_RESULT_BAD_CONFIG         5
#define CTCOMMAND_RESULT_INTERNAL           7
#define CTCOMMAND_RESULT_COMMMAND_NOT_FOUND 8
#define CTCOMMAND_RESULT_COMMMAND_EXISTS    9
#define CTCOMMAND_RESULT_BAD_CHAR           10


#include <chameleon/conf.h>


int CTCommand_MakeAPDU(CONFIGGROUP *root,
		       const char *command,
		       int argc,
		       char **argv,
		       unsigned char *buffer,
		       int *bufferlen);

int CTCommand_MakeAPDU2(CONFIGGROUP *root,
			const char *command,
			unsigned char *buffer,
			int *bufferlen,
			int argc, ...);


int CTCommand_Locate(CONFIGGROUP *root,
		     const char *readertype,
		     const char *cardtype,
                     const char *command,
		     char *buffer,
		     int bufferlen);

int CTCommand_Check(CONFIGGROUP *root,
		    const char *command);

int CTCommand_Add(CONFIGGROUP *root,
		  CONFIGGROUP *cfg);

#ifdef __cplusplus
}
#endif


#endif
