/***************************************************************************
 $RCSfile: ctmisc.h,v $
                             -------------------
    cvs         : $Id: ctmisc.h,v 1.4 2003/04/24 01:43:28 aquamaniac Exp $
    begin       : Fri May 31 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 Changes

 */


#ifndef CTMISC_H
#define CTMISC_H

class CTMisc;

#include <string>

using namespace std;

/**
 * This class supplies some usefull methods which don't fit into a
 * particular class or which would fit into all ;-)
 * @author Martin Preuss<martin@libchipcard.de>
 */
class CHIPCARD_API CTMisc {
public:
    CHIPCARD_API static string num2string(int n, const string &format="%d");
    CHIPCARD_API static int string2num(const string &n, const string &format="%d");
    CHIPCARD_API static bool compare(const string &s1, const string &s2);
    CHIPCARD_API static unsigned int bsd2int(unsigned char c);
    CHIPCARD_API static string bsd2string(unsigned char c);
    CHIPCARD_API static string bsd2string(const string &s);
    CHIPCARD_API static string string2bsd(const string &s);
    CHIPCARD_API static void removeBlanks(string &s);
    CHIPCARD_API static string bin2hex(const string &s, int groups=0);
    CHIPCARD_API static string hex2bin(const string &s);

};




#endif







