/*
    ldapdiff
    Copyright (C) 2000-2002 Thomas.Reith@rhoen.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <lber.h>
#include <ldap.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ldapdiff.h"

static void cmodentry(struct s_modentry **smodentry,char *var,char *val,size_t val_len,teattrtype val_type,temodentry emodentry)
{
 struct s_modentry *tsmodentry;

 if(var == NULL || val == NULL){
  return;
 }

 tsmodentry           = LDALLOC(1,sizeof(struct s_modentry));
 tsmodentry->var      = LDDUP(var);
 tsmodentry->val      = LDBINDUP(val,val_len);
 tsmodentry->val_len  = val_len;
 tsmodentry->val_type = val_type;
 tsmodentry->modtype  = emodentry;

 if(*smodentry == NULL){
  *smodentry = tsmodentry;
 }
 else{
  struct s_modentry *usmodentry;
  usmodentry = *smodentry;
  while(usmodentry != NULL){
   if(usmodentry->next == NULL){
    usmodentry->next = tsmodentry;
    return;
   }
   usmodentry = usmodentry->next;
  }
 }
}

static void cmod(struct s_mod **smod,char *dnvar,char *dnval,char *var,char *val,size_t val_len,teattrtype val_type,temod emod,temodentry emodentry)
{
 struct s_mod *psmod;
 struct s_mod *tsmod;

 psmod = *smod;
 while(psmod != NULL){
  if(strcmp(psmod->dnval,dnval) == 0){
   cmodentry(&psmod->attrlist,var,val,val_len,val_type,emodentry);
   return;
  }
  psmod = psmod->next;
 }  

 tsmod          = LDALLOC(1,sizeof(struct s_mod));
 tsmod->dnvar   = LDDUP(dnvar);
 tsmod->dnval   = LDDUP(dnval);
 tsmod->modtype = emod;

 cmodentry(&tsmod->attrlist,var,val,val_len,val_type,emodentry);
 if(*smod == NULL){
  *smod = tsmod;
 }
 else{
  struct s_mod *usmod;
  usmod = *smod;
  while(usmod != NULL){
   if(usmod->next == NULL){
    usmod->next = tsmod;
    return;
   }
   usmod = usmod->next;
  }
 }
}

static void ldifldapsinglecmp(struct s_ldif *sldif,struct s_ldif *sldap,struct s_mod **smod,struct s_schema *sschema)
{
 struct s_ldifentry *psldifentry;
 struct s_ldifentry *psldapentry;
 int                 attr_found;
 int                 val_found;

 psldifentry = sldif->attrlist; 
 while(psldifentry != NULL){
  if(ldifcheckignore(psldifentry->var) == ATTRIGNORE){
   ldiflog(LOG2,"ignore  attr: %s",sldif->dnval);
   ldiflogval(LOG2,"              %s: %s",psldifentry->var,psldifentry->val,psldifentry->val_len);
  }
  else if(ldifschemamulti(sschema,psldifentry->var) == 0){

   attr_found  = 0;
   psldapentry = sldap->attrlist;
   while(psldapentry != NULL){

    if(strcasecmp(psldifentry->var,psldapentry->var) == 0){
     attr_found  = 1;
     val_found   = 0;
     
     if(psldifentry->val_len == psldapentry->val_len){
      if(memcmp(psldifentry->val,psldapentry->val,psldifentry->val_len) == 0){
       val_found   = 1;
      }
     }

     if(val_found == 0){
      /* case 1: single attribute is different in ldif file */
      cmod(smod,sldif->dnvar,sldif->dnval,psldifentry->var,psldifentry->val,psldifentry->val_len,psldifentry->val_type,MODMODIFY,MODENTRYREPLACE);
      ldiflog(LOG2,"replace attr: %s",sldif->dnval);
      ldiflogval(LOG2,"              %s: %s ->",psldapentry->var,psldapentry->val,psldapentry->val_len);
      ldiflogval(LOG2,"              %s: %s",psldifentry->var,psldifentry->val,psldifentry->val_len);
     }
    }
    psldapentry = psldapentry->next;
   }
   if(attr_found == 0){
    /* case 2: single attribute doesn't exist in ldap */
    cmod(smod,sldif->dnvar,sldif->dnval,psldifentry->var,psldifentry->val,psldifentry->val_len,psldifentry->val_type,MODMODIFY,MODENTRYADD);
    ldiflog(LOG2,"add (s) attr: %s",sldif->dnval);
    ldiflogval(LOG2,"              %s: %s",psldifentry->var,psldifentry->val,psldifentry->val_len);
   }
  }
  psldifentry = psldifentry->next;
 } 

 psldapentry = sldap->attrlist;
 while(psldapentry != NULL){
  if(ldifcheckignore(psldapentry->var) == ATTRIGNORE){
   ldiflog(LOG2,"ignore  attr: %s",sldap->dnval);
   ldiflogval(LOG2,"              %s: %s",psldapentry->var,psldapentry->val,psldapentry->val_len);
  }
  else if(ldifschemamulti(sschema,psldapentry->var) == 0){

   psldifentry = sldif->attrlist; 
   attr_found  = 0;
   while(psldifentry != NULL){

    if(strcasecmp(psldapentry->var,psldifentry->var) == 0){
     attr_found++;
    }

    psldifentry = psldifentry->next;
   }
   if(attr_found == 0){
    /* case 3: single attribute doesn't exist in ldif */
    if(strcmp(ldifgetpconf(CONFDELETEATTRIBUTE),"yes") == 0){ 
     cmod(smod,sldap->dnvar,sldap->dnval,psldapentry->var,psldapentry->val,psldapentry->val_len,psldapentry->val_type,MODMODIFY,MODENTRYDELETE);
     ldiflog(LOG2,"del (s) attr: %s",sldap->dnval);
     ldiflogval(LOG2,"              %s: %s",psldapentry->var,psldapentry->val,psldapentry->val_len);
    }
    else{
     ldiflog(LOG2,"deletion disabled: %s",sldap->dnval);
    }
   }
  }
  psldapentry = psldapentry->next;
 }
}

static void ldifldapmulticmp(struct s_ldif *sldif,struct s_ldif *sldap,struct s_mod **smod,struct s_schema *sschema)
{
 struct s_ldifentry *psldifentry;
 struct s_ldifentry *psldapentry;
 int                 attr_found;
 int                 val_found;

 psldifentry = sldif->attrlist; 
 while(psldifentry != NULL){
  if(ldifcheckignore(psldifentry->var) == ATTRIGNORE){
   ldiflog(LOG2,"ignore  attr: %s",sldif->dnval);
   ldiflogval(LOG2,"              %s: %s",psldifentry->var,psldifentry->val,psldifentry->val_len);
  }
  else if(ldifschemamulti(sschema,psldifentry->var) == 1){
   psldapentry = sldap->attrlist;
   attr_found  = 0;
   while(psldapentry != NULL){
    if(strcasecmp(psldifentry->var,psldapentry->var) == 0){ 
     val_found   = 0;

     if(psldifentry->val_len == psldapentry->val_len){
      if(memcmp(psldifentry->val,psldapentry->val,psldifentry->val_len) == 0){
       val_found   = 1;
      }
     }

     if(val_found == 1){
      attr_found++;
     }
    }
    psldapentry = psldapentry->next;
   }
   if(attr_found == 0){
    /* case 4: multible attribute doesn't exist in ldap */
    cmod(smod,sldif->dnvar,sldif->dnval,psldifentry->var,psldifentry->val,psldifentry->val_len,psldifentry->val_type,MODMODIFY,MODENTRYADD);
    ldiflog(LOG2,"add (m) attr: %s",sldif->dnval);
    ldiflogval(LOG2,"              %s: %s",psldifentry->var,psldifentry->val,psldifentry->val_len);
   }
  }
  psldifentry = psldifentry->next;
 }

 psldapentry = sldap->attrlist;
 while(psldapentry != NULL){
  if(ldifcheckignore(psldapentry->var) == ATTRIGNORE){
   ldiflog(LOG2,"ignore  attr: %s",sldap->dnval);
   ldiflogval(LOG2,"              %s: %s",psldapentry->var,psldapentry->val,psldapentry->val_len);
  }
  else if(ldifschemamulti(sschema,psldapentry->var) == 1){
   psldifentry = sldif->attrlist;
   attr_found  = 0;
   while(psldifentry != NULL){
    if(strcasecmp(psldapentry->var,psldifentry->var) == 0){
     val_found   = 0;

     if(psldapentry->val_len == psldifentry->val_len){
      if(memcmp(psldapentry->val,psldifentry->val,psldapentry->val_len) == 0){
       val_found = 1;
      }
     }

     if(val_found == 1){
      attr_found++;
     }
    }
    psldifentry = psldifentry->next;
   }
   if(attr_found == 0){
    /* case 5: multible attribute doesn't exist in ldif */
    if(strcmp(ldifgetpconf(CONFDELETEATTRIBUTE),"yes") == 0){
     cmod(smod,sldap->dnvar,sldap->dnval,psldapentry->var,psldapentry->val,psldapentry->val_len,psldapentry->val_type,MODMODIFY,MODENTRYDELETE);
     ldiflog(LOG2,"del (m) attr: %s",sldap->dnval);
     ldiflogval(LOG2,"              %s: %s",psldapentry->var,psldapentry->val,psldapentry->val_len);
    }
    else{
     ldiflog(LOG2,"deletion disabled: %s",sldap->dnval);
    }
   }
  }
  psldapentry = psldapentry->next;
 }
}

void ldifcmp(struct s_ldif *sldif,struct s_ldif *sldap,struct s_mod **smod,struct s_schema *sschema)
{
 ldifldapsinglecmp(sldif,sldap,smod,sschema); 
 ldifldapmulticmp(sldif,sldap,smod,sschema); 
}

void ldifadddn(struct s_ldif *sldif,struct s_mod **smod)
{
 struct s_ldifentry *psldifentry; 

 psldifentry = sldif->attrlist;
 while(psldifentry != NULL){
  if(ldifcheckignore(psldifentry->var) == ATTRIGNORE){
   ldiflog(LOG2,"ignore  attr: %s",sldif->dnval);
   ldiflogval(LOG2,"              %s: %s",psldifentry->var,psldifentry->val,psldifentry->val_len);
  }
  else{
   cmod(smod,sldif->dnvar,sldif->dnval,psldifentry->var,psldifentry->val,psldifentry->val_len,psldifentry->val_type,MODADD,MODENTRYADD);
   ldiflog(LOG2,"add    entry: %s",sldif->dnval);
   ldiflogval(LOG2,"              %s: %s",psldifentry->var,psldifentry->val,psldifentry->val_len);
  }
  psldifentry = psldifentry->next;
 }
}

void ldifdeletedn(char *dnvar,char *dnval,struct s_mod **smod)
{
 if(strcmp(ldifgetpconf(CONFDELETEENTRY),"yes") == 0){ 
  cmod(smod,dnvar,dnval,NULL,NULL,0,0,MODDELETE,MODENTRYDELETE); 
  ldiflog(LOG2,"del    entry: %s",dnval);
 }
 else{
  ldiflog(LOG2,"deletion disabled: %s",dnval);
 }
}
