//LabPlot : GraphIMAGE.cc

#include <stdlib.h>
#include <iostream>
#include <qimage.h>
#include <kdebug.h>
#include "GraphIMAGE.h"

using namespace std;

GraphIMAGE::GraphIMAGE(QString n, QString l, LRange r[3], LSource src, PType t, Style st,
		Symbol sy, QPixmap pm,int dimx, int dimy, bool s)
	: Graph(n,l,src,t,st,sy,dimx*dimy,s)
{
	//kdDebug()<<"NX = "<<dimx<<" / NY = "<<dimy<<endl;
	range = new LRange[3];

	if(r) {
		range[0].setMin(r[0].rMin());
		range[0].setMax(r[0].rMax());
		range[1].setMin(r[1].rMin());
		range[1].setMax(r[1].rMax());
		range[2].setMin(r[2].rMin());
		range[2].setMax(r[2].rMax());
	}

	pixmap = pm;
}

void GraphIMAGE::save(QTextStream *t) {
	saveGraph(t);

	*t<<range[0].rMin()<<' '<<range[0].rMax()<<endl;
	*t<<range[1].rMin()<<' '<<range[1].rMax()<<endl;
	*t<<range[2].rMin()<<' '<<range[2].rMax()<<endl;
	*t<<type<<' ';
	style.save(t);
	symbol.save(t);

	// save pixmap
#if QT_VERSION > 0x030102
	pixmap.save(t->device(),"BMP");
	*t<<endl;
#endif
}

void GraphIMAGE::open(QTextStream *t, int version) {
	openGraph(t,version);

	double zmin, zmax;
	*t>>zmin>>zmax;
	range[0].setMin(zmin); range[0].setMax(zmax);
	*t>>zmin>>zmax;
	range[1].setMin(zmin); range[1].setMax(zmax);
	*t>>zmin>>zmax;
	range[2].setMin(zmin); range[2].setMax(zmax);

	type = (PType) style.open(t,version);
	symbol.open(t,version);

	// read pixmap
#if QT_VERSION > 0x030102
	int len = (int) (3*range[0].rMax()*range[1].rMax())+55;
	kdDebug()<<"reading pixmap of size "<<len<<endl;
	char *buf = new char[len];;
	t->readRawBytes(buf,len);
	pixmap.loadFromData((const uchar *)buf,len);
#endif
}

QStringList GraphIMAGE::Info(){
	QStringList s;
	QString t=i18n("Surface");

	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");

	s << name << t << sh;
	s << QString::number(range[0].rMin())+ " .. " + QString::number(range[0].rMax());
	s << QString::number(range[1].rMin())+ " .. " + QString::number(range[1].rMax());
	s << QString::number(range[2].rMin())+ " .. " + QString::number(range[2].rMax());

	return s;
}
