*
* $Id: fxg160.F,v 1.1.1.3 1996/11/15 17:32:41 cernlib Exp $
*
* $Log: fxg160.F,v $
* Revision 1.1.1.3  1996/11/15 17:32:41  cernlib
* Import version 7.06
*
* Revision 1.2  1996/11/15 15:06:59  pdflib
* Version 7.06: tabs removed and bug fixed in grsgalo
*
* Revision 1.1.1.1  1996/04/12 15:29:17  plothow
* Version 7.01
*
*
#include "pdf/pilot.h"
C
C------------------------------------------------------------
C------------- Subroutine to compute a point in x and q**2 --
C------------- for the following parton distributions :    --
C------------- UP Valence, DOWN Valence , GLUON , QBAR ,   --
C------------- UBAR , Strange , Charm , Bottom , Top .     --
C------------- Range of validity :                         --
C-------------                     5.E-05 < x < .95        --
C-------------                     1      <Log10 Q**2 < 8  --
C------------------------------------------------------------
C-------------        Authors :    M. Diemoz
C-------------                     F. Ferroni
C-------------                     E. Longo
C-------------                     G. Martinelli
C------------------------------------------------------------
      SUBROUTINE  FXG160(X,QSTAR2,STRFUN,FUNC)
C------------------------------------------------------------
C-------------   X is x and QSTAR2 is Q square  -------------
      CHARACTER*(*) STRFUN
C------------------------------------------------------------
C------------ STRFUN specifies the desired function----------
C------------------------------------------------------------
C------------------------------------------------------------
C        IFUN =  1     UP valence      'UPVAL'
C                2     DOWN valence    'DOVAL'
C                3     Gluon           'GLUON'
C                4     Q bar           'QBAR '
C                5     UP bar          'UBAR '
C                6     Strange         'SBAR '
C                7     Charm           'CBAR '
C                8     Bottom          'BBAR '
C                9     Top             'TBAR '
C------------------------------------------------------------
C-------------  FUNC is the output (parton density value)----
C------------------------------------------------------------
      PARAMETER (IX=104,IQ=9,NARG=2,KFUN=9)
C------------------------------------------------------------
C-----------Input tables are given as 104 x points at 9 Q**2
C-----------positions (log spaced in Q**2 and x up to .6
C-----------(90 points). The remaining 14 x points are ------
C----------linearly spaced)----------------------------------
C------------------------------------------------------------
      DIMENSION ARG(NARG),NENT(NARG),ENT(IX+IQ)
      DIMENSION XQDUM(IX,IQ,KFUN)
      DIMENSION Q2(IQ),XCO(IX)
C------------------------------------------------------------
C----------- Next the 9 Q**2 of the input tables are defined
C------------------------------------------------------------
      DATA Q2 /10.,30.,100.,1000.,10000.,100000.,1000000,
     +         10000000.,100000000./
C----------------------------------------------------------------
C----------- And now the 104 x positions ------------------------
C----------------------------------------------------------------
      DATA XCO   /
     +0.5000E-04,0.5545E-04,0.6150E-04,0.6820E-04,0.7564E-04,0.8389E-04,
     +0.9303E-04,0.1032E-03,0.1144E-03,0.1269E-03,0.1407E-03,0.1561E-03,
     +0.1731E-03,0.1920E-03,0.2129E-03,0.2361E-03,0.2619E-03,0.2904E-03,
     +0.3221E-03,0.3572E-03,0.3961E-03,0.4393E-03,0.4872E-03,0.5404E-03,
     +0.5993E-03,0.6646E-03,0.7371E-03,0.8174E-03,0.9066E-03,0.1005E-02,
     +0.1115E-02,0.1237E-02,0.1371E-02,0.1521E-02,0.1687E-02,0.1871E-02,
     +0.2075E-02,0.2301E-02,0.2552E-02,0.2830E-02,0.3139E-02,0.3481E-02,
     +0.3860E-02,0.4281E-02,0.4748E-02,0.5266E-02,0.5840E-02,0.6476E-02,
     +0.7182E-02,0.7966E-02,0.8834E-02,0.9797E-02,0.1087E-01,0.1205E-01,
     +0.1336E-01,0.1482E-01,0.1644E-01,0.1823E-01,0.2022E-01,0.2242E-01,
     +0.2487E-01,0.2758E-01,0.3058E-01,0.3392E-01,0.3762E-01,0.4172E-01,
     +0.4627E-01,0.5131E-01,0.5690E-01,0.6311E-01,0.6999E-01,0.7762E-01,
     +0.8608E-01,0.9547E-01,0.1059E+00,0.1174E+00,0.1302E+00,0.1444E+00,
     +0.1602E+00,0.1776E+00,0.1970E+00,0.2185E+00,0.2423E+00,0.2687E+00,
     +0.2980E+00,0.3305E+00,0.3666E+00,0.4065E+00,0.4508E+00,0.5000E+00,
     +0.5321E+00,0.5643E+00,0.5964E+00,0.6286E+00,0.6607E+00,0.6929E+00,
     +0.7250E+00,0.7571E+00,0.7893E+00,0.8214E+00,0.8536E+00,0.8857E+00,
     +0.9179E+00,0.9500E+00/
      DATA (XQDUM (I,1,1),I=1,104) /
     +0.1154E-01,0.1220E-01,0.1289E-01,0.1363E-01,0.1440E-01,0.1522E-01,
     +0.1609E-01,0.1701E-01,0.1798E-01,0.1901E-01,0.2009E-01,0.2123E-01,
     +0.2245E-01,0.2372E-01,0.2508E-01,0.2651E-01,0.2802E-01,0.2961E-01,
     +0.3130E-01,0.3308E-01,0.3497E-01,0.3696E-01,0.3906E-01,0.4129E-01,
     +0.4364E-01,0.4612E-01,0.4874E-01,0.5151E-01,0.5444E-01,0.5753E-01,
     +0.6080E-01,0.6425E-01,0.6790E-01,0.7175E-01,0.7581E-01,0.8010E-01,
     +0.8463E-01,0.8942E-01,0.9447E-01,0.9979E-01,0.1054E+00,0.1113E+00,
     +0.1176E+00,0.1242E+00,0.1311E+00,0.1384E+00,0.1462E+00,0.1543E+00,
     +0.1628E+00,0.1718E+00,0.1812E+00,0.1912E+00,0.2016E+00,0.2125E+00,
     +0.2239E+00,0.2359E+00,0.2484E+00,0.2615E+00,0.2751E+00,0.2893E+00,
     +0.3040E+00,0.3193E+00,0.3351E+00,0.3513E+00,0.3680E+00,0.3850E+00,
     +0.4023E+00,0.4198E+00,0.4374E+00,0.4548E+00,0.4720E+00,0.4887E+00,
     +0.5046E+00,0.5194E+00,0.5327E+00,0.5441E+00,0.5531E+00,0.5592E+00,
     +0.5618E+00,0.5603E+00,0.5539E+00,0.5422E+00,0.5244E+00,0.5003E+00,
     +0.4694E+00,0.4319E+00,0.3881E+00,0.3391E+00,0.2861E+00,0.2312E+00,
     +0.1983E+00,0.1680E+00,0.1404E+00,0.1157E+00,0.9372E-01,0.7443E-01,
     +0.5769E-01,0.4337E-01,0.3133E-01,0.2144E-01,0.1356E-01,0.7619E-02,
     +0.3495E-02,0.1056E-02/
      DATA (XQDUM (I,1,2),I=1,104) /
     +0.6588E-02,0.6963E-02,0.7360E-02,0.7780E-02,0.8224E-02,0.8693E-02,
     +0.9188E-02,0.9712E-02,0.1027E-01,0.1085E-01,0.1147E-01,0.1212E-01,
     +0.1281E-01,0.1354E-01,0.1432E-01,0.1513E-01,0.1599E-01,0.1690E-01,
     +0.1787E-01,0.1888E-01,0.1996E-01,0.2109E-01,0.2229E-01,0.2356E-01,
     +0.2490E-01,0.2632E-01,0.2781E-01,0.2939E-01,0.3106E-01,0.3282E-01,
     +0.3468E-01,0.3664E-01,0.3872E-01,0.4091E-01,0.4322E-01,0.4565E-01,
     +0.4823E-01,0.5094E-01,0.5380E-01,0.5682E-01,0.6000E-01,0.6335E-01,
     +0.6689E-01,0.7061E-01,0.7452E-01,0.7864E-01,0.8297E-01,0.8752E-01,
     +0.9230E-01,0.9731E-01,0.1026E+00,0.1081E+00,0.1138E+00,0.1199E+00,
     +0.1262E+00,0.1327E+00,0.1395E+00,0.1466E+00,0.1539E+00,0.1615E+00,
     +0.1693E+00,0.1773E+00,0.1855E+00,0.1938E+00,0.2022E+00,0.2107E+00,
     +0.2191E+00,0.2274E+00,0.2355E+00,0.2433E+00,0.2507E+00,0.2574E+00,
     +0.2633E+00,0.2682E+00,0.2719E+00,0.2742E+00,0.2747E+00,0.2732E+00,
     +0.2694E+00,0.2631E+00,0.2540E+00,0.2419E+00,0.2269E+00,0.2089E+00,
     +0.1882E+00,0.1651E+00,0.1404E+00,0.1149E+00,0.8971E-01,0.6601E-01,
     +0.5297E-01,0.4179E-01,0.3236E-01,0.2454E-01,0.1816E-01,0.1305E-01,
     +0.9059E-02,0.6015E-02,0.3770E-02,0.2185E-02,0.1134E-02,0.4971E-03,
     +0.1639E-03,0.3018E-04/
      DATA (XQDUM (I,1,3),I=1,104) /
     +0.7804E+01,0.7693E+01,0.7584E+01,0.7477E+01,0.7371E+01,0.7267E+01,
     +0.7165E+01,0.7065E+01,0.6966E+01,0.6869E+01,0.6774E+01,0.6680E+01,
     +0.6588E+01,0.6498E+01,0.6410E+01,0.6323E+01,0.6238E+01,0.6154E+01,
     +0.6073E+01,0.5993E+01,0.5914E+01,0.5838E+01,0.5763E+01,0.5690E+01,
     +0.5618E+01,0.5549E+01,0.5481E+01,0.5414E+01,0.5350E+01,0.5287E+01,
     +0.5225E+01,0.5166E+01,0.5108E+01,0.5052E+01,0.4997E+01,0.4944E+01,
     +0.4892E+01,0.4842E+01,0.4794E+01,0.4746E+01,0.4700E+01,0.4655E+01,
     +0.4612E+01,0.4568E+01,0.4526E+01,0.4484E+01,0.4443E+01,0.4401E+01,
     +0.4359E+01,0.4317E+01,0.4274E+01,0.4230E+01,0.4184E+01,0.4136E+01,
     +0.4085E+01,0.4032E+01,0.3975E+01,0.3914E+01,0.3849E+01,0.3778E+01,
     +0.3702E+01,0.3620E+01,0.3530E+01,0.3434E+01,0.3331E+01,0.3219E+01,
     +0.3099E+01,0.2971E+01,0.2834E+01,0.2689E+01,0.2537E+01,0.2377E+01,
     +0.2211E+01,0.2040E+01,0.1864E+01,0.1686E+01,0.1507E+01,0.1330E+01,
     +0.1156E+01,0.9884E+00,0.8287E+00,0.6796E+00,0.5433E+00,0.4215E+00,
     +0.3157E+00,0.2267E+00,0.1548E+00,0.9926E-01,0.5884E-01,0.3151E-01,
     +0.2032E-01,0.1274E-01,0.7732E-02,0.4513E-02,0.2516E-02,0.1326E-02,
     +0.6529E-03,0.2949E-03,0.1192E-03,0.4151E-04,0.1172E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,4),I=1,104) /
     +0.6997E+00,0.6997E+00,0.6994E+00,0.6995E+00,0.6994E+00,0.6992E+00,
     +0.6991E+00,0.6990E+00,0.6989E+00,0.6988E+00,0.6987E+00,0.6986E+00,
     +0.6984E+00,0.6982E+00,0.6980E+00,0.6979E+00,0.6976E+00,0.6974E+00,
     +0.6971E+00,0.6968E+00,0.6965E+00,0.6961E+00,0.6957E+00,0.6952E+00,
     +0.6947E+00,0.6941E+00,0.6935E+00,0.6928E+00,0.6920E+00,0.6912E+00,
     +0.6902E+00,0.6891E+00,0.6880E+00,0.6866E+00,0.6852E+00,0.6836E+00,
     +0.6819E+00,0.6799E+00,0.6778E+00,0.6754E+00,0.6727E+00,0.6698E+00,
     +0.6666E+00,0.6631E+00,0.6592E+00,0.6549E+00,0.6502E+00,0.6450E+00,
     +0.6393E+00,0.6331E+00,0.6262E+00,0.6187E+00,0.6105E+00,0.6015E+00,
     +0.5917E+00,0.5811E+00,0.5695E+00,0.5570E+00,0.5435E+00,0.5290E+00,
     +0.5134E+00,0.4966E+00,0.4788E+00,0.4599E+00,0.4400E+00,0.4190E+00,
     +0.3971E+00,0.3744E+00,0.3510E+00,0.3271E+00,0.3028E+00,0.2785E+00,
     +0.2543E+00,0.2305E+00,0.2073E+00,0.1850E+00,0.1638E+00,0.1438E+00,
     +0.1252E+00,0.1079E+00,0.9189E-01,0.7717E-01,0.6363E-01,0.5119E-01,
     +0.3985E-01,0.2967E-01,0.2082E-01,0.1351E-01,0.7893E-02,0.4007E-02,
     +0.2439E-02,0.1414E-02,0.7767E-03,0.4008E-03,0.1924E-03,0.8481E-04,
     +0.3373E-04,0.1183E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,5),I=1,104) /
     +0.2915E+00,0.2915E+00,0.2914E+00,0.2914E+00,0.2914E+00,0.2913E+00,
     +0.2913E+00,0.2913E+00,0.2912E+00,0.2911E+00,0.2911E+00,0.2911E+00,
     +0.2910E+00,0.2909E+00,0.2908E+00,0.2908E+00,0.2907E+00,0.2906E+00,
     +0.2905E+00,0.2903E+00,0.2902E+00,0.2900E+00,0.2899E+00,0.2897E+00,
     +0.2894E+00,0.2892E+00,0.2889E+00,0.2887E+00,0.2883E+00,0.2880E+00,
     +0.2876E+00,0.2871E+00,0.2866E+00,0.2861E+00,0.2855E+00,0.2848E+00,
     +0.2841E+00,0.2833E+00,0.2824E+00,0.2814E+00,0.2803E+00,0.2791E+00,
     +0.2778E+00,0.2763E+00,0.2747E+00,0.2729E+00,0.2709E+00,0.2688E+00,
     +0.2664E+00,0.2638E+00,0.2609E+00,0.2578E+00,0.2544E+00,0.2506E+00,
     +0.2466E+00,0.2421E+00,0.2373E+00,0.2321E+00,0.2265E+00,0.2204E+00,
     +0.2139E+00,0.2069E+00,0.1995E+00,0.1916E+00,0.1833E+00,0.1746E+00,
     +0.1655E+00,0.1560E+00,0.1462E+00,0.1363E+00,0.1262E+00,0.1160E+00,
     +0.1060E+00,0.9604E-01,0.8639E-01,0.7710E-01,0.6826E-01,0.5993E-01,
     +0.5215E-01,0.4494E-01,0.3829E-01,0.3216E-01,0.2651E-01,0.2133E-01,
     +0.1660E-01,0.1236E-01,0.8676E-02,0.5628E-02,0.3289E-02,0.1670E-02,
     +0.1016E-02,0.5892E-03,0.3236E-03,0.1670E-03,0.8017E-04,0.3534E-04,
     +0.1405E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,6),I=1,104) /
     +0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,
     +0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1164E+00,
     +0.1164E+00,0.1164E+00,0.1164E+00,0.1163E+00,0.1163E+00,0.1162E+00,
     +0.1162E+00,0.1161E+00,0.1161E+00,0.1160E+00,0.1159E+00,0.1159E+00,
     +0.1158E+00,0.1157E+00,0.1156E+00,0.1155E+00,0.1153E+00,0.1152E+00,
     +0.1150E+00,0.1149E+00,0.1147E+00,0.1144E+00,0.1142E+00,0.1139E+00,
     +0.1136E+00,0.1133E+00,0.1130E+00,0.1126E+00,0.1121E+00,0.1116E+00,
     +0.1111E+00,0.1105E+00,0.1099E+00,0.1092E+00,0.1084E+00,0.1075E+00,
     +0.1066E+00,0.1055E+00,0.1044E+00,0.1031E+00,0.1017E+00,0.1002E+00,
     +0.9862E-01,0.9685E-01,0.9492E-01,0.9284E-01,0.9059E-01,0.8816E-01,
     +0.8556E-01,0.8277E-01,0.7980E-01,0.7665E-01,0.7333E-01,0.6983E-01,
     +0.6618E-01,0.6240E-01,0.5850E-01,0.5451E-01,0.5047E-01,0.4642E-01,
     +0.4238E-01,0.3842E-01,0.3456E-01,0.3084E-01,0.2730E-01,0.2397E-01,
     +0.2086E-01,0.1798E-01,0.1531E-01,0.1286E-01,0.1061E-01,0.8532E-02,
     +0.6641E-02,0.4945E-02,0.3470E-02,0.2251E-02,0.1315E-02,0.6679E-03,
     +0.4064E-03,0.2357E-03,0.1295E-03,0.6680E-04,0.3207E-04,0.1413E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,7),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,8),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,1),I=1,104) /
     +0.1248E-01,0.1319E-01,0.1394E-01,0.1473E-01,0.1557E-01,0.1645E-01,
     +0.1739E-01,0.1838E-01,0.1942E-01,0.2052E-01,0.2169E-01,0.2292E-01,
     +0.2422E-01,0.2559E-01,0.2704E-01,0.2857E-01,0.3019E-01,0.3190E-01,
     +0.3371E-01,0.3562E-01,0.3764E-01,0.3977E-01,0.4202E-01,0.4439E-01,
     +0.4690E-01,0.4955E-01,0.5235E-01,0.5530E-01,0.5842E-01,0.6171E-01,
     +0.6518E-01,0.6885E-01,0.7271E-01,0.7680E-01,0.8110E-01,0.8564E-01,
     +0.9043E-01,0.9548E-01,0.1008E+00,0.1064E+00,0.1123E+00,0.1186E+00,
     +0.1251E+00,0.1320E+00,0.1393E+00,0.1469E+00,0.1550E+00,0.1634E+00,
     +0.1723E+00,0.1816E+00,0.1914E+00,0.2016E+00,0.2123E+00,0.2235E+00,
     +0.2352E+00,0.2474E+00,0.2602E+00,0.2734E+00,0.2872E+00,0.3014E+00,
     +0.3162E+00,0.3314E+00,0.3470E+00,0.3630E+00,0.3793E+00,0.3958E+00,
     +0.4125E+00,0.4292E+00,0.4457E+00,0.4620E+00,0.4777E+00,0.4927E+00,
     +0.5067E+00,0.5193E+00,0.5302E+00,0.5388E+00,0.5449E+00,0.5477E+00,
     +0.5469E+00,0.5418E+00,0.5319E+00,0.5166E+00,0.4955E+00,0.4685E+00,
     +0.4353E+00,0.3962E+00,0.3520E+00,0.3035E+00,0.2525E+00,0.2008E+00,
     +0.1703E+00,0.1427E+00,0.1179E+00,0.9590E-01,0.7664E-01,0.5997E-01,
     +0.4572E-01,0.3373E-01,0.2384E-01,0.1589E-01,0.9743E-02,0.5258E-02,
     +0.2284E-02,0.6339E-03/
      DATA (XQDUM (I,2,2),I=1,104) /
     +0.7122E-02,0.7527E-02,0.7955E-02,0.8406E-02,0.8884E-02,0.9388E-02,
     +0.9921E-02,0.1048E-01,0.1108E-01,0.1171E-01,0.1237E-01,0.1307E-01,
     +0.1381E-01,0.1460E-01,0.1542E-01,0.1630E-01,0.1722E-01,0.1820E-01,
     +0.1923E-01,0.2031E-01,0.2146E-01,0.2267E-01,0.2395E-01,0.2531E-01,
     +0.2673E-01,0.2824E-01,0.2983E-01,0.3151E-01,0.3328E-01,0.3515E-01,
     +0.3712E-01,0.3920E-01,0.4140E-01,0.4371E-01,0.4615E-01,0.4872E-01,
     +0.5143E-01,0.5429E-01,0.5730E-01,0.6047E-01,0.6380E-01,0.6731E-01,
     +0.7100E-01,0.7488E-01,0.7895E-01,0.8323E-01,0.8772E-01,0.9243E-01,
     +0.9736E-01,0.1025E+00,0.1079E+00,0.1136E+00,0.1194E+00,0.1256E+00,
     +0.1320E+00,0.1386E+00,0.1454E+00,0.1525E+00,0.1598E+00,0.1673E+00,
     +0.1750E+00,0.1829E+00,0.1908E+00,0.1989E+00,0.2069E+00,0.2150E+00,
     +0.2229E+00,0.2306E+00,0.2380E+00,0.2449E+00,0.2513E+00,0.2569E+00,
     +0.2616E+00,0.2653E+00,0.2675E+00,0.2682E+00,0.2671E+00,0.2640E+00,
     +0.2586E+00,0.2506E+00,0.2400E+00,0.2267E+00,0.2107E+00,0.1920E+00,
     +0.1711E+00,0.1484E+00,0.1246E+00,0.1005E+00,0.7723E-01,0.5583E-01,
     +0.4426E-01,0.3449E-01,0.2636E-01,0.1971E-01,0.1437E-01,0.1017E-01,
     +0.6930E-02,0.4509E-02,0.2761E-02,0.1558E-02,0.7821E-03,0.3288E-03,
     +0.1025E-03,0.1729E-04/
      DATA (XQDUM (I,2,3),I=1,104) /
     +0.1539E+02,0.1510E+02,0.1482E+02,0.1454E+02,0.1426E+02,0.1399E+02,
     +0.1372E+02,0.1346E+02,0.1320E+02,0.1295E+02,0.1270E+02,0.1245E+02,
     +0.1221E+02,0.1197E+02,0.1174E+02,0.1151E+02,0.1128E+02,0.1106E+02,
     +0.1084E+02,0.1063E+02,0.1042E+02,0.1021E+02,0.1001E+02,0.9810E+01,
     +0.9613E+01,0.9421E+01,0.9231E+01,0.9046E+01,0.8863E+01,0.8684E+01,
     +0.8508E+01,0.8335E+01,0.8165E+01,0.7999E+01,0.7835E+01,0.7675E+01,
     +0.7517E+01,0.7362E+01,0.7209E+01,0.7059E+01,0.6912E+01,0.6767E+01,
     +0.6624E+01,0.6482E+01,0.6343E+01,0.6205E+01,0.6069E+01,0.5934E+01,
     +0.5799E+01,0.5665E+01,0.5532E+01,0.5399E+01,0.5265E+01,0.5131E+01,
     +0.4995E+01,0.4859E+01,0.4720E+01,0.4580E+01,0.4437E+01,0.4291E+01,
     +0.4142E+01,0.3990E+01,0.3834E+01,0.3674E+01,0.3510E+01,0.3342E+01,
     +0.3170E+01,0.2994E+01,0.2814E+01,0.2631E+01,0.2446E+01,0.2258E+01,
     +0.2070E+01,0.1882E+01,0.1695E+01,0.1511E+01,0.1332E+01,0.1158E+01,
     +0.9928E+00,0.8369E+00,0.6922E+00,0.5601E+00,0.4420E+00,0.3387E+00,
     +0.2507E+00,0.1781E+00,0.1205E+00,0.7664E-01,0.4513E-01,0.2399E-01,
     +0.1534E-01,0.9431E-02,0.5475E-02,0.2880E-02,0.1220E-02,0.1955E-03,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,4),I=1,104) /
     +0.1709E+01,0.1685E+01,0.1661E+01,0.1638E+01,0.1615E+01,0.1592E+01,
     +0.1570E+01,0.1548E+01,0.1526E+01,0.1505E+01,0.1484E+01,0.1463E+01,
     +0.1443E+01,0.1423E+01,0.1404E+01,0.1385E+01,0.1366E+01,0.1347E+01,
     +0.1329E+01,0.1311E+01,0.1293E+01,0.1275E+01,0.1258E+01,0.1241E+01,
     +0.1224E+01,0.1208E+01,0.1192E+01,0.1175E+01,0.1160E+01,0.1144E+01,
     +0.1128E+01,0.1113E+01,0.1098E+01,0.1083E+01,0.1068E+01,0.1053E+01,
     +0.1038E+01,0.1024E+01,0.1009E+01,0.9943E+00,0.9796E+00,0.9649E+00,
     +0.9501E+00,0.9352E+00,0.9201E+00,0.9049E+00,0.8894E+00,0.8737E+00,
     +0.8576E+00,0.8412E+00,0.8243E+00,0.8070E+00,0.7892E+00,0.7708E+00,
     +0.7518E+00,0.7320E+00,0.7116E+00,0.6904E+00,0.6683E+00,0.6455E+00,
     +0.6217E+00,0.5971E+00,0.5715E+00,0.5452E+00,0.5180E+00,0.4900E+00,
     +0.4614E+00,0.4323E+00,0.4028E+00,0.3731E+00,0.3434E+00,0.3140E+00,
     +0.2850E+00,0.2568E+00,0.2295E+00,0.2035E+00,0.1788E+00,0.1557E+00,
     +0.1343E+00,0.1145E+00,0.9637E-01,0.7984E-01,0.6484E-01,0.5132E-01,
     +0.3926E-01,0.2874E-01,0.1986E-01,0.1274E-01,0.7424E-02,0.3836E-02,
     +0.2408E-02,0.1477E-02,0.8907E-03,0.5340E-03,0.3229E-03,0.1994E-03,
     +0.1265E-03,0.8155E-04,0.5219E-04,0.3199E-04,0.1796E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,5),I=1,104) /
     +0.5217E+00,0.5162E+00,0.5107E+00,0.5054E+00,0.5002E+00,0.4950E+00,
     +0.4899E+00,0.4849E+00,0.4799E+00,0.4751E+00,0.4703E+00,0.4657E+00,
     +0.4610E+00,0.4564E+00,0.4519E+00,0.4475E+00,0.4432E+00,0.4389E+00,
     +0.4346E+00,0.4305E+00,0.4263E+00,0.4223E+00,0.4182E+00,0.4142E+00,
     +0.4103E+00,0.4064E+00,0.4026E+00,0.3988E+00,0.3950E+00,0.3912E+00,
     +0.3874E+00,0.3837E+00,0.3800E+00,0.3763E+00,0.3725E+00,0.3688E+00,
     +0.3650E+00,0.3613E+00,0.3575E+00,0.3536E+00,0.3497E+00,0.3457E+00,
     +0.3416E+00,0.3375E+00,0.3332E+00,0.3288E+00,0.3243E+00,0.3196E+00,
     +0.3148E+00,0.3097E+00,0.3045E+00,0.2990E+00,0.2932E+00,0.2872E+00,
     +0.2809E+00,0.2742E+00,0.2672E+00,0.2599E+00,0.2522E+00,0.2441E+00,
     +0.2356E+00,0.2267E+00,0.2174E+00,0.2077E+00,0.1977E+00,0.1873E+00,
     +0.1766E+00,0.1657E+00,0.1545E+00,0.1433E+00,0.1320E+00,0.1208E+00,
     +0.1098E+00,0.9902E-01,0.8860E-01,0.7864E-01,0.6921E-01,0.6037E-01,
     +0.5216E-01,0.4457E-01,0.3761E-01,0.3124E-01,0.2544E-01,0.2018E-01,
     +0.1547E-01,0.1134E-01,0.7829E-02,0.5005E-02,0.2894E-02,0.1470E-02,
     +0.9056E-03,0.5403E-03,0.3132E-03,0.1779E-03,0.1003E-03,0.5723E-04,
     +0.3362E-04,0.2039E-04,0.1255E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,6),I=1,104) /
     +0.3469E+00,0.3414E+00,0.3360E+00,0.3307E+00,0.3255E+00,0.3203E+00,
     +0.3152E+00,0.3103E+00,0.3054E+00,0.3006E+00,0.2958E+00,0.2912E+00,
     +0.2866E+00,0.2821E+00,0.2777E+00,0.2733E+00,0.2690E+00,0.2648E+00,
     +0.2606E+00,0.2565E+00,0.2525E+00,0.2486E+00,0.2447E+00,0.2408E+00,
     +0.2370E+00,0.2333E+00,0.2297E+00,0.2260E+00,0.2225E+00,0.2190E+00,
     +0.2155E+00,0.2121E+00,0.2087E+00,0.2054E+00,0.2021E+00,0.1988E+00,
     +0.1955E+00,0.1923E+00,0.1891E+00,0.1860E+00,0.1828E+00,0.1796E+00,
     +0.1765E+00,0.1733E+00,0.1701E+00,0.1670E+00,0.1637E+00,0.1605E+00,
     +0.1572E+00,0.1539E+00,0.1505E+00,0.1470E+00,0.1435E+00,0.1399E+00,
     +0.1362E+00,0.1324E+00,0.1285E+00,0.1245E+00,0.1203E+00,0.1160E+00,
     +0.1116E+00,0.1070E+00,0.1023E+00,0.9747E-01,0.9251E-01,0.8743E-01,
     +0.8225E-01,0.7700E-01,0.7169E-01,0.6635E-01,0.6103E-01,0.5576E-01,
     +0.5058E-01,0.4554E-01,0.4068E-01,0.3603E-01,0.3164E-01,0.2752E-01,
     +0.2369E-01,0.2017E-01,0.1695E-01,0.1401E-01,0.1136E-01,0.8972E-02,
     +0.6855E-02,0.5014E-02,0.3466E-02,0.2229E-02,0.1307E-02,0.6845E-03,
     +0.4357E-03,0.2725E-03,0.1688E-03,0.1047E-03,0.6588E-04,0.4238E-04,
     +0.2784E-04,0.1842E-04,0.1197E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,7),I=1,104) /
     +0.2304E+00,0.2249E+00,0.2195E+00,0.2142E+00,0.2090E+00,0.2038E+00,
     +0.1988E+00,0.1938E+00,0.1890E+00,0.1842E+00,0.1795E+00,0.1748E+00,
     +0.1703E+00,0.1658E+00,0.1614E+00,0.1571E+00,0.1529E+00,0.1487E+00,
     +0.1446E+00,0.1406E+00,0.1366E+00,0.1327E+00,0.1289E+00,0.1252E+00,
     +0.1215E+00,0.1179E+00,0.1144E+00,0.1109E+00,0.1075E+00,0.1041E+00,
     +0.1009E+00,0.9765E-01,0.9450E-01,0.9141E-01,0.8839E-01,0.8543E-01,
     +0.8252E-01,0.7968E-01,0.7690E-01,0.7417E-01,0.7150E-01,0.6889E-01,
     +0.6634E-01,0.6384E-01,0.6140E-01,0.5901E-01,0.5668E-01,0.5439E-01,
     +0.5216E-01,0.4998E-01,0.4784E-01,0.4576E-01,0.4372E-01,0.4172E-01,
     +0.3977E-01,0.3786E-01,0.3599E-01,0.3417E-01,0.3238E-01,0.3063E-01,
     +0.2891E-01,0.2724E-01,0.2559E-01,0.2398E-01,0.2241E-01,0.2087E-01,
     +0.1936E-01,0.1789E-01,0.1645E-01,0.1505E-01,0.1370E-01,0.1238E-01,
     +0.1111E-01,0.9893E-02,0.8729E-02,0.7625E-02,0.6586E-02,0.5617E-02,
     +0.4723E-02,0.3909E-02,0.3178E-02,0.2533E-02,0.1974E-02,0.1502E-02,
     +0.1112E-02,0.7997E-03,0.5581E-03,0.3781E-03,0.2493E-03,0.1608E-03,
     +0.1224E-03,0.9392E-04,0.7249E-04,0.5597E-04,0.4294E-04,0.3248E-04,
     +0.2399E-04,0.1710E-04,0.1159E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,8),I=1,104) /
     +0.8849E-01,0.8626E-01,0.8408E-01,0.8193E-01,0.7983E-01,0.7775E-01,
     +0.7571E-01,0.7373E-01,0.7177E-01,0.6985E-01,0.6797E-01,0.6613E-01,
     +0.6432E-01,0.6255E-01,0.6081E-01,0.5910E-01,0.5742E-01,0.5578E-01,
     +0.5416E-01,0.5258E-01,0.5103E-01,0.4952E-01,0.4803E-01,0.4657E-01,
     +0.4514E-01,0.4374E-01,0.4237E-01,0.4102E-01,0.3970E-01,0.3842E-01,
     +0.3715E-01,0.3592E-01,0.3471E-01,0.3353E-01,0.3237E-01,0.3124E-01,
     +0.3013E-01,0.2905E-01,0.2799E-01,0.2696E-01,0.2595E-01,0.2496E-01,
     +0.2400E-01,0.2305E-01,0.2213E-01,0.2123E-01,0.2036E-01,0.1950E-01,
     +0.1866E-01,0.1784E-01,0.1705E-01,0.1627E-01,0.1551E-01,0.1477E-01,
     +0.1404E-01,0.1334E-01,0.1265E-01,0.1197E-01,0.1132E-01,0.1068E-01,
     +0.1005E-01,0.9439E-02,0.8843E-02,0.8262E-02,0.7695E-02,0.7143E-02,
     +0.6605E-02,0.6082E-02,0.5575E-02,0.5084E-02,0.4609E-02,0.4152E-02,
     +0.3713E-02,0.3294E-02,0.2896E-02,0.2521E-02,0.2170E-02,0.1844E-02,
     +0.1545E-02,0.1275E-02,0.1033E-02,0.8207E-03,0.6379E-03,0.4839E-03,
     +0.3574E-03,0.2566E-03,0.1788E-03,0.1210E-03,0.7968E-04,0.5130E-04,
     +0.3897E-04,0.2983E-04,0.2295E-04,0.1764E-04,0.1346E-04,0.1012E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,1),I=1,104) /
     +0.1345E-01,0.1421E-01,0.1501E-01,0.1586E-01,0.1676E-01,0.1771E-01,
     +0.1871E-01,0.1977E-01,0.2089E-01,0.2207E-01,0.2331E-01,0.2463E-01,
     +0.2602E-01,0.2749E-01,0.2904E-01,0.3067E-01,0.3240E-01,0.3423E-01,
     +0.3615E-01,0.3819E-01,0.4034E-01,0.4260E-01,0.4499E-01,0.4752E-01,
     +0.5018E-01,0.5300E-01,0.5596E-01,0.5909E-01,0.6240E-01,0.6588E-01,
     +0.6955E-01,0.7342E-01,0.7751E-01,0.8181E-01,0.8635E-01,0.9113E-01,
     +0.9616E-01,0.1015E+00,0.1071E+00,0.1129E+00,0.1191E+00,0.1256E+00,
     +0.1325E+00,0.1397E+00,0.1472E+00,0.1551E+00,0.1635E+00,0.1722E+00,
     +0.1814E+00,0.1909E+00,0.2010E+00,0.2115E+00,0.2224E+00,0.2338E+00,
     +0.2457E+00,0.2581E+00,0.2710E+00,0.2843E+00,0.2981E+00,0.3123E+00,
     +0.3269E+00,0.3420E+00,0.3573E+00,0.3729E+00,0.3887E+00,0.4047E+00,
     +0.4206E+00,0.4364E+00,0.4518E+00,0.4668E+00,0.4811E+00,0.4944E+00,
     +0.5065E+00,0.5170E+00,0.5255E+00,0.5316E+00,0.5348E+00,0.5348E+00,
     +0.5309E+00,0.5228E+00,0.5098E+00,0.4917E+00,0.4680E+00,0.4388E+00,
     +0.4041E+00,0.3643E+00,0.3202E+00,0.2729E+00,0.2241E+00,0.1756E+00,
     +0.1475E+00,0.1223E+00,0.9996E-01,0.8039E-01,0.6345E-01,0.4897E-01,
     +0.3677E-01,0.2666E-01,0.1847E-01,0.1202E-01,0.7159E-02,0.3722E-02,
     +0.1536E-02,0.3929E-03/
      DATA (XQDUM (I,3,2),I=1,104) /
     +0.7669E-02,0.8103E-02,0.8562E-02,0.9046E-02,0.9558E-02,0.1010E-01,
     +0.1067E-01,0.1127E-01,0.1191E-01,0.1258E-01,0.1329E-01,0.1404E-01,
     +0.1483E-01,0.1567E-01,0.1655E-01,0.1748E-01,0.1846E-01,0.1950E-01,
     +0.2060E-01,0.2175E-01,0.2297E-01,0.2426E-01,0.2562E-01,0.2706E-01,
     +0.2857E-01,0.3017E-01,0.3185E-01,0.3362E-01,0.3550E-01,0.3747E-01,
     +0.3955E-01,0.4174E-01,0.4405E-01,0.4649E-01,0.4905E-01,0.5175E-01,
     +0.5459E-01,0.5757E-01,0.6072E-01,0.6402E-01,0.6749E-01,0.7114E-01,
     +0.7497E-01,0.7899E-01,0.8321E-01,0.8762E-01,0.9225E-01,0.9709E-01,
     +0.1021E+00,0.1074E+00,0.1129E+00,0.1187E+00,0.1246E+00,0.1308E+00,
     +0.1373E+00,0.1439E+00,0.1508E+00,0.1578E+00,0.1650E+00,0.1724E+00,
     +0.1800E+00,0.1876E+00,0.1953E+00,0.2030E+00,0.2107E+00,0.2182E+00,
     +0.2256E+00,0.2326E+00,0.2393E+00,0.2454E+00,0.2508E+00,0.2554E+00,
     +0.2590E+00,0.2614E+00,0.2623E+00,0.2617E+00,0.2591E+00,0.2546E+00,
     +0.2478E+00,0.2385E+00,0.2268E+00,0.2126E+00,0.1959E+00,0.1769E+00,
     +0.1561E+00,0.1339E+00,0.1111E+00,0.8851E-01,0.6705E-01,0.4769E-01,
     +0.3740E-01,0.2881E-01,0.2176E-01,0.1607E-01,0.1156E-01,0.8055E-02,
     +0.5402E-02,0.3450E-02,0.2068E-02,0.1138E-02,0.5540E-03,0.2240E-03,
     +0.6613E-04,0.1026E-04/
      DATA (XQDUM (I,3,3),I=1,104) /
     +0.2517E+02,0.2459E+02,0.2402E+02,0.2347E+02,0.2292E+02,0.2239E+02,
     +0.2186E+02,0.2135E+02,0.2084E+02,0.2034E+02,0.1986E+02,0.1938E+02,
     +0.1891E+02,0.1845E+02,0.1800E+02,0.1756E+02,0.1713E+02,0.1670E+02,
     +0.1629E+02,0.1588E+02,0.1548E+02,0.1509E+02,0.1470E+02,0.1433E+02,
     +0.1396E+02,0.1360E+02,0.1324E+02,0.1289E+02,0.1255E+02,0.1222E+02,
     +0.1189E+02,0.1157E+02,0.1126E+02,0.1095E+02,0.1065E+02,0.1036E+02,
     +0.1007E+02,0.9789E+01,0.9512E+01,0.9240E+01,0.8974E+01,0.8712E+01,
     +0.8456E+01,0.8204E+01,0.7957E+01,0.7714E+01,0.7475E+01,0.7240E+01,
     +0.7009E+01,0.6781E+01,0.6555E+01,0.6333E+01,0.6113E+01,0.5895E+01,
     +0.5679E+01,0.5464E+01,0.5251E+01,0.5039E+01,0.4828E+01,0.4617E+01,
     +0.4406E+01,0.4195E+01,0.3985E+01,0.3774E+01,0.3563E+01,0.3353E+01,
     +0.3142E+01,0.2932E+01,0.2723E+01,0.2516E+01,0.2310E+01,0.2107E+01,
     +0.1908E+01,0.1714E+01,0.1525E+01,0.1343E+01,0.1169E+01,0.1005E+01,
     +0.8512E+00,0.7092E+00,0.5798E+00,0.4639E+00,0.3620E+00,0.2745E+00,
     +0.2011E+00,0.1415E+00,0.9481E-01,0.5975E-01,0.3479E-01,0.1813E-01,
     +0.1131E-01,0.6647E-02,0.3510E-02,0.1444E-02,0.1232E-03,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,4),I=1,104) /
     +0.3202E+01,0.3136E+01,0.3071E+01,0.3008E+01,0.2946E+01,0.2884E+01,
     +0.2824E+01,0.2766E+01,0.2708E+01,0.2652E+01,0.2597E+01,0.2542E+01,
     +0.2489E+01,0.2437E+01,0.2386E+01,0.2336E+01,0.2287E+01,0.2239E+01,
     +0.2192E+01,0.2146E+01,0.2101E+01,0.2057E+01,0.2014E+01,0.1971E+01,
     +0.1929E+01,0.1889E+01,0.1849E+01,0.1809E+01,0.1771E+01,0.1733E+01,
     +0.1696E+01,0.1660E+01,0.1624E+01,0.1589E+01,0.1554E+01,0.1520E+01,
     +0.1487E+01,0.1454E+01,0.1422E+01,0.1390E+01,0.1358E+01,0.1327E+01,
     +0.1296E+01,0.1265E+01,0.1235E+01,0.1205E+01,0.1175E+01,0.1145E+01,
     +0.1115E+01,0.1085E+01,0.1055E+01,0.1025E+01,0.9946E+00,0.9640E+00,
     +0.9331E+00,0.9018E+00,0.8701E+00,0.8380E+00,0.8054E+00,0.7722E+00,
     +0.7385E+00,0.7043E+00,0.6695E+00,0.6343E+00,0.5986E+00,0.5626E+00,
     +0.5263E+00,0.4899E+00,0.4535E+00,0.4174E+00,0.3818E+00,0.3468E+00,
     +0.3128E+00,0.2800E+00,0.2486E+00,0.2188E+00,0.1909E+00,0.1649E+00,
     +0.1409E+00,0.1189E+00,0.9901E-01,0.8104E-01,0.6495E-01,0.5069E-01,
     +0.3823E-01,0.2760E-01,0.1884E-01,0.1197E-01,0.6970E-02,0.3655E-02,
     +0.2346E-02,0.1491E-02,0.9458E-03,0.6049E-03,0.3931E-03,0.2598E-03,
     +0.1735E-03,0.1150E-03,0.7391E-04,0.4469E-04,0.2443E-04,0.1134E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,5),I=1,104) /
     +0.8198E+00,0.8059E+00,0.7922E+00,0.7789E+00,0.7658E+00,0.7529E+00,
     +0.7403E+00,0.7279E+00,0.7158E+00,0.7039E+00,0.6923E+00,0.6809E+00,
     +0.6696E+00,0.6586E+00,0.6479E+00,0.6373E+00,0.6269E+00,0.6168E+00,
     +0.6068E+00,0.5970E+00,0.5874E+00,0.5779E+00,0.5687E+00,0.5596E+00,
     +0.5506E+00,0.5419E+00,0.5332E+00,0.5247E+00,0.5164E+00,0.5082E+00,
     +0.5001E+00,0.4921E+00,0.4842E+00,0.4764E+00,0.4688E+00,0.4612E+00,
     +0.4536E+00,0.4461E+00,0.4387E+00,0.4313E+00,0.4240E+00,0.4166E+00,
     +0.4093E+00,0.4019E+00,0.3945E+00,0.3870E+00,0.3795E+00,0.3718E+00,
     +0.3641E+00,0.3562E+00,0.3482E+00,0.3400E+00,0.3316E+00,0.3230E+00,
     +0.3142E+00,0.3051E+00,0.2957E+00,0.2860E+00,0.2761E+00,0.2658E+00,
     +0.2552E+00,0.2443E+00,0.2331E+00,0.2215E+00,0.2098E+00,0.1977E+00,
     +0.1855E+00,0.1731E+00,0.1607E+00,0.1483E+00,0.1359E+00,0.1238E+00,
     +0.1119E+00,0.1004E+00,0.8935E-01,0.7886E-01,0.6900E-01,0.5980E-01,
     +0.5130E-01,0.4349E-01,0.3638E-01,0.2992E-01,0.2409E-01,0.1889E-01,
     +0.1429E-01,0.1033E-01,0.7037E-02,0.4443E-02,0.2546E-02,0.1293E-02,
     +0.8037E-03,0.4887E-03,0.2929E-03,0.1749E-03,0.1055E-03,0.6497E-04,
     +0.4096E-04,0.2611E-04,0.1641E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,6),I=1,104) /
     +0.6451E+00,0.6312E+00,0.6176E+00,0.6042E+00,0.5912E+00,0.5783E+00,
     +0.5658E+00,0.5535E+00,0.5414E+00,0.5295E+00,0.5179E+00,0.5066E+00,
     +0.4954E+00,0.4845E+00,0.4738E+00,0.4633E+00,0.4530E+00,0.4429E+00,
     +0.4330E+00,0.4234E+00,0.4139E+00,0.4046E+00,0.3955E+00,0.3865E+00,
     +0.3778E+00,0.3692E+00,0.3608E+00,0.3526E+00,0.3445E+00,0.3366E+00,
     +0.3288E+00,0.3212E+00,0.3137E+00,0.3064E+00,0.2991E+00,0.2921E+00,
     +0.2851E+00,0.2783E+00,0.2716E+00,0.2649E+00,0.2584E+00,0.2520E+00,
     +0.2456E+00,0.2393E+00,0.2331E+00,0.2270E+00,0.2209E+00,0.2148E+00,
     +0.2088E+00,0.2028E+00,0.1968E+00,0.1908E+00,0.1848E+00,0.1788E+00,
     +0.1727E+00,0.1666E+00,0.1605E+00,0.1543E+00,0.1480E+00,0.1417E+00,
     +0.1353E+00,0.1289E+00,0.1223E+00,0.1157E+00,0.1091E+00,0.1024E+00,
     +0.9569E-01,0.8898E-01,0.8229E-01,0.7567E-01,0.6915E-01,0.6276E-01,
     +0.5656E-01,0.5058E-01,0.4486E-01,0.3944E-01,0.3436E-01,0.2964E-01,
     +0.2528E-01,0.2130E-01,0.1769E-01,0.1445E-01,0.1155E-01,0.8999E-02,
     +0.6777E-02,0.4889E-02,0.3340E-02,0.2131E-02,0.1251E-02,0.6661E-03,
     +0.4342E-03,0.2815E-03,0.1829E-03,0.1202E-03,0.8020E-04,0.5428E-04,
     +0.3688E-04,0.2475E-04,0.1602E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,7),I=1,104) /
     +0.5286E+00,0.5147E+00,0.5011E+00,0.4878E+00,0.4747E+00,0.4619E+00,
     +0.4494E+00,0.4371E+00,0.4250E+00,0.4132E+00,0.4017E+00,0.3903E+00,
     +0.3792E+00,0.3683E+00,0.3577E+00,0.3472E+00,0.3370E+00,0.3270E+00,
     +0.3172E+00,0.3076E+00,0.2982E+00,0.2890E+00,0.2800E+00,0.2711E+00,
     +0.2625E+00,0.2541E+00,0.2458E+00,0.2377E+00,0.2298E+00,0.2221E+00,
     +0.2146E+00,0.2072E+00,0.2000E+00,0.1929E+00,0.1860E+00,0.1793E+00,
     +0.1727E+00,0.1663E+00,0.1601E+00,0.1540E+00,0.1480E+00,0.1422E+00,
     +0.1365E+00,0.1310E+00,0.1256E+00,0.1203E+00,0.1151E+00,0.1101E+00,
     +0.1053E+00,0.1005E+00,0.9585E-01,0.9132E-01,0.8691E-01,0.8261E-01,
     +0.7842E-01,0.7434E-01,0.7036E-01,0.6648E-01,0.6270E-01,0.5901E-01,
     +0.5542E-01,0.5193E-01,0.4852E-01,0.4521E-01,0.4199E-01,0.3886E-01,
     +0.3582E-01,0.3288E-01,0.3003E-01,0.2728E-01,0.2464E-01,0.2210E-01,
     +0.1968E-01,0.1738E-01,0.1521E-01,0.1317E-01,0.1128E-01,0.9530E-02,
     +0.7940E-02,0.6510E-02,0.5243E-02,0.4139E-02,0.3197E-02,0.2409E-02,
     +0.1768E-02,0.1262E-02,0.8747E-03,0.5893E-03,0.3868E-03,0.2481E-03,
     +0.1879E-03,0.1433E-03,0.1097E-03,0.8372E-04,0.6335E-04,0.4714E-04,
     +0.3417E-04,0.2384E-04,0.1577E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,8),I=1,104) /
     +0.3893E+00,0.3787E+00,0.3683E+00,0.3581E+00,0.3481E+00,0.3383E+00,
     +0.3287E+00,0.3193E+00,0.3102E+00,0.3012E+00,0.2924E+00,0.2838E+00,
     +0.2754E+00,0.2672E+00,0.2591E+00,0.2513E+00,0.2436E+00,0.2360E+00,
     +0.2287E+00,0.2215E+00,0.2145E+00,0.2076E+00,0.2009E+00,0.1943E+00,
     +0.1879E+00,0.1816E+00,0.1755E+00,0.1695E+00,0.1637E+00,0.1580E+00,
     +0.1524E+00,0.1470E+00,0.1417E+00,0.1365E+00,0.1315E+00,0.1265E+00,
     +0.1217E+00,0.1170E+00,0.1125E+00,0.1080E+00,0.1037E+00,0.9947E-01,
     +0.9536E-01,0.9134E-01,0.8744E-01,0.8363E-01,0.7993E-01,0.7632E-01,
     +0.7281E-01,0.6939E-01,0.6606E-01,0.6282E-01,0.5967E-01,0.5661E-01,
     +0.5362E-01,0.5072E-01,0.4790E-01,0.4516E-01,0.4249E-01,0.3989E-01,
     +0.3738E-01,0.3493E-01,0.3255E-01,0.3025E-01,0.2801E-01,0.2585E-01,
     +0.2376E-01,0.2174E-01,0.1980E-01,0.1793E-01,0.1614E-01,0.1444E-01,
     +0.1281E-01,0.1128E-01,0.9836E-02,0.8490E-02,0.7244E-02,0.6102E-02,
     +0.5067E-02,0.4141E-02,0.3324E-02,0.2616E-02,0.2015E-02,0.1514E-02,
     +0.1109E-02,0.7895E-03,0.5463E-03,0.3674E-03,0.2408E-03,0.1541E-03,
     +0.1164E-03,0.8849E-04,0.6743E-04,0.5123E-04,0.3854E-04,0.2849E-04,
     +0.2050E-04,0.1419E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,1),I=1,104) /
     +0.1512E-01,0.1597E-01,0.1687E-01,0.1782E-01,0.1882E-01,0.1988E-01,
     +0.2100E-01,0.2218E-01,0.2342E-01,0.2473E-01,0.2612E-01,0.2758E-01,
     +0.2912E-01,0.3075E-01,0.3247E-01,0.3428E-01,0.3619E-01,0.3821E-01,
     +0.4034E-01,0.4258E-01,0.4495E-01,0.4744E-01,0.5007E-01,0.5285E-01,
     +0.5577E-01,0.5885E-01,0.6210E-01,0.6552E-01,0.6913E-01,0.7292E-01,
     +0.7692E-01,0.8113E-01,0.8556E-01,0.9022E-01,0.9513E-01,0.1003E+00,
     +0.1057E+00,0.1114E+00,0.1174E+00,0.1237E+00,0.1303E+00,0.1372E+00,
     +0.1445E+00,0.1521E+00,0.1601E+00,0.1685E+00,0.1772E+00,0.1863E+00,
     +0.1959E+00,0.2059E+00,0.2162E+00,0.2271E+00,0.2383E+00,0.2500E+00,
     +0.2621E+00,0.2746E+00,0.2875E+00,0.3008E+00,0.3145E+00,0.3285E+00,
     +0.3428E+00,0.3573E+00,0.3720E+00,0.3869E+00,0.4017E+00,0.4164E+00,
     +0.4309E+00,0.4450E+00,0.4585E+00,0.4713E+00,0.4830E+00,0.4935E+00,
     +0.5024E+00,0.5095E+00,0.5142E+00,0.5163E+00,0.5154E+00,0.5110E+00,
     +0.5027E+00,0.4902E+00,0.4731E+00,0.4512E+00,0.4244E+00,0.3928E+00,
     +0.3567E+00,0.3168E+00,0.2739E+00,0.2292E+00,0.1844E+00,0.1413E+00,
     +0.1168E+00,0.9530E-01,0.7658E-01,0.6048E-01,0.4680E-01,0.3535E-01,
     +0.2590E-01,0.1827E-01,0.1226E-01,0.7685E-02,0.4368E-02,0.2138E-02,
     +0.8110E-03,0.1805E-03/
      DATA (XQDUM (I,4,2),I=1,104) /
     +0.8617E-02,0.9102E-02,0.9613E-02,0.1015E-01,0.1072E-01,0.1132E-01,
     +0.1196E-01,0.1263E-01,0.1334E-01,0.1408E-01,0.1487E-01,0.1570E-01,
     +0.1658E-01,0.1750E-01,0.1848E-01,0.1950E-01,0.2059E-01,0.2173E-01,
     +0.2294E-01,0.2421E-01,0.2555E-01,0.2697E-01,0.2846E-01,0.3003E-01,
     +0.3168E-01,0.3342E-01,0.3526E-01,0.3719E-01,0.3923E-01,0.4137E-01,
     +0.4362E-01,0.4600E-01,0.4849E-01,0.5111E-01,0.5387E-01,0.5676E-01,
     +0.5980E-01,0.6300E-01,0.6635E-01,0.6986E-01,0.7354E-01,0.7740E-01,
     +0.8144E-01,0.8566E-01,0.9008E-01,0.9469E-01,0.9950E-01,0.1045E+00,
     +0.1097E+00,0.1152E+00,0.1208E+00,0.1266E+00,0.1327E+00,0.1389E+00,
     +0.1453E+00,0.1520E+00,0.1587E+00,0.1656E+00,0.1727E+00,0.1798E+00,
     +0.1870E+00,0.1942E+00,0.2014E+00,0.2084E+00,0.2154E+00,0.2220E+00,
     +0.2284E+00,0.2343E+00,0.2397E+00,0.2444E+00,0.2483E+00,0.2512E+00,
     +0.2530E+00,0.2535E+00,0.2524E+00,0.2497E+00,0.2452E+00,0.2386E+00,
     +0.2299E+00,0.2190E+00,0.2059E+00,0.1906E+00,0.1734E+00,0.1544E+00,
     +0.1342E+00,0.1132E+00,0.9224E-01,0.7202E-01,0.5336E-01,0.3700E-01,
     +0.2853E-01,0.2159E-01,0.1601E-01,0.1159E-01,0.8159E-02,0.5555E-02,
     +0.3630E-02,0.2251E-02,0.1304E-02,0.6893E-03,0.3194E-03,0.1211E-03,
     +0.3268E-04,0.0000E+00/
      DATA (XQDUM (I,4,3),I=1,104) /
     +0.4719E+02,0.4582E+02,0.4448E+02,0.4317E+02,0.4190E+02,0.4065E+02,
     +0.3944E+02,0.3826E+02,0.3710E+02,0.3597E+02,0.3487E+02,0.3380E+02,
     +0.3275E+02,0.3173E+02,0.3074E+02,0.2977E+02,0.2882E+02,0.2790E+02,
     +0.2700E+02,0.2612E+02,0.2527E+02,0.2444E+02,0.2363E+02,0.2284E+02,
     +0.2207E+02,0.2132E+02,0.2059E+02,0.1988E+02,0.1919E+02,0.1852E+02,
     +0.1787E+02,0.1723E+02,0.1661E+02,0.1601E+02,0.1542E+02,0.1485E+02,
     +0.1429E+02,0.1375E+02,0.1323E+02,0.1272E+02,0.1222E+02,0.1174E+02,
     +0.1126E+02,0.1081E+02,0.1036E+02,0.9929E+01,0.9507E+01,0.9097E+01,
     +0.8698E+01,0.8309E+01,0.7930E+01,0.7561E+01,0.7202E+01,0.6852E+01,
     +0.6510E+01,0.6177E+01,0.5851E+01,0.5534E+01,0.5224E+01,0.4922E+01,
     +0.4626E+01,0.4338E+01,0.4057E+01,0.3782E+01,0.3515E+01,0.3254E+01,
     +0.3000E+01,0.2754E+01,0.2516E+01,0.2286E+01,0.2064E+01,0.1851E+01,
     +0.1648E+01,0.1455E+01,0.1272E+01,0.1102E+01,0.9430E+00,0.7968E+00,
     +0.6636E+00,0.5437E+00,0.4373E+00,0.3443E+00,0.2645E+00,0.1975E+00,
     +0.1426E+00,0.9890E-01,0.6526E-01,0.4042E-01,0.2297E-01,0.1142E-01,
     +0.6717E-02,0.3515E-02,0.1376E-02,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,4),I=1,104) /
     +0.6565E+01,0.6388E+01,0.6216E+01,0.6048E+01,0.5884E+01,0.5724E+01,
     +0.5567E+01,0.5415E+01,0.5266E+01,0.5121E+01,0.4980E+01,0.4841E+01,
     +0.4707E+01,0.4575E+01,0.4447E+01,0.4322E+01,0.4200E+01,0.4082E+01,
     +0.3966E+01,0.3853E+01,0.3743E+01,0.3636E+01,0.3531E+01,0.3429E+01,
     +0.3330E+01,0.3233E+01,0.3138E+01,0.3046E+01,0.2957E+01,0.2869E+01,
     +0.2784E+01,0.2701E+01,0.2620E+01,0.2540E+01,0.2463E+01,0.2388E+01,
     +0.2315E+01,0.2243E+01,0.2173E+01,0.2104E+01,0.2037E+01,0.1972E+01,
     +0.1908E+01,0.1845E+01,0.1784E+01,0.1724E+01,0.1664E+01,0.1606E+01,
     +0.1549E+01,0.1493E+01,0.1437E+01,0.1382E+01,0.1328E+01,0.1274E+01,
     +0.1221E+01,0.1169E+01,0.1116E+01,0.1064E+01,0.1013E+01,0.9613E+00,
     +0.9102E+00,0.8593E+00,0.8088E+00,0.7586E+00,0.7089E+00,0.6596E+00,
     +0.6110E+00,0.5631E+00,0.5162E+00,0.4704E+00,0.4259E+00,0.3831E+00,
     +0.3420E+00,0.3029E+00,0.2661E+00,0.2316E+00,0.1996E+00,0.1703E+00,
     +0.1436E+00,0.1194E+00,0.9788E-01,0.7876E-01,0.6198E-01,0.4745E-01,
     +0.3509E-01,0.2484E-01,0.1666E-01,0.1045E-01,0.6057E-02,0.3214E-02,
     +0.2104E-02,0.1376E-02,0.9060E-03,0.6028E-03,0.4055E-03,0.2743E-03,
     +0.1843E-03,0.1210E-03,0.7593E-04,0.4431E-04,0.2313E-04,0.1014E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,5),I=1,104) /
     +0.1491E+01,0.1455E+01,0.1420E+01,0.1386E+01,0.1352E+01,0.1320E+01,
     +0.1288E+01,0.1257E+01,0.1226E+01,0.1197E+01,0.1168E+01,0.1140E+01,
     +0.1112E+01,0.1085E+01,0.1059E+01,0.1034E+01,0.1009E+01,0.9842E+00,
     +0.9604E+00,0.9372E+00,0.9146E+00,0.8926E+00,0.8710E+00,0.8500E+00,
     +0.8295E+00,0.8095E+00,0.7899E+00,0.7708E+00,0.7522E+00,0.7340E+00,
     +0.7162E+00,0.6988E+00,0.6818E+00,0.6651E+00,0.6488E+00,0.6329E+00,
     +0.6172E+00,0.6019E+00,0.5868E+00,0.5720E+00,0.5575E+00,0.5431E+00,
     +0.5290E+00,0.5150E+00,0.5012E+00,0.4876E+00,0.4740E+00,0.4606E+00,
     +0.4472E+00,0.4338E+00,0.4205E+00,0.4072E+00,0.3938E+00,0.3804E+00,
     +0.3669E+00,0.3533E+00,0.3396E+00,0.3258E+00,0.3119E+00,0.2978E+00,
     +0.2836E+00,0.2692E+00,0.2547E+00,0.2401E+00,0.2255E+00,0.2108E+00,
     +0.1962E+00,0.1816E+00,0.1672E+00,0.1530E+00,0.1391E+00,0.1256E+00,
     +0.1126E+00,0.1001E+00,0.8833E-01,0.7725E-01,0.6693E-01,0.5741E-01,
     +0.4870E-01,0.4078E-01,0.3365E-01,0.2727E-01,0.2160E-01,0.1663E-01,
     +0.1235E-01,0.8749E-02,0.5843E-02,0.3622E-02,0.2048E-02,0.1037E-02,
     +0.6505E-03,0.4034E-03,0.2496E-03,0.1555E-03,0.9830E-04,0.6315E-04,
     +0.4090E-04,0.2624E-04,0.1627E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,6),I=1,104) /
     +0.1317E+01,0.1281E+01,0.1246E+01,0.1212E+01,0.1178E+01,0.1145E+01,
     +0.1114E+01,0.1083E+01,0.1052E+01,0.1023E+01,0.9939E+00,0.9657E+00,
     +0.9383E+00,0.9115E+00,0.8854E+00,0.8599E+00,0.8350E+00,0.8108E+00,
     +0.7872E+00,0.7642E+00,0.7417E+00,0.7198E+00,0.6985E+00,0.6777E+00,
     +0.6574E+00,0.6376E+00,0.6183E+00,0.5996E+00,0.5813E+00,0.5634E+00,
     +0.5460E+00,0.5291E+00,0.5126E+00,0.4964E+00,0.4807E+00,0.4654E+00,
     +0.4505E+00,0.4359E+00,0.4217E+00,0.4078E+00,0.3942E+00,0.3810E+00,
     +0.3680E+00,0.3553E+00,0.3429E+00,0.3308E+00,0.3189E+00,0.3072E+00,
     +0.2958E+00,0.2845E+00,0.2734E+00,0.2626E+00,0.2518E+00,0.2412E+00,
     +0.2308E+00,0.2204E+00,0.2102E+00,0.2001E+00,0.1901E+00,0.1801E+00,
     +0.1703E+00,0.1605E+00,0.1509E+00,0.1413E+00,0.1318E+00,0.1225E+00,
     +0.1133E+00,0.1043E+00,0.9553E-01,0.8695E-01,0.7865E-01,0.7065E-01,
     +0.6300E-01,0.5574E-01,0.4889E-01,0.4249E-01,0.3657E-01,0.3114E-01,
     +0.2620E-01,0.2175E-01,0.1778E-01,0.1427E-01,0.1120E-01,0.8559E-02,
     +0.6320E-02,0.4474E-02,0.3006E-02,0.1895E-02,0.1109E-02,0.5992E-03,
     +0.3983E-03,0.2654E-03,0.1782E-03,0.1209E-03,0.8279E-04,0.5679E-04,
     +0.3856E-04,0.2549E-04,0.1607E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,7),I=1,104) /
     +0.1200E+01,0.1164E+01,0.1129E+01,0.1095E+01,0.1062E+01,0.1029E+01,
     +0.9974E+00,0.9664E+00,0.9361E+00,0.9066E+00,0.8778E+00,0.8497E+00,
     +0.8223E+00,0.7956E+00,0.7695E+00,0.7441E+00,0.7193E+00,0.6952E+00,
     +0.6716E+00,0.6487E+00,0.6264E+00,0.6046E+00,0.5834E+00,0.5627E+00,
     +0.5426E+00,0.5230E+00,0.5039E+00,0.4853E+00,0.4673E+00,0.4497E+00,
     +0.4326E+00,0.4159E+00,0.3997E+00,0.3840E+00,0.3686E+00,0.3537E+00,
     +0.3393E+00,0.3252E+00,0.3115E+00,0.2982E+00,0.2853E+00,0.2728E+00,
     +0.2606E+00,0.2488E+00,0.2374E+00,0.2262E+00,0.2154E+00,0.2050E+00,
     +0.1948E+00,0.1849E+00,0.1754E+00,0.1661E+00,0.1571E+00,0.1484E+00,
     +0.1400E+00,0.1318E+00,0.1239E+00,0.1163E+00,0.1089E+00,0.1017E+00,
     +0.9478E-01,0.8810E-01,0.8164E-01,0.7542E-01,0.6943E-01,0.6367E-01,
     +0.5814E-01,0.5284E-01,0.4778E-01,0.4296E-01,0.3838E-01,0.3405E-01,
     +0.2997E-01,0.2616E-01,0.2261E-01,0.1934E-01,0.1634E-01,0.1363E-01,
     +0.1121E-01,0.9065E-02,0.7201E-02,0.5608E-02,0.4272E-02,0.3178E-02,
     +0.2303E-02,0.1625E-02,0.1115E-02,0.7439E-03,0.4839E-03,0.3069E-03,
     +0.2302E-03,0.1734E-03,0.1307E-03,0.9790E-04,0.7245E-04,0.5255E-04,
     +0.3699E-04,0.2498E-04,0.1593E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,8),I=1,104) /
     +0.1065E+01,0.1032E+01,0.1001E+01,0.9694E+00,0.9390E+00,0.9093E+00,
     +0.8805E+00,0.8523E+00,0.8248E+00,0.7981E+00,0.7720E+00,0.7466E+00,
     +0.7218E+00,0.6977E+00,0.6742E+00,0.6513E+00,0.6290E+00,0.6073E+00,
     +0.5862E+00,0.5656E+00,0.5456E+00,0.5261E+00,0.5071E+00,0.4886E+00,
     +0.4707E+00,0.4532E+00,0.4362E+00,0.4197E+00,0.4036E+00,0.3880E+00,
     +0.3728E+00,0.3581E+00,0.3437E+00,0.3298E+00,0.3163E+00,0.3031E+00,
     +0.2904E+00,0.2780E+00,0.2660E+00,0.2543E+00,0.2430E+00,0.2320E+00,
     +0.2214E+00,0.2111E+00,0.2010E+00,0.1913E+00,0.1819E+00,0.1728E+00,
     +0.1640E+00,0.1555E+00,0.1472E+00,0.1392E+00,0.1314E+00,0.1239E+00,
     +0.1167E+00,0.1096E+00,0.1029E+00,0.9631E-01,0.8998E-01,0.8388E-01,
     +0.7800E-01,0.7233E-01,0.6687E-01,0.6162E-01,0.5658E-01,0.5175E-01,
     +0.4713E-01,0.4272E-01,0.3852E-01,0.3453E-01,0.3076E-01,0.2721E-01,
     +0.2388E-01,0.2078E-01,0.1790E-01,0.1526E-01,0.1286E-01,0.1069E-01,
     +0.8763E-02,0.7066E-02,0.5596E-02,0.4345E-02,0.3300E-02,0.2448E-02,
     +0.1770E-02,0.1246E-02,0.8530E-03,0.5682E-03,0.3687E-03,0.2330E-03,
     +0.1742E-03,0.1307E-03,0.9800E-04,0.7299E-04,0.5366E-04,0.3863E-04,
     +0.2697E-04,0.1805E-04,0.1139E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,1),I=1,104) /
     +0.1664E-01,0.1757E-01,0.1856E-01,0.1959E-01,0.2069E-01,0.2184E-01,
     +0.2306E-01,0.2434E-01,0.2570E-01,0.2713E-01,0.2864E-01,0.3023E-01,
     +0.3190E-01,0.3367E-01,0.3554E-01,0.3750E-01,0.3957E-01,0.4176E-01,
     +0.4406E-01,0.4648E-01,0.4904E-01,0.5173E-01,0.5457E-01,0.5755E-01,
     +0.6070E-01,0.6401E-01,0.6749E-01,0.7116E-01,0.7502E-01,0.7908E-01,
     +0.8335E-01,0.8783E-01,0.9255E-01,0.9750E-01,0.1027E+00,0.1082E+00,
     +0.1139E+00,0.1199E+00,0.1262E+00,0.1329E+00,0.1398E+00,0.1470E+00,
     +0.1546E+00,0.1626E+00,0.1709E+00,0.1796E+00,0.1886E+00,0.1980E+00,
     +0.2078E+00,0.2180E+00,0.2286E+00,0.2396E+00,0.2510E+00,0.2628E+00,
     +0.2749E+00,0.2874E+00,0.3003E+00,0.3134E+00,0.3269E+00,0.3405E+00,
     +0.3544E+00,0.3683E+00,0.3824E+00,0.3963E+00,0.4102E+00,0.4237E+00,
     +0.4368E+00,0.4494E+00,0.4612E+00,0.4719E+00,0.4815E+00,0.4896E+00,
     +0.4959E+00,0.5001E+00,0.5019E+00,0.5009E+00,0.4968E+00,0.4891E+00,
     +0.4777E+00,0.4622E+00,0.4423E+00,0.4181E+00,0.3895E+00,0.3568E+00,
     +0.3204E+00,0.2811E+00,0.2398E+00,0.1978E+00,0.1566E+00,0.1178E+00,
     +0.9619E-01,0.7746E-01,0.6139E-01,0.4778E-01,0.3639E-01,0.2701E-01,
     +0.1941E-01,0.1339E-01,0.8757E-02,0.5322E-02,0.2913E-02,0.1356E-02,
     +0.4793E-03,0.9441E-04/
      DATA (XQDUM (I,5,2),I=1,104) /
     +0.9474E-02,0.1000E-01,0.1056E-01,0.1115E-01,0.1177E-01,0.1243E-01,
     +0.1312E-01,0.1385E-01,0.1462E-01,0.1543E-01,0.1628E-01,0.1718E-01,
     +0.1814E-01,0.1914E-01,0.2019E-01,0.2131E-01,0.2248E-01,0.2372E-01,
     +0.2502E-01,0.2639E-01,0.2783E-01,0.2935E-01,0.3096E-01,0.3264E-01,
     +0.3441E-01,0.3628E-01,0.3824E-01,0.4031E-01,0.4248E-01,0.4476E-01,
     +0.4715E-01,0.4967E-01,0.5231E-01,0.5509E-01,0.5800E-01,0.6105E-01,
     +0.6425E-01,0.6760E-01,0.7111E-01,0.7478E-01,0.7862E-01,0.8264E-01,
     +0.8683E-01,0.9120E-01,0.9575E-01,0.1005E+00,0.1054E+00,0.1106E+00,
     +0.1159E+00,0.1214E+00,0.1271E+00,0.1329E+00,0.1390E+00,0.1452E+00,
     +0.1516E+00,0.1581E+00,0.1647E+00,0.1714E+00,0.1782E+00,0.1850E+00,
     +0.1918E+00,0.1986E+00,0.2053E+00,0.2117E+00,0.2179E+00,0.2238E+00,
     +0.2293E+00,0.2343E+00,0.2386E+00,0.2421E+00,0.2447E+00,0.2463E+00,
     +0.2466E+00,0.2456E+00,0.2431E+00,0.2389E+00,0.2329E+00,0.2249E+00,
     +0.2150E+00,0.2031E+00,0.1892E+00,0.1734E+00,0.1561E+00,0.1374E+00,
     +0.1180E+00,0.9825E-01,0.7890E-01,0.6064E-01,0.4414E-01,0.3000E-01,
     +0.2282E-01,0.1703E-01,0.1244E-01,0.8862E-02,0.6133E-02,0.4098E-02,
     +0.2622E-02,0.1588E-02,0.8954E-03,0.4579E-03,0.2038E-03,0.7326E-04,
     +0.1829E-04,0.0000E+00/
      DATA (XQDUM (I,5,3),I=1,104) /
     +0.7107E+02,0.6869E+02,0.6637E+02,0.6412E+02,0.6193E+02,0.5980E+02,
     +0.5774E+02,0.5573E+02,0.5378E+02,0.5188E+02,0.5005E+02,0.4826E+02,
     +0.4653E+02,0.4484E+02,0.4321E+02,0.4163E+02,0.4009E+02,0.3860E+02,
     +0.3715E+02,0.3575E+02,0.3439E+02,0.3307E+02,0.3179E+02,0.3055E+02,
     +0.2935E+02,0.2819E+02,0.2706E+02,0.2597E+02,0.2492E+02,0.2389E+02,
     +0.2290E+02,0.2194E+02,0.2102E+02,0.2012E+02,0.1925E+02,0.1841E+02,
     +0.1760E+02,0.1682E+02,0.1606E+02,0.1533E+02,0.1462E+02,0.1394E+02,
     +0.1328E+02,0.1264E+02,0.1202E+02,0.1143E+02,0.1085E+02,0.1030E+02,
     +0.9762E+01,0.9245E+01,0.8746E+01,0.8264E+01,0.7799E+01,0.7351E+01,
     +0.6918E+01,0.6501E+01,0.6098E+01,0.5710E+01,0.5335E+01,0.4974E+01,
     +0.4627E+01,0.4292E+01,0.3970E+01,0.3661E+01,0.3364E+01,0.3079E+01,
     +0.2807E+01,0.2547E+01,0.2299E+01,0.2064E+01,0.1841E+01,0.1631E+01,
     +0.1435E+01,0.1251E+01,0.1081E+01,0.9247E+00,0.7818E+00,0.6526E+00,
     +0.5370E+00,0.4348E+00,0.3456E+00,0.2689E+00,0.2043E+00,0.1508E+00,
     +0.1076E+00,0.7373E-01,0.4798E-01,0.2918E-01,0.1611E-01,0.7546E-02,
     +0.4099E-02,0.1781E-02,0.2646E-03,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,4),I=1,104) /
     +0.1078E+02,0.1045E+02,0.1012E+02,0.9807E+01,0.9499E+01,0.9200E+01,
     +0.8909E+01,0.8626E+01,0.8351E+01,0.8083E+01,0.7824E+01,0.7571E+01,
     +0.7325E+01,0.7087E+01,0.6855E+01,0.6630E+01,0.6411E+01,0.6199E+01,
     +0.5993E+01,0.5793E+01,0.5598E+01,0.5409E+01,0.5226E+01,0.5048E+01,
     +0.4875E+01,0.4707E+01,0.4545E+01,0.4387E+01,0.4233E+01,0.4085E+01,
     +0.3940E+01,0.3800E+01,0.3664E+01,0.3532E+01,0.3404E+01,0.3280E+01,
     +0.3159E+01,0.3042E+01,0.2928E+01,0.2818E+01,0.2710E+01,0.2606E+01,
     +0.2504E+01,0.2406E+01,0.2310E+01,0.2216E+01,0.2125E+01,0.2037E+01,
     +0.1950E+01,0.1866E+01,0.1783E+01,0.1703E+01,0.1624E+01,0.1547E+01,
     +0.1471E+01,0.1397E+01,0.1324E+01,0.1253E+01,0.1183E+01,0.1114E+01,
     +0.1047E+01,0.9809E+00,0.9160E+00,0.8524E+00,0.7902E+00,0.7295E+00,
     +0.6703E+00,0.6129E+00,0.5573E+00,0.5038E+00,0.4525E+00,0.4036E+00,
     +0.3573E+00,0.3138E+00,0.2732E+00,0.2356E+00,0.2012E+00,0.1699E+00,
     +0.1418E+00,0.1166E+00,0.9443E-01,0.7502E-01,0.5825E-01,0.4397E-01,
     +0.3205E-01,0.2237E-01,0.1481E-01,0.9200E-02,0.5308E-02,0.2829E-02,
     +0.1867E-02,0.1236E-02,0.8235E-03,0.5536E-03,0.3743E-03,0.2526E-03,
     +0.1680E-03,0.1083E-03,0.6630E-04,0.3753E-04,0.1889E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,5),I=1,104) /
     +0.2260E+01,0.2195E+01,0.2132E+01,0.2071E+01,0.2011E+01,0.1953E+01,
     +0.1896E+01,0.1842E+01,0.1788E+01,0.1736E+01,0.1686E+01,0.1637E+01,
     +0.1589E+01,0.1543E+01,0.1497E+01,0.1454E+01,0.1411E+01,0.1370E+01,
     +0.1329E+01,0.1290E+01,0.1252E+01,0.1215E+01,0.1179E+01,0.1144E+01,
     +0.1110E+01,0.1077E+01,0.1045E+01,0.1014E+01,0.9838E+00,0.9544E+00,
     +0.9258E+00,0.8979E+00,0.8708E+00,0.8444E+00,0.8188E+00,0.7938E+00,
     +0.7694E+00,0.7457E+00,0.7225E+00,0.6999E+00,0.6778E+00,0.6563E+00,
     +0.6352E+00,0.6145E+00,0.5943E+00,0.5744E+00,0.5549E+00,0.5357E+00,
     +0.5168E+00,0.4982E+00,0.4798E+00,0.4615E+00,0.4435E+00,0.4256E+00,
     +0.4079E+00,0.3902E+00,0.3727E+00,0.3552E+00,0.3378E+00,0.3204E+00,
     +0.3031E+00,0.2858E+00,0.2687E+00,0.2516E+00,0.2347E+00,0.2180E+00,
     +0.2015E+00,0.1853E+00,0.1694E+00,0.1540E+00,0.1391E+00,0.1247E+00,
     +0.1110E+00,0.9804E-01,0.8586E-01,0.7453E-01,0.6407E-01,0.5450E-01,
     +0.4581E-01,0.3800E-01,0.3103E-01,0.2486E-01,0.1945E-01,0.1477E-01,
     +0.1081E-01,0.7545E-02,0.4964E-02,0.3035E-02,0.1697E-02,0.8569E-03,
     +0.5393E-03,0.3375E-03,0.2117E-03,0.1341E-03,0.8601E-04,0.5572E-04,
     +0.3605E-04,0.2287E-04,0.1390E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,6),I=1,104) /
     +0.2085E+01,0.2021E+01,0.1958E+01,0.1896E+01,0.1837E+01,0.1779E+01,
     +0.1722E+01,0.1668E+01,0.1614E+01,0.1562E+01,0.1512E+01,0.1463E+01,
     +0.1415E+01,0.1369E+01,0.1324E+01,0.1280E+01,0.1238E+01,0.1197E+01,
     +0.1157E+01,0.1118E+01,0.1080E+01,0.1043E+01,0.1007E+01,0.9726E+00,
     +0.9389E+00,0.9063E+00,0.8746E+00,0.8438E+00,0.8139E+00,0.7849E+00,
     +0.7567E+00,0.7294E+00,0.7028E+00,0.6771E+00,0.6521E+00,0.6278E+00,
     +0.6043E+00,0.5814E+00,0.5592E+00,0.5377E+00,0.5167E+00,0.4964E+00,
     +0.4766E+00,0.4574E+00,0.4387E+00,0.4205E+00,0.4028E+00,0.3856E+00,
     +0.3688E+00,0.3524E+00,0.3365E+00,0.3209E+00,0.3057E+00,0.2908E+00,
     +0.2763E+00,0.2620E+00,0.2481E+00,0.2345E+00,0.2211E+00,0.2080E+00,
     +0.1952E+00,0.1827E+00,0.1704E+00,0.1584E+00,0.1467E+00,0.1353E+00,
     +0.1242E+00,0.1134E+00,0.1030E+00,0.9306E-01,0.8350E-01,0.7440E-01,
     +0.6580E-01,0.5773E-01,0.5020E-01,0.4324E-01,0.3687E-01,0.3109E-01,
     +0.2589E-01,0.2126E-01,0.1717E-01,0.1361E-01,0.1055E-01,0.7948E-02,
     +0.5788E-02,0.4042E-02,0.2683E-02,0.1675E-02,0.9766E-03,0.5294E-03,
     +0.3544E-03,0.2383E-03,0.1615E-03,0.1103E-03,0.7557E-04,0.5154E-04,
     +0.3455E-04,0.2241E-04,0.1378E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,7),I=1,104) /
     +0.1969E+01,0.1904E+01,0.1841E+01,0.1780E+01,0.1721E+01,0.1663E+01,
     +0.1606E+01,0.1552E+01,0.1498E+01,0.1446E+01,0.1396E+01,0.1347E+01,
     +0.1300E+01,0.1253E+01,0.1208E+01,0.1165E+01,0.1122E+01,0.1081E+01,
     +0.1041E+01,0.1002E+01,0.9647E+00,0.9281E+00,0.8926E+00,0.8581E+00,
     +0.8246E+00,0.7921E+00,0.7606E+00,0.7301E+00,0.7005E+00,0.6718E+00,
     +0.6439E+00,0.6169E+00,0.5908E+00,0.5655E+00,0.5409E+00,0.5172E+00,
     +0.4941E+00,0.4719E+00,0.4503E+00,0.4294E+00,0.4092E+00,0.3897E+00,
     +0.3708E+00,0.3526E+00,0.3349E+00,0.3179E+00,0.3014E+00,0.2855E+00,
     +0.2701E+00,0.2552E+00,0.2409E+00,0.2271E+00,0.2137E+00,0.2009E+00,
     +0.1885E+00,0.1766E+00,0.1651E+00,0.1540E+00,0.1434E+00,0.1332E+00,
     +0.1233E+00,0.1139E+00,0.1049E+00,0.9626E-01,0.8801E-01,0.8014E-01,
     +0.7265E-01,0.6554E-01,0.5880E-01,0.5245E-01,0.4648E-01,0.4089E-01,
     +0.3568E-01,0.3086E-01,0.2644E-01,0.2240E-01,0.1875E-01,0.1549E-01,
     +0.1261E-01,0.1010E-01,0.7940E-02,0.6121E-02,0.4617E-02,0.3401E-02,
     +0.2442E-02,0.1708E-02,0.1162E-02,0.7693E-03,0.4961E-03,0.3111E-03,
     +0.2312E-03,0.1722E-03,0.1280E-03,0.9440E-04,0.6861E-04,0.4876E-04,
     +0.3355E-04,0.2209E-04,0.1370E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,8),I=1,104) /
     +0.1837E+01,0.1775E+01,0.1716E+01,0.1657E+01,0.1601E+01,0.1546E+01,
     +0.1492E+01,0.1440E+01,0.1390E+01,0.1341E+01,0.1293E+01,0.1247E+01,
     +0.1202E+01,0.1158E+01,0.1116E+01,0.1075E+01,0.1035E+01,0.9959E+00,
     +0.9582E+00,0.9217E+00,0.8863E+00,0.8519E+00,0.8186E+00,0.7862E+00,
     +0.7549E+00,0.7245E+00,0.6950E+00,0.6665E+00,0.6389E+00,0.6121E+00,
     +0.5861E+00,0.5610E+00,0.5367E+00,0.5131E+00,0.4904E+00,0.4683E+00,
     +0.4470E+00,0.4263E+00,0.4064E+00,0.3871E+00,0.3685E+00,0.3505E+00,
     +0.3331E+00,0.3163E+00,0.3000E+00,0.2844E+00,0.2693E+00,0.2547E+00,
     +0.2406E+00,0.2270E+00,0.2140E+00,0.2014E+00,0.1892E+00,0.1775E+00,
     +0.1663E+00,0.1555E+00,0.1451E+00,0.1351E+00,0.1255E+00,0.1163E+00,
     +0.1075E+00,0.9911E-01,0.9106E-01,0.8337E-01,0.7604E-01,0.6907E-01,
     +0.6246E-01,0.5620E-01,0.5029E-01,0.4473E-01,0.3953E-01,0.3467E-01,
     +0.3017E-01,0.2602E-01,0.2222E-01,0.1877E-01,0.1567E-01,0.1290E-01,
     +0.1047E-01,0.8359E-02,0.6554E-02,0.5038E-02,0.3789E-02,0.2784E-02,
     +0.1994E-02,0.1391E-02,0.9445E-03,0.6239E-03,0.4011E-03,0.2504E-03,
     +0.1854E-03,0.1374E-03,0.1016E-03,0.7443E-04,0.5370E-04,0.3785E-04,
     +0.2582E-04,0.1683E-04,0.1032E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,9),I=1,104) /
     +0.3727E+00,0.3587E+00,0.3450E+00,0.3318E+00,0.3190E+00,0.3066E+00,
     +0.2947E+00,0.2831E+00,0.2719E+00,0.2610E+00,0.2505E+00,0.2404E+00,
     +0.2306E+00,0.2211E+00,0.2119E+00,0.2031E+00,0.1945E+00,0.1863E+00,
     +0.1783E+00,0.1706E+00,0.1632E+00,0.1560E+00,0.1491E+00,0.1424E+00,
     +0.1359E+00,0.1297E+00,0.1238E+00,0.1180E+00,0.1124E+00,0.1071E+00,
     +0.1019E+00,0.9698E-01,0.9220E-01,0.8761E-01,0.8319E-01,0.7894E-01,
     +0.7485E-01,0.7093E-01,0.6716E-01,0.6353E-01,0.6005E-01,0.5672E-01,
     +0.5351E-01,0.5044E-01,0.4750E-01,0.4468E-01,0.4198E-01,0.3939E-01,
     +0.3692E-01,0.3455E-01,0.3229E-01,0.3013E-01,0.2807E-01,0.2610E-01,
     +0.2423E-01,0.2245E-01,0.2075E-01,0.1913E-01,0.1760E-01,0.1615E-01,
     +0.1477E-01,0.1347E-01,0.1225E-01,0.1109E-01,0.1000E-01,0.8982E-02,
     +0.8028E-02,0.7138E-02,0.6311E-02,0.5545E-02,0.4840E-02,0.4193E-02,
     +0.3602E-02,0.3067E-02,0.2586E-02,0.2156E-02,0.1777E-02,0.1445E-02,
     +0.1158E-02,0.9127E-03,0.7069E-03,0.5371E-03,0.3995E-03,0.2903E-03,
     +0.2058E-03,0.1421E-03,0.9544E-04,0.6221E-04,0.3927E-04,0.2387E-04,
     +0.1728E-04,0.1249E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,1),I=1,104) /
     +0.1806E-01,0.1906E-01,0.2012E-01,0.2124E-01,0.2242E-01,0.2366E-01,
     +0.2497E-01,0.2635E-01,0.2781E-01,0.2934E-01,0.3096E-01,0.3267E-01,
     +0.3447E-01,0.3636E-01,0.3836E-01,0.4046E-01,0.4268E-01,0.4501E-01,
     +0.4747E-01,0.5006E-01,0.5278E-01,0.5565E-01,0.5866E-01,0.6184E-01,
     +0.6518E-01,0.6869E-01,0.7238E-01,0.7626E-01,0.8034E-01,0.8462E-01,
     +0.8912E-01,0.9385E-01,0.9881E-01,0.1040E+00,0.1095E+00,0.1152E+00,
     +0.1212E+00,0.1275E+00,0.1340E+00,0.1409E+00,0.1481E+00,0.1556E+00,
     +0.1635E+00,0.1717E+00,0.1802E+00,0.1891E+00,0.1984E+00,0.2080E+00,
     +0.2180E+00,0.2283E+00,0.2391E+00,0.2501E+00,0.2616E+00,0.2734E+00,
     +0.2855E+00,0.2979E+00,0.3106E+00,0.3235E+00,0.3366E+00,0.3499E+00,
     +0.3632E+00,0.3766E+00,0.3899E+00,0.4030E+00,0.4159E+00,0.4283E+00,
     +0.4401E+00,0.4513E+00,0.4614E+00,0.4705E+00,0.4781E+00,0.4841E+00,
     +0.4882E+00,0.4901E+00,0.4894E+00,0.4859E+00,0.4792E+00,0.4691E+00,
     +0.4553E+00,0.4376E+00,0.4158E+00,0.3901E+00,0.3604E+00,0.3273E+00,
     +0.2912E+00,0.2528E+00,0.2133E+00,0.1739E+00,0.1358E+00,0.1005E+00,
     +0.8125E-01,0.6472E-01,0.5070E-01,0.3897E-01,0.2929E-01,0.2142E-01,
     +0.1514E-01,0.1025E-01,0.6561E-02,0.3885E-02,0.2059E-02,0.9189E-03,
     +0.3053E-03,0.5376E-04/
      DATA (XQDUM (I,6,2),I=1,104) /
     +0.1027E-01,0.1084E-01,0.1144E-01,0.1208E-01,0.1274E-01,0.1345E-01,
     +0.1419E-01,0.1497E-01,0.1580E-01,0.1667E-01,0.1759E-01,0.1855E-01,
     +0.1957E-01,0.2064E-01,0.2177E-01,0.2296E-01,0.2421E-01,0.2553E-01,
     +0.2691E-01,0.2837E-01,0.2991E-01,0.3152E-01,0.3322E-01,0.3501E-01,
     +0.3689E-01,0.3886E-01,0.4093E-01,0.4311E-01,0.4539E-01,0.4779E-01,
     +0.5031E-01,0.5295E-01,0.5572E-01,0.5862E-01,0.6166E-01,0.6484E-01,
     +0.6817E-01,0.7165E-01,0.7529E-01,0.7909E-01,0.8305E-01,0.8718E-01,
     +0.9148E-01,0.9596E-01,0.1006E+00,0.1055E+00,0.1105E+00,0.1157E+00,
     +0.1210E+00,0.1266E+00,0.1323E+00,0.1381E+00,0.1441E+00,0.1503E+00,
     +0.1566E+00,0.1629E+00,0.1694E+00,0.1759E+00,0.1824E+00,0.1889E+00,
     +0.1954E+00,0.2017E+00,0.2078E+00,0.2137E+00,0.2193E+00,0.2245E+00,
     +0.2291E+00,0.2332E+00,0.2366E+00,0.2391E+00,0.2406E+00,0.2411E+00,
     +0.2403E+00,0.2381E+00,0.2344E+00,0.2290E+00,0.2219E+00,0.2130E+00,
     +0.2022E+00,0.1896E+00,0.1753E+00,0.1594E+00,0.1422E+00,0.1240E+00,
     +0.1054E+00,0.8678E-01,0.6885E-01,0.5222E-01,0.3745E-01,0.2503E-01,
     +0.1882E-01,0.1388E-01,0.1001E-01,0.7040E-02,0.4803E-02,0.3159E-02,
     +0.1986E-02,0.1179E-02,0.6496E-03,0.3231E-03,0.1389E-03,0.4769E-04,
     +0.1112E-04,0.0000E+00/
      DATA (XQDUM (I,6,3),I=1,104) /
     +0.9537E+02,0.9183E+02,0.8840E+02,0.8508E+02,0.8187E+02,0.7875E+02,
     +0.7574E+02,0.7282E+02,0.7000E+02,0.6727E+02,0.6462E+02,0.6207E+02,
     +0.5959E+02,0.5720E+02,0.5489E+02,0.5266E+02,0.5050E+02,0.4841E+02,
     +0.4640E+02,0.4445E+02,0.4257E+02,0.4076E+02,0.3901E+02,0.3732E+02,
     +0.3569E+02,0.3411E+02,0.3260E+02,0.3113E+02,0.2972E+02,0.2836E+02,
     +0.2705E+02,0.2579E+02,0.2458E+02,0.2341E+02,0.2228E+02,0.2120E+02,
     +0.2016E+02,0.1915E+02,0.1819E+02,0.1726E+02,0.1637E+02,0.1552E+02,
     +0.1469E+02,0.1390E+02,0.1314E+02,0.1242E+02,0.1172E+02,0.1105E+02,
     +0.1040E+02,0.9788E+01,0.9197E+01,0.8631E+01,0.8088E+01,0.7569E+01,
     +0.7072E+01,0.6596E+01,0.6141E+01,0.5705E+01,0.5290E+01,0.4893E+01,
     +0.4514E+01,0.4153E+01,0.3810E+01,0.3483E+01,0.3173E+01,0.2879E+01,
     +0.2601E+01,0.2339E+01,0.2093E+01,0.1861E+01,0.1645E+01,0.1444E+01,
     +0.1258E+01,0.1087E+01,0.9305E+00,0.7883E+00,0.6603E+00,0.5461E+00,
     +0.4452E+00,0.3571E+00,0.2813E+00,0.2169E+00,0.1633E+00,0.1194E+00,
     +0.8439E-01,0.5717E-01,0.3670E-01,0.2189E-01,0.1169E-01,0.5093E-02,
     +0.2479E-02,0.7529E-03,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,4),I=1,104) /
     +0.1584E+02,0.1529E+02,0.1477E+02,0.1426E+02,0.1377E+02,0.1329E+02,
     +0.1282E+02,0.1237E+02,0.1194E+02,0.1151E+02,0.1110E+02,0.1071E+02,
     +0.1032E+02,0.9948E+01,0.9587E+01,0.9237E+01,0.8899E+01,0.8571E+01,
     +0.8253E+01,0.7946E+01,0.7649E+01,0.7361E+01,0.7083E+01,0.6813E+01,
     +0.6553E+01,0.6300E+01,0.6057E+01,0.5821E+01,0.5593E+01,0.5372E+01,
     +0.5159E+01,0.4953E+01,0.4754E+01,0.4561E+01,0.4375E+01,0.4195E+01,
     +0.4021E+01,0.3853E+01,0.3690E+01,0.3533E+01,0.3381E+01,0.3234E+01,
     +0.3091E+01,0.2954E+01,0.2820E+01,0.2692E+01,0.2567E+01,0.2446E+01,
     +0.2329E+01,0.2215E+01,0.2105E+01,0.1998E+01,0.1894E+01,0.1793E+01,
     +0.1695E+01,0.1600E+01,0.1508E+01,0.1418E+01,0.1330E+01,0.1245E+01,
     +0.1162E+01,0.1082E+01,0.1004E+01,0.9278E+00,0.8545E+00,0.7836E+00,
     +0.7153E+00,0.6496E+00,0.5867E+00,0.5267E+00,0.4698E+00,0.4162E+00,
     +0.3658E+00,0.3189E+00,0.2756E+00,0.2360E+00,0.1999E+00,0.1674E+00,
     +0.1385E+00,0.1129E+00,0.9051E-01,0.7117E-01,0.5466E-01,0.4080E-01,
     +0.2941E-01,0.2030E-01,0.1330E-01,0.8197E-02,0.4708E-02,0.2511E-02,
     +0.1663E-02,0.1106E-02,0.7399E-03,0.4981E-03,0.3359E-03,0.2249E-03,
     +0.1476E-03,0.9354E-04,0.5605E-04,0.3092E-04,0.1510E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,5),I=1,104) /
     +0.3094E+01,0.2995E+01,0.2899E+01,0.2805E+01,0.2715E+01,0.2627E+01,
     +0.2542E+01,0.2459E+01,0.2379E+01,0.2302E+01,0.2226E+01,0.2153E+01,
     +0.2082E+01,0.2014E+01,0.1947E+01,0.1883E+01,0.1820E+01,0.1760E+01,
     +0.1701E+01,0.1644E+01,0.1589E+01,0.1536E+01,0.1484E+01,0.1434E+01,
     +0.1385E+01,0.1338E+01,0.1293E+01,0.1249E+01,0.1206E+01,0.1165E+01,
     +0.1125E+01,0.1086E+01,0.1048E+01,0.1012E+01,0.9762E+00,0.9420E+00,
     +0.9087E+00,0.8764E+00,0.8451E+00,0.8147E+00,0.7852E+00,0.7564E+00,
     +0.7285E+00,0.7013E+00,0.6748E+00,0.6489E+00,0.6237E+00,0.5991E+00,
     +0.5750E+00,0.5514E+00,0.5282E+00,0.5055E+00,0.4832E+00,0.4613E+00,
     +0.4398E+00,0.4185E+00,0.3975E+00,0.3769E+00,0.3565E+00,0.3363E+00,
     +0.3164E+00,0.2968E+00,0.2775E+00,0.2585E+00,0.2398E+00,0.2215E+00,
     +0.2036E+00,0.1862E+00,0.1693E+00,0.1530E+00,0.1374E+00,0.1225E+00,
     +0.1084E+00,0.9517E-01,0.8284E-01,0.7145E-01,0.6102E-01,0.5155E-01,
     +0.4302E-01,0.3540E-01,0.2866E-01,0.2274E-01,0.1761E-01,0.1323E-01,
     +0.9572E-02,0.6602E-02,0.4291E-02,0.2594E-02,0.1438E-02,0.7227E-03,
     +0.4554E-03,0.2863E-03,0.1807E-03,0.1152E-03,0.7418E-04,0.4801E-04,
     +0.3084E-04,0.1932E-04,0.1152E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,6),I=1,104) /
     +0.2920E+01,0.2821E+01,0.2725E+01,0.2631E+01,0.2541E+01,0.2453E+01,
     +0.2368E+01,0.2286E+01,0.2206E+01,0.2128E+01,0.2053E+01,0.1980E+01,
     +0.1909E+01,0.1840E+01,0.1774E+01,0.1710E+01,0.1647E+01,0.1587E+01,
     +0.1529E+01,0.1472E+01,0.1417E+01,0.1364E+01,0.1312E+01,0.1263E+01,
     +0.1215E+01,0.1168E+01,0.1123E+01,0.1079E+01,0.1037E+01,0.9960E+00,
     +0.9565E+00,0.9182E+00,0.8813E+00,0.8455E+00,0.8109E+00,0.7775E+00,
     +0.7451E+00,0.7138E+00,0.6836E+00,0.6543E+00,0.6260E+00,0.5986E+00,
     +0.5721E+00,0.5465E+00,0.5216E+00,0.4976E+00,0.4744E+00,0.4518E+00,
     +0.4300E+00,0.4088E+00,0.3883E+00,0.3684E+00,0.3491E+00,0.3303E+00,
     +0.3121E+00,0.2944E+00,0.2772E+00,0.2605E+00,0.2443E+00,0.2285E+00,
     +0.2132E+00,0.1983E+00,0.1839E+00,0.1699E+00,0.1564E+00,0.1434E+00,
     +0.1308E+00,0.1187E+00,0.1072E+00,0.9617E-01,0.8574E-01,0.7590E-01,
     +0.6668E-01,0.5810E-01,0.5017E-01,0.4291E-01,0.3631E-01,0.3038E-01,
     +0.2509E-01,0.2042E-01,0.1635E-01,0.1283E-01,0.9841E-02,0.7337E-02,
     +0.5286E-02,0.3652E-02,0.2400E-02,0.1487E-02,0.8624E-03,0.4674E-03,
     +0.3135E-03,0.2113E-03,0.1434E-03,0.9781E-04,0.6671E-04,0.4509E-04,
     +0.2982E-04,0.1901E-04,0.1144E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,7),I=1,104) /
     +0.2803E+01,0.2704E+01,0.2608E+01,0.2515E+01,0.2425E+01,0.2337E+01,
     +0.2252E+01,0.2170E+01,0.2090E+01,0.2012E+01,0.1937E+01,0.1864E+01,
     +0.1793E+01,0.1725E+01,0.1659E+01,0.1594E+01,0.1532E+01,0.1472E+01,
     +0.1414E+01,0.1357E+01,0.1302E+01,0.1249E+01,0.1198E+01,0.1149E+01,
     +0.1101E+01,0.1054E+01,0.1009E+01,0.9660E+00,0.9241E+00,0.8835E+00,
     +0.8444E+00,0.8065E+00,0.7700E+00,0.7347E+00,0.7006E+00,0.6677E+00,
     +0.6360E+00,0.6053E+00,0.5758E+00,0.5473E+00,0.5198E+00,0.4933E+00,
     +0.4678E+00,0.4432E+00,0.4195E+00,0.3967E+00,0.3748E+00,0.3536E+00,
     +0.3333E+00,0.3138E+00,0.2950E+00,0.2769E+00,0.2596E+00,0.2430E+00,
     +0.2270E+00,0.2117E+00,0.1970E+00,0.1830E+00,0.1695E+00,0.1567E+00,
     +0.1444E+00,0.1327E+00,0.1215E+00,0.1109E+00,0.1009E+00,0.9131E-01,
     +0.8229E-01,0.7379E-01,0.6580E-01,0.5832E-01,0.5134E-01,0.4486E-01,
     +0.3888E-01,0.3340E-01,0.2840E-01,0.2389E-01,0.1985E-01,0.1627E-01,
     +0.1314E-01,0.1044E-01,0.8143E-02,0.6228E-02,0.4661E-02,0.3407E-02,
     +0.2428E-02,0.1686E-02,0.1139E-02,0.7487E-03,0.4788E-03,0.2971E-03,
     +0.2189E-03,0.1614E-03,0.1185E-03,0.8624E-04,0.6174E-04,0.4314E-04,
     +0.2914E-04,0.1880E-04,0.1139E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,8),I=1,104) /
     +0.2674E+01,0.2578E+01,0.2485E+01,0.2395E+01,0.2308E+01,0.2223E+01,
     +0.2141E+01,0.2061E+01,0.1984E+01,0.1909E+01,0.1836E+01,0.1766E+01,
     +0.1698E+01,0.1632E+01,0.1568E+01,0.1506E+01,0.1447E+01,0.1389E+01,
     +0.1333E+01,0.1278E+01,0.1226E+01,0.1175E+01,0.1126E+01,0.1079E+01,
     +0.1033E+01,0.9884E+00,0.9455E+00,0.9041E+00,0.8641E+00,0.8255E+00,
     +0.7882E+00,0.7522E+00,0.7174E+00,0.6839E+00,0.6515E+00,0.6203E+00,
     +0.5902E+00,0.5612E+00,0.5333E+00,0.5063E+00,0.4804E+00,0.4554E+00,
     +0.4313E+00,0.4081E+00,0.3858E+00,0.3644E+00,0.3438E+00,0.3240E+00,
     +0.3049E+00,0.2866E+00,0.2691E+00,0.2522E+00,0.2361E+00,0.2206E+00,
     +0.2058E+00,0.1915E+00,0.1779E+00,0.1650E+00,0.1525E+00,0.1407E+00,
     +0.1294E+00,0.1187E+00,0.1085E+00,0.9878E-01,0.8961E-01,0.8094E-01,
     +0.7277E-01,0.6508E-01,0.5789E-01,0.5117E-01,0.4492E-01,0.3915E-01,
     +0.3383E-01,0.2898E-01,0.2457E-01,0.2060E-01,0.1707E-01,0.1395E-01,
     +0.1123E-01,0.8897E-02,0.6921E-02,0.5278E-02,0.3940E-02,0.2872E-02,
     +0.2042E-02,0.1414E-02,0.9533E-03,0.6251E-03,0.3983E-03,0.2458E-03,
     +0.1803E-03,0.1322E-03,0.9654E-04,0.6974E-04,0.4953E-04,0.3431E-04,
     +0.2296E-04,0.1466E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,9),I=1,104) /
     +0.1251E+01,0.1201E+01,0.1153E+01,0.1107E+01,0.1062E+01,0.1019E+01,
     +0.9775E+00,0.9373E+00,0.8984E+00,0.8608E+00,0.8245E+00,0.7896E+00,
     +0.7558E+00,0.7232E+00,0.6918E+00,0.6616E+00,0.6324E+00,0.6042E+00,
     +0.5771E+00,0.5510E+00,0.5259E+00,0.5016E+00,0.4783E+00,0.4559E+00,
     +0.4343E+00,0.4135E+00,0.3935E+00,0.3743E+00,0.3558E+00,0.3380E+00,
     +0.3210E+00,0.3046E+00,0.2889E+00,0.2738E+00,0.2593E+00,0.2454E+00,
     +0.2321E+00,0.2193E+00,0.2071E+00,0.1954E+00,0.1841E+00,0.1734E+00,
     +0.1631E+00,0.1533E+00,0.1439E+00,0.1350E+00,0.1264E+00,0.1182E+00,
     +0.1104E+00,0.1030E+00,0.9592E-01,0.8919E-01,0.8279E-01,0.7670E-01,
     +0.7093E-01,0.6544E-01,0.6025E-01,0.5534E-01,0.5069E-01,0.4630E-01,
     +0.4217E-01,0.3828E-01,0.3463E-01,0.3120E-01,0.2800E-01,0.2502E-01,
     +0.2224E-01,0.1967E-01,0.1729E-01,0.1510E-01,0.1310E-01,0.1128E-01,
     +0.9630E-02,0.8146E-02,0.6822E-02,0.5650E-02,0.4622E-02,0.3731E-02,
     +0.2968E-02,0.2323E-02,0.1786E-02,0.1347E-02,0.9940E-03,0.7170E-03,
     +0.5045E-03,0.3457E-03,0.2302E-03,0.1486E-03,0.9276E-04,0.5552E-04,
     +0.3973E-04,0.2832E-04,0.2002E-04,0.1395E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,1),I=1,104) /
     +0.1938E-01,0.2045E-01,0.2158E-01,0.2278E-01,0.2403E-01,0.2536E-01,
     +0.2675E-01,0.2822E-01,0.2977E-01,0.3141E-01,0.3313E-01,0.3494E-01,
     +0.3685E-01,0.3886E-01,0.4098E-01,0.4320E-01,0.4555E-01,0.4802E-01,
     +0.5062E-01,0.5335E-01,0.5622E-01,0.5925E-01,0.6243E-01,0.6577E-01,
     +0.6928E-01,0.7297E-01,0.7684E-01,0.8091E-01,0.8519E-01,0.8967E-01,
     +0.9437E-01,0.9931E-01,0.1045E+00,0.1099E+00,0.1156E+00,0.1215E+00,
     +0.1277E+00,0.1342E+00,0.1410E+00,0.1481E+00,0.1555E+00,0.1633E+00,
     +0.1713E+00,0.1797E+00,0.1884E+00,0.1975E+00,0.2069E+00,0.2167E+00,
     +0.2268E+00,0.2372E+00,0.2480E+00,0.2591E+00,0.2706E+00,0.2823E+00,
     +0.2943E+00,0.3066E+00,0.3190E+00,0.3317E+00,0.3445E+00,0.3573E+00,
     +0.3702E+00,0.3829E+00,0.3955E+00,0.4078E+00,0.4197E+00,0.4311E+00,
     +0.4418E+00,0.4516E+00,0.4603E+00,0.4678E+00,0.4737E+00,0.4779E+00,
     +0.4801E+00,0.4800E+00,0.4772E+00,0.4717E+00,0.4629E+00,0.4508E+00,
     +0.4352E+00,0.4158E+00,0.3927E+00,0.3659E+00,0.3358E+00,0.3026E+00,
     +0.2670E+00,0.2298E+00,0.1920E+00,0.1548E+00,0.1195E+00,0.8729E-01,
     +0.6990E-01,0.5515E-01,0.4277E-01,0.3252E-01,0.2416E-01,0.1744E-01,
     +0.1215E-01,0.8095E-02,0.5081E-02,0.2941E-02,0.1515E-02,0.6510E-03,
     +0.2044E-03,0.3234E-04/
      DATA (XQDUM (I,7,2),I=1,104) /
     +0.1102E-01,0.1162E-01,0.1226E-01,0.1294E-01,0.1365E-01,0.1440E-01,
     +0.1519E-01,0.1602E-01,0.1690E-01,0.1782E-01,0.1880E-01,0.1982E-01,
     +0.2090E-01,0.2203E-01,0.2323E-01,0.2448E-01,0.2581E-01,0.2720E-01,
     +0.2866E-01,0.3020E-01,0.3181E-01,0.3351E-01,0.3530E-01,0.3717E-01,
     +0.3914E-01,0.4121E-01,0.4338E-01,0.4566E-01,0.4804E-01,0.5055E-01,
     +0.5317E-01,0.5591E-01,0.5879E-01,0.6180E-01,0.6495E-01,0.6824E-01,
     +0.7167E-01,0.7526E-01,0.7900E-01,0.8290E-01,0.8696E-01,0.9119E-01,
     +0.9558E-01,0.1001E+00,0.1049E+00,0.1098E+00,0.1148E+00,0.1201E+00,
     +0.1254E+00,0.1310E+00,0.1367E+00,0.1425E+00,0.1485E+00,0.1545E+00,
     +0.1607E+00,0.1669E+00,0.1732E+00,0.1794E+00,0.1857E+00,0.1919E+00,
     +0.1979E+00,0.2038E+00,0.2095E+00,0.2149E+00,0.2199E+00,0.2244E+00,
     +0.2283E+00,0.2316E+00,0.2342E+00,0.2358E+00,0.2364E+00,0.2359E+00,
     +0.2341E+00,0.2310E+00,0.2263E+00,0.2200E+00,0.2121E+00,0.2024E+00,
     +0.1911E+00,0.1780E+00,0.1635E+00,0.1476E+00,0.1306E+00,0.1130E+00,
     +0.9518E-01,0.7764E-01,0.6096E-01,0.4570E-01,0.3236E-01,0.2131E-01,
     +0.1587E-01,0.1158E-01,0.8264E-02,0.5744E-02,0.3869E-02,0.2510E-02,
     +0.1554E-02,0.9068E-03,0.4894E-03,0.2375E-03,0.9901E-04,0.3262E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,3),I=1,104) /
     +0.1200E+03,0.1152E+03,0.1106E+03,0.1061E+03,0.1018E+03,0.9758E+02,
     +0.9355E+02,0.8965E+02,0.8589E+02,0.8227E+02,0.7877E+02,0.7540E+02,
     +0.7216E+02,0.6902E+02,0.6601E+02,0.6310E+02,0.6030E+02,0.5761E+02,
     +0.5501E+02,0.5251E+02,0.5011E+02,0.4780E+02,0.4557E+02,0.4343E+02,
     +0.4138E+02,0.3940E+02,0.3750E+02,0.3568E+02,0.3393E+02,0.3225E+02,
     +0.3063E+02,0.2908E+02,0.2760E+02,0.2617E+02,0.2481E+02,0.2350E+02,
     +0.2224E+02,0.2104E+02,0.1989E+02,0.1879E+02,0.1774E+02,0.1673E+02,
     +0.1577E+02,0.1485E+02,0.1397E+02,0.1313E+02,0.1232E+02,0.1156E+02,
     +0.1083E+02,0.1013E+02,0.9467E+01,0.8835E+01,0.8232E+01,0.7659E+01,
     +0.7113E+01,0.6595E+01,0.6102E+01,0.5634E+01,0.5191E+01,0.4770E+01,
     +0.4372E+01,0.3996E+01,0.3641E+01,0.3306E+01,0.2990E+01,0.2694E+01,
     +0.2417E+01,0.2158E+01,0.1916E+01,0.1692E+01,0.1484E+01,0.1293E+01,
     +0.1118E+01,0.9587E+00,0.8144E+00,0.6848E+00,0.5693E+00,0.4673E+00,
     +0.3781E+00,0.3011E+00,0.2354E+00,0.1802E+00,0.1346E+00,0.9768E-01,
     +0.6844E-01,0.4591E-01,0.2910E-01,0.1704E-01,0.8809E-02,0.3560E-02,
     +0.1515E-02,0.1928E-03,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,4),I=1,104) /
     +0.2115E+02,0.2037E+02,0.1962E+02,0.1890E+02,0.1819E+02,0.1751E+02,
     +0.1686E+02,0.1622E+02,0.1560E+02,0.1501E+02,0.1444E+02,0.1388E+02,
     +0.1334E+02,0.1282E+02,0.1232E+02,0.1184E+02,0.1137E+02,0.1092E+02,
     +0.1048E+02,0.1006E+02,0.9656E+01,0.9264E+01,0.8885E+01,0.8520E+01,
     +0.8168E+01,0.7828E+01,0.7500E+01,0.7184E+01,0.6879E+01,0.6585E+01,
     +0.6302E+01,0.6029E+01,0.5765E+01,0.5512E+01,0.5267E+01,0.5032E+01,
     +0.4805E+01,0.4586E+01,0.4376E+01,0.4173E+01,0.3977E+01,0.3789E+01,
     +0.3607E+01,0.3432E+01,0.3264E+01,0.3101E+01,0.2945E+01,0.2794E+01,
     +0.2648E+01,0.2507E+01,0.2372E+01,0.2241E+01,0.2114E+01,0.1992E+01,
     +0.1874E+01,0.1761E+01,0.1651E+01,0.1544E+01,0.1442E+01,0.1343E+01,
     +0.1247E+01,0.1155E+01,0.1066E+01,0.9799E+00,0.8976E+00,0.8188E+00,
     +0.7433E+00,0.6713E+00,0.6030E+00,0.5383E+00,0.4775E+00,0.4205E+00,
     +0.3674E+00,0.3185E+00,0.2735E+00,0.2327E+00,0.1958E+00,0.1629E+00,
     +0.1338E+00,0.1082E+00,0.8610E-01,0.6714E-01,0.5111E-01,0.3780E-01,
     +0.2699E-01,0.1846E-01,0.1199E-01,0.7336E-02,0.4192E-02,0.2233E-02,
     +0.1480E-02,0.9844E-03,0.6586E-03,0.4423E-03,0.2966E-03,0.1968E-03,
     +0.1277E-03,0.7963E-04,0.4684E-04,0.2529E-04,0.1204E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,5),I=1,104) /
     +0.3972E+01,0.3834E+01,0.3701E+01,0.3572E+01,0.3447E+01,0.3325E+01,
     +0.3208E+01,0.3095E+01,0.2985E+01,0.2879E+01,0.2776E+01,0.2677E+01,
     +0.2581E+01,0.2488E+01,0.2398E+01,0.2311E+01,0.2228E+01,0.2146E+01,
     +0.2068E+01,0.1992E+01,0.1919E+01,0.1848E+01,0.1780E+01,0.1714E+01,
     +0.1650E+01,0.1589E+01,0.1529E+01,0.1472E+01,0.1416E+01,0.1363E+01,
     +0.1311E+01,0.1261E+01,0.1213E+01,0.1166E+01,0.1121E+01,0.1078E+01,
     +0.1036E+01,0.9949E+00,0.9555E+00,0.9175E+00,0.8807E+00,0.8450E+00,
     +0.8105E+00,0.7770E+00,0.7445E+00,0.7130E+00,0.6824E+00,0.6527E+00,
     +0.6238E+00,0.5956E+00,0.5682E+00,0.5414E+00,0.5153E+00,0.4898E+00,
     +0.4648E+00,0.4404E+00,0.4165E+00,0.3930E+00,0.3701E+00,0.3476E+00,
     +0.3255E+00,0.3040E+00,0.2829E+00,0.2623E+00,0.2422E+00,0.2226E+00,
     +0.2037E+00,0.1854E+00,0.1677E+00,0.1509E+00,0.1348E+00,0.1196E+00,
     +0.1053E+00,0.9201E-01,0.7968E-01,0.6835E-01,0.5805E-01,0.4875E-01,
     +0.4043E-01,0.3304E-01,0.2656E-01,0.2091E-01,0.1606E-01,0.1195E-01,
     +0.8561E-02,0.5844E-02,0.3760E-02,0.2251E-02,0.1237E-02,0.6192E-03,
     +0.3901E-03,0.2456E-03,0.1555E-03,0.9931E-04,0.6395E-04,0.4122E-04,
     +0.2626E-04,0.1624E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,6),I=1,104) /
     +0.3798E+01,0.3660E+01,0.3527E+01,0.3398E+01,0.3273E+01,0.3152E+01,
     +0.3035E+01,0.2921E+01,0.2812E+01,0.2706E+01,0.2603E+01,0.2504E+01,
     +0.2408E+01,0.2315E+01,0.2226E+01,0.2139E+01,0.2055E+01,0.1974E+01,
     +0.1896E+01,0.1821E+01,0.1748E+01,0.1677E+01,0.1609E+01,0.1544E+01,
     +0.1480E+01,0.1419E+01,0.1360E+01,0.1303E+01,0.1248E+01,0.1195E+01,
     +0.1144E+01,0.1095E+01,0.1047E+01,0.1001E+01,0.9571E+00,0.9145E+00,
     +0.8734E+00,0.8338E+00,0.7956E+00,0.7588E+00,0.7233E+00,0.6891E+00,
     +0.6561E+00,0.6243E+00,0.5937E+00,0.5641E+00,0.5356E+00,0.5081E+00,
     +0.4816E+00,0.4560E+00,0.4313E+00,0.4074E+00,0.3844E+00,0.3621E+00,
     +0.3407E+00,0.3199E+00,0.2999E+00,0.2805E+00,0.2618E+00,0.2437E+00,
     +0.2263E+00,0.2095E+00,0.1933E+00,0.1778E+00,0.1628E+00,0.1485E+00,
     +0.1347E+00,0.1217E+00,0.1093E+00,0.9752E-01,0.8647E-01,0.7612E-01,
     +0.6650E-01,0.5761E-01,0.4946E-01,0.4204E-01,0.3536E-01,0.2939E-01,
     +0.2410E-01,0.1948E-01,0.1548E-01,0.1205E-01,0.9164E-02,0.6772E-02,
     +0.4835E-02,0.3311E-02,0.2157E-02,0.1327E-02,0.7658E-03,0.4140E-03,
     +0.2776E-03,0.1871E-03,0.1268E-03,0.8615E-04,0.5838E-04,0.3908E-04,
     +0.2553E-04,0.1602E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,7),I=1,104) /
     +0.3682E+01,0.3544E+01,0.3411E+01,0.3282E+01,0.3157E+01,0.3036E+01,
     +0.2919E+01,0.2805E+01,0.2696E+01,0.2590E+01,0.2487E+01,0.2388E+01,
     +0.2292E+01,0.2200E+01,0.2110E+01,0.2024E+01,0.1940E+01,0.1859E+01,
     +0.1781E+01,0.1706E+01,0.1633E+01,0.1563E+01,0.1495E+01,0.1430E+01,
     +0.1367E+01,0.1306E+01,0.1247E+01,0.1191E+01,0.1136E+01,0.1083E+01,
     +0.1033E+01,0.9837E+00,0.9366E+00,0.8913E+00,0.8476E+00,0.8056E+00,
     +0.7652E+00,0.7263E+00,0.6889E+00,0.6529E+00,0.6183E+00,0.5851E+00,
     +0.5531E+00,0.5225E+00,0.4930E+00,0.4648E+00,0.4377E+00,0.4117E+00,
     +0.3867E+00,0.3629E+00,0.3400E+00,0.3181E+00,0.2971E+00,0.2771E+00,
     +0.2579E+00,0.2396E+00,0.2222E+00,0.2055E+00,0.1896E+00,0.1745E+00,
     +0.1602E+00,0.1466E+00,0.1337E+00,0.1214E+00,0.1099E+00,0.9903E-01,
     +0.8881E-01,0.7924E-01,0.7029E-01,0.6197E-01,0.5426E-01,0.4715E-01,
     +0.4063E-01,0.3469E-01,0.2933E-01,0.2451E-01,0.2024E-01,0.1649E-01,
     +0.1323E-01,0.1044E-01,0.8093E-02,0.6149E-02,0.4572E-02,0.3320E-02,
     +0.2352E-02,0.1623E-02,0.1089E-02,0.7114E-03,0.4514E-03,0.2772E-03,
     +0.2026E-03,0.1480E-03,0.1076E-03,0.7738E-04,0.5467E-04,0.3766E-04,
     +0.2504E-04,0.1588E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,8),I=1,104) /
     +0.3555E+01,0.3421E+01,0.3290E+01,0.3164E+01,0.3042E+01,0.2924E+01,
     +0.2809E+01,0.2699E+01,0.2592E+01,0.2489E+01,0.2389E+01,0.2292E+01,
     +0.2199E+01,0.2109E+01,0.2022E+01,0.1938E+01,0.1856E+01,0.1778E+01,
     +0.1702E+01,0.1629E+01,0.1559E+01,0.1491E+01,0.1425E+01,0.1362E+01,
     +0.1300E+01,0.1242E+01,0.1185E+01,0.1130E+01,0.1077E+01,0.1027E+01,
     +0.9778E+00,0.9307E+00,0.8854E+00,0.8418E+00,0.7999E+00,0.7595E+00,
     +0.7207E+00,0.6834E+00,0.6475E+00,0.6131E+00,0.5800E+00,0.5482E+00,
     +0.5177E+00,0.4885E+00,0.4604E+00,0.4335E+00,0.4077E+00,0.3830E+00,
     +0.3593E+00,0.3367E+00,0.3150E+00,0.2943E+00,0.2745E+00,0.2556E+00,
     +0.2375E+00,0.2203E+00,0.2039E+00,0.1883E+00,0.1734E+00,0.1593E+00,
     +0.1459E+00,0.1332E+00,0.1213E+00,0.1099E+00,0.9926E-01,0.8924E-01,
     +0.7984E-01,0.7106E-01,0.6288E-01,0.5529E-01,0.4828E-01,0.4184E-01,
     +0.3596E-01,0.3062E-01,0.2581E-01,0.2151E-01,0.1771E-01,0.1438E-01,
     +0.1151E-01,0.9057E-02,0.7000E-02,0.5304E-02,0.3933E-02,0.2849E-02,
     +0.2013E-02,0.1385E-02,0.9278E-03,0.6041E-03,0.3818E-03,0.2331E-03,
     +0.1695E-03,0.1231E-03,0.8892E-04,0.6346E-04,0.4446E-04,0.3035E-04,
     +0.1998E-04,0.1253E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,9),I=1,104) /
     +0.2167E+01,0.2078E+01,0.1991E+01,0.1908E+01,0.1828E+01,0.1751E+01,
     +0.1676E+01,0.1604E+01,0.1535E+01,0.1468E+01,0.1404E+01,0.1342E+01,
     +0.1282E+01,0.1224E+01,0.1169E+01,0.1116E+01,0.1065E+01,0.1015E+01,
     +0.9678E+00,0.9222E+00,0.8784E+00,0.8363E+00,0.7958E+00,0.7569E+00,
     +0.7195E+00,0.6837E+00,0.6493E+00,0.6163E+00,0.5846E+00,0.5542E+00,
     +0.5251E+00,0.4972E+00,0.4705E+00,0.4449E+00,0.4204E+00,0.3969E+00,
     +0.3745E+00,0.3530E+00,0.3325E+00,0.3129E+00,0.2942E+00,0.2763E+00,
     +0.2593E+00,0.2430E+00,0.2275E+00,0.2128E+00,0.1987E+00,0.1854E+00,
     +0.1726E+00,0.1605E+00,0.1491E+00,0.1382E+00,0.1279E+00,0.1181E+00,
     +0.1088E+00,0.1001E+00,0.9181E-01,0.8402E-01,0.7669E-01,0.6979E-01,
     +0.6332E-01,0.5725E-01,0.5158E-01,0.4629E-01,0.4136E-01,0.3679E-01,
     +0.3256E-01,0.2866E-01,0.2507E-01,0.2179E-01,0.1881E-01,0.1611E-01,
     +0.1368E-01,0.1151E-01,0.9585E-02,0.7893E-02,0.6420E-02,0.5152E-02,
     +0.4073E-02,0.3168E-02,0.2421E-02,0.1814E-02,0.1331E-02,0.9537E-03,
     +0.6667E-03,0.4537E-03,0.2998E-03,0.1920E-03,0.1185E-03,0.6994E-04,
     +0.4951E-04,0.3487E-04,0.2432E-04,0.1670E-04,0.1122E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,1),I=1,104) /
     +0.2063E-01,0.2177E-01,0.2296E-01,0.2422E-01,0.2555E-01,0.2695E-01,
     +0.2843E-01,0.2998E-01,0.3162E-01,0.3334E-01,0.3516E-01,0.3707E-01,
     +0.3908E-01,0.4119E-01,0.4342E-01,0.4576E-01,0.4823E-01,0.5082E-01,
     +0.5355E-01,0.5641E-01,0.5942E-01,0.6259E-01,0.6591E-01,0.6941E-01,
     +0.7307E-01,0.7692E-01,0.8096E-01,0.8520E-01,0.8965E-01,0.9431E-01,
     +0.9919E-01,0.1043E+00,0.1097E+00,0.1153E+00,0.1211E+00,0.1273E+00,
     +0.1337E+00,0.1404E+00,0.1473E+00,0.1546E+00,0.1622E+00,0.1701E+00,
     +0.1783E+00,0.1869E+00,0.1958E+00,0.2050E+00,0.2145E+00,0.2243E+00,
     +0.2345E+00,0.2450E+00,0.2558E+00,0.2669E+00,0.2783E+00,0.2900E+00,
     +0.3019E+00,0.3139E+00,0.3262E+00,0.3385E+00,0.3509E+00,0.3633E+00,
     +0.3757E+00,0.3878E+00,0.3997E+00,0.4113E+00,0.4223E+00,0.4327E+00,
     +0.4423E+00,0.4509E+00,0.4583E+00,0.4643E+00,0.4688E+00,0.4714E+00,
     +0.4719E+00,0.4700E+00,0.4656E+00,0.4582E+00,0.4478E+00,0.4341E+00,
     +0.4170E+00,0.3964E+00,0.3723E+00,0.3449E+00,0.3145E+00,0.2815E+00,
     +0.2466E+00,0.2106E+00,0.1745E+00,0.1394E+00,0.1064E+00,0.7683E-01,
     +0.6103E-01,0.4773E-01,0.3669E-01,0.2763E-01,0.2031E-01,0.1449E-01,
     +0.9971E-02,0.6546E-02,0.4039E-02,0.2291E-02,0.1150E-02,0.4776E-03,
     +0.1424E-03,0.2028E-04/
      DATA (XQDUM (I,8,2),I=1,104) /
     +0.1172E-01,0.1236E-01,0.1304E-01,0.1375E-01,0.1450E-01,0.1529E-01,
     +0.1613E-01,0.1701E-01,0.1793E-01,0.1890E-01,0.1993E-01,0.2100E-01,
     +0.2214E-01,0.2333E-01,0.2458E-01,0.2590E-01,0.2729E-01,0.2875E-01,
     +0.3028E-01,0.3189E-01,0.3358E-01,0.3535E-01,0.3722E-01,0.3917E-01,
     +0.4122E-01,0.4337E-01,0.4563E-01,0.4799E-01,0.5047E-01,0.5306E-01,
     +0.5578E-01,0.5862E-01,0.6158E-01,0.6469E-01,0.6793E-01,0.7131E-01,
     +0.7483E-01,0.7851E-01,0.8234E-01,0.8632E-01,0.9046E-01,0.9476E-01,
     +0.9922E-01,0.1038E+00,0.1086E+00,0.1136E+00,0.1186E+00,0.1239E+00,
     +0.1293E+00,0.1348E+00,0.1405E+00,0.1462E+00,0.1521E+00,0.1581E+00,
     +0.1641E+00,0.1702E+00,0.1762E+00,0.1823E+00,0.1883E+00,0.1941E+00,
     +0.1998E+00,0.2053E+00,0.2106E+00,0.2154E+00,0.2199E+00,0.2238E+00,
     +0.2271E+00,0.2297E+00,0.2315E+00,0.2324E+00,0.2322E+00,0.2309E+00,
     +0.2283E+00,0.2243E+00,0.2189E+00,0.2119E+00,0.2033E+00,0.1930E+00,
     +0.1812E+00,0.1679E+00,0.1533E+00,0.1375E+00,0.1209E+00,0.1038E+00,
     +0.8677E-01,0.7018E-01,0.5460E-01,0.4052E-01,0.2836E-01,0.1844E-01,
     +0.1361E-01,0.9843E-02,0.6956E-02,0.4785E-02,0.3188E-02,0.2043E-02,
     +0.1248E-02,0.7167E-03,0.3798E-03,0.1804E-03,0.7313E-04,0.2320E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,3),I=1,104) /
     +0.1446E+03,0.1384E+03,0.1325E+03,0.1268E+03,0.1213E+03,0.1160E+03,
     +0.1109E+03,0.1060E+03,0.1012E+03,0.9668E+02,0.9232E+02,0.8811E+02,
     +0.8407E+02,0.8019E+02,0.7646E+02,0.7288E+02,0.6944E+02,0.6614E+02,
     +0.6296E+02,0.5992E+02,0.5700E+02,0.5420E+02,0.5151E+02,0.4894E+02,
     +0.4647E+02,0.4411E+02,0.4184E+02,0.3968E+02,0.3760E+02,0.3561E+02,
     +0.3372E+02,0.3190E+02,0.3016E+02,0.2850E+02,0.2692E+02,0.2540E+02,
     +0.2396E+02,0.2258E+02,0.2126E+02,0.2001E+02,0.1881E+02,0.1767E+02,
     +0.1659E+02,0.1555E+02,0.1457E+02,0.1364E+02,0.1275E+02,0.1190E+02,
     +0.1110E+02,0.1034E+02,0.9616E+01,0.8931E+01,0.8282E+01,0.7668E+01,
     +0.7087E+01,0.6537E+01,0.6018E+01,0.5527E+01,0.5065E+01,0.4630E+01,
     +0.4221E+01,0.3836E+01,0.3475E+01,0.3137E+01,0.2822E+01,0.2527E+01,
     +0.2254E+01,0.2000E+01,0.1765E+01,0.1549E+01,0.1350E+01,0.1169E+01,
     +0.1005E+01,0.8561E+00,0.7227E+00,0.6039E+00,0.4989E+00,0.4070E+00,
     +0.3273E+00,0.2591E+00,0.2013E+00,0.1531E+00,0.1137E+00,0.8192E-01,
     +0.5697E-01,0.3787E-01,0.2372E-01,0.1365E-01,0.6847E-02,0.2563E-02,
     +0.9236E-03,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,4),I=1,104) /
     +0.2662E+02,0.2559E+02,0.2460E+02,0.2363E+02,0.2271E+02,0.2181E+02,
     +0.2094E+02,0.2011E+02,0.1930E+02,0.1852E+02,0.1777E+02,0.1705E+02,
     +0.1635E+02,0.1568E+02,0.1503E+02,0.1440E+02,0.1380E+02,0.1322E+02,
     +0.1266E+02,0.1212E+02,0.1160E+02,0.1110E+02,0.1062E+02,0.1016E+02,
     +0.9711E+01,0.9281E+01,0.8868E+01,0.8471E+01,0.8089E+01,0.7721E+01,
     +0.7368E+01,0.7028E+01,0.6701E+01,0.6387E+01,0.6086E+01,0.5796E+01,
     +0.5517E+01,0.5250E+01,0.4993E+01,0.4746E+01,0.4508E+01,0.4281E+01,
     +0.4062E+01,0.3852E+01,0.3650E+01,0.3456E+01,0.3270E+01,0.3091E+01,
     +0.2919E+01,0.2753E+01,0.2595E+01,0.2442E+01,0.2295E+01,0.2154E+01,
     +0.2019E+01,0.1889E+01,0.1763E+01,0.1643E+01,0.1527E+01,0.1416E+01,
     +0.1310E+01,0.1208E+01,0.1110E+01,0.1016E+01,0.9264E+00,0.8411E+00,
     +0.7601E+00,0.6834E+00,0.6109E+00,0.5428E+00,0.4791E+00,0.4199E+00,
     +0.3651E+00,0.3148E+00,0.2690E+00,0.2276E+00,0.1905E+00,0.1576E+00,
     +0.1286E+00,0.1034E+00,0.8169E-01,0.6325E-01,0.4779E-01,0.3507E-01,
     +0.2484E-01,0.1686E-01,0.1087E-01,0.6603E-02,0.3755E-02,0.1994E-02,
     +0.1320E-02,0.8774E-03,0.5858E-03,0.3919E-03,0.2612E-03,0.1718E-03,
     +0.1102E-03,0.6778E-04,0.3923E-04,0.2079E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,5),I=1,104) /
     +0.4879E+01,0.4699E+01,0.4524E+01,0.4356E+01,0.4193E+01,0.4036E+01,
     +0.3884E+01,0.3738E+01,0.3596E+01,0.3460E+01,0.3328E+01,0.3201E+01,
     +0.3078E+01,0.2959E+01,0.2845E+01,0.2735E+01,0.2628E+01,0.2526E+01,
     +0.2427E+01,0.2331E+01,0.2239E+01,0.2151E+01,0.2065E+01,0.1983E+01,
     +0.1904E+01,0.1827E+01,0.1754E+01,0.1683E+01,0.1615E+01,0.1549E+01,
     +0.1485E+01,0.1424E+01,0.1365E+01,0.1309E+01,0.1254E+01,0.1202E+01,
     +0.1151E+01,0.1102E+01,0.1055E+01,0.1009E+01,0.9657E+00,0.9234E+00,
     +0.8826E+00,0.8432E+00,0.8051E+00,0.7684E+00,0.7328E+00,0.6983E+00,
     +0.6650E+00,0.6326E+00,0.6013E+00,0.5708E+00,0.5413E+00,0.5125E+00,
     +0.4846E+00,0.4574E+00,0.4309E+00,0.4051E+00,0.3799E+00,0.3555E+00,
     +0.3316E+00,0.3084E+00,0.2859E+00,0.2640E+00,0.2428E+00,0.2223E+00,
     +0.2025E+00,0.1836E+00,0.1654E+00,0.1482E+00,0.1318E+00,0.1165E+00,
     +0.1021E+00,0.8882E-01,0.7656E-01,0.6538E-01,0.5525E-01,0.4616E-01,
     +0.3807E-01,0.3094E-01,0.2470E-01,0.1932E-01,0.1472E-01,0.1087E-01,
     +0.7723E-02,0.5225E-02,0.3332E-02,0.1977E-02,0.1079E-02,0.5377E-03,
     +0.3384E-03,0.2131E-03,0.1350E-03,0.8622E-04,0.5540E-04,0.3553E-04,
     +0.2244E-04,0.1372E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,6),I=1,104) /
     +0.4705E+01,0.4525E+01,0.4351E+01,0.4182E+01,0.4020E+01,0.3863E+01,
     +0.3711E+01,0.3564E+01,0.3423E+01,0.3287E+01,0.3155E+01,0.3028E+01,
     +0.2905E+01,0.2787E+01,0.2673E+01,0.2562E+01,0.2456E+01,0.2354E+01,
     +0.2255E+01,0.2160E+01,0.2069E+01,0.1980E+01,0.1895E+01,0.1813E+01,
     +0.1734E+01,0.1658E+01,0.1585E+01,0.1515E+01,0.1447E+01,0.1382E+01,
     +0.1319E+01,0.1259E+01,0.1201E+01,0.1145E+01,0.1091E+01,0.1040E+01,
     +0.9900E+00,0.9423E+00,0.8964E+00,0.8524E+00,0.8100E+00,0.7693E+00,
     +0.7301E+00,0.6925E+00,0.6564E+00,0.6216E+00,0.5883E+00,0.5562E+00,
     +0.5253E+00,0.4956E+00,0.4671E+00,0.4397E+00,0.4134E+00,0.3880E+00,
     +0.3636E+00,0.3402E+00,0.3176E+00,0.2960E+00,0.2751E+00,0.2551E+00,
     +0.2359E+00,0.2175E+00,0.1999E+00,0.1830E+00,0.1669E+00,0.1515E+00,
     +0.1369E+00,0.1231E+00,0.1100E+00,0.9777E-01,0.8629E-01,0.7561E-01,
     +0.6574E-01,0.5667E-01,0.4841E-01,0.4094E-01,0.3424E-01,0.2830E-01,
     +0.2308E-01,0.1854E-01,0.1463E-01,0.1132E-01,0.8543E-02,0.6266E-02,
     +0.4439E-02,0.3016E-02,0.1951E-02,0.1192E-02,0.6847E-03,0.3689E-03,
     +0.2470E-03,0.1661E-03,0.1122E-03,0.7594E-04,0.5112E-04,0.3391E-04,
     +0.2190E-04,0.1356E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,7),I=1,104) /
     +0.4589E+01,0.4409E+01,0.4235E+01,0.4066E+01,0.3904E+01,0.3747E+01,
     +0.3595E+01,0.3449E+01,0.3307E+01,0.3171E+01,0.3039E+01,0.2912E+01,
     +0.2790E+01,0.2672E+01,0.2558E+01,0.2448E+01,0.2342E+01,0.2239E+01,
     +0.2141E+01,0.2046E+01,0.1955E+01,0.1866E+01,0.1782E+01,0.1700E+01,
     +0.1621E+01,0.1546E+01,0.1473E+01,0.1403E+01,0.1335E+01,0.1271E+01,
     +0.1208E+01,0.1148E+01,0.1091E+01,0.1036E+01,0.9826E+00,0.9316E+00,
     +0.8827E+00,0.8358E+00,0.7907E+00,0.7475E+00,0.7061E+00,0.6665E+00,
     +0.6284E+00,0.5920E+00,0.5572E+00,0.5238E+00,0.4919E+00,0.4613E+00,
     +0.4322E+00,0.4043E+00,0.3777E+00,0.3523E+00,0.3281E+00,0.3050E+00,
     +0.2830E+00,0.2621E+00,0.2422E+00,0.2232E+00,0.2053E+00,0.1883E+00,
     +0.1722E+00,0.1570E+00,0.1426E+00,0.1290E+00,0.1163E+00,0.1044E+00,
     +0.9322E-01,0.8281E-01,0.7314E-01,0.6419E-01,0.5594E-01,0.4838E-01,
     +0.4149E-01,0.3525E-01,0.2965E-01,0.2465E-01,0.2025E-01,0.1640E-01,
     +0.1309E-01,0.1028E-01,0.7920E-02,0.5984E-02,0.4424E-02,0.3195E-02,
     +0.2251E-02,0.1544E-02,0.1031E-02,0.6691E-03,0.4215E-03,0.2564E-03,
     +0.1860E-03,0.1348E-03,0.9709E-04,0.6909E-04,0.4827E-04,0.3283E-04,
     +0.2154E-04,0.1345E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,8),I=1,104) /
     +0.4464E+01,0.4287E+01,0.4116E+01,0.3951E+01,0.3791E+01,0.3637E+01,
     +0.3488E+01,0.3344E+01,0.3205E+01,0.3072E+01,0.2943E+01,0.2818E+01,
     +0.2698E+01,0.2582E+01,0.2471E+01,0.2363E+01,0.2259E+01,0.2159E+01,
     +0.2063E+01,0.1971E+01,0.1881E+01,0.1795E+01,0.1713E+01,0.1633E+01,
     +0.1556E+01,0.1483E+01,0.1412E+01,0.1344E+01,0.1278E+01,0.1215E+01,
     +0.1155E+01,0.1097E+01,0.1041E+01,0.9874E+00,0.9360E+00,0.8866E+00,
     +0.8393E+00,0.7939E+00,0.7505E+00,0.7088E+00,0.6688E+00,0.6306E+00,
     +0.5940E+00,0.5590E+00,0.5255E+00,0.4934E+00,0.4628E+00,0.4335E+00,
     +0.4056E+00,0.3789E+00,0.3535E+00,0.3293E+00,0.3062E+00,0.2842E+00,
     +0.2633E+00,0.2434E+00,0.2246E+00,0.2067E+00,0.1897E+00,0.1737E+00,
     +0.1585E+00,0.1442E+00,0.1307E+00,0.1181E+00,0.1062E+00,0.9509E-01,
     +0.8473E-01,0.7509E-01,0.6615E-01,0.5791E-01,0.5034E-01,0.4342E-01,
     +0.3714E-01,0.3147E-01,0.2639E-01,0.2188E-01,0.1792E-01,0.1448E-01,
     +0.1152E-01,0.9018E-02,0.6931E-02,0.5223E-02,0.3851E-02,0.2774E-02,
     +0.1949E-02,0.1334E-02,0.8883E-03,0.5746E-03,0.3603E-03,0.2178E-03,
     +0.1572E-03,0.1132E-03,0.8094E-04,0.5715E-04,0.3958E-04,0.2667E-04,
     +0.1731E-04,0.1069E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,9),I=1,104) /
     +0.3107E+01,0.2974E+01,0.2846E+01,0.2723E+01,0.2605E+01,0.2490E+01,
     +0.2380E+01,0.2275E+01,0.2173E+01,0.2075E+01,0.1981E+01,0.1890E+01,
     +0.1803E+01,0.1719E+01,0.1639E+01,0.1561E+01,0.1487E+01,0.1416E+01,
     +0.1347E+01,0.1281E+01,0.1218E+01,0.1158E+01,0.1100E+01,0.1044E+01,
     +0.9908E+00,0.9397E+00,0.8907E+00,0.8438E+00,0.7989E+00,0.7559E+00,
     +0.7148E+00,0.6755E+00,0.6379E+00,0.6019E+00,0.5676E+00,0.5348E+00,
     +0.5035E+00,0.4736E+00,0.4452E+00,0.4180E+00,0.3921E+00,0.3675E+00,
     +0.3440E+00,0.3217E+00,0.3005E+00,0.2803E+00,0.2611E+00,0.2429E+00,
     +0.2257E+00,0.2093E+00,0.1938E+00,0.1792E+00,0.1653E+00,0.1523E+00,
     +0.1399E+00,0.1283E+00,0.1173E+00,0.1071E+00,0.9741E-01,0.8836E-01,
     +0.7989E-01,0.7199E-01,0.6463E-01,0.5779E-01,0.5145E-01,0.4559E-01,
     +0.4019E-01,0.3523E-01,0.3070E-01,0.2657E-01,0.2284E-01,0.1947E-01,
     +0.1646E-01,0.1378E-01,0.1142E-01,0.9362E-02,0.7578E-02,0.6050E-02,
     +0.4759E-02,0.3682E-02,0.2799E-02,0.2086E-02,0.1522E-02,0.1085E-02,
     +0.7540E-03,0.5099E-03,0.3347E-03,0.2126E-03,0.1299E-03,0.7569E-04,
     +0.5306E-04,0.3697E-04,0.2548E-04,0.1727E-04,0.1144E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,1),I=1,104) /
     +0.2181E-01,0.2301E-01,0.2427E-01,0.2559E-01,0.2699E-01,0.2846E-01,
     +0.3001E-01,0.3164E-01,0.3336E-01,0.3517E-01,0.3707E-01,0.3907E-01,
     +0.4117E-01,0.4339E-01,0.4572E-01,0.4816E-01,0.5074E-01,0.5344E-01,
     +0.5629E-01,0.5927E-01,0.6241E-01,0.6571E-01,0.6917E-01,0.7280E-01,
     +0.7660E-01,0.8060E-01,0.8479E-01,0.8918E-01,0.9378E-01,0.9859E-01,
     +0.1036E+00,0.1089E+00,0.1144E+00,0.1202E+00,0.1262E+00,0.1325E+00,
     +0.1391E+00,0.1460E+00,0.1531E+00,0.1605E+00,0.1683E+00,0.1763E+00,
     +0.1847E+00,0.1933E+00,0.2023E+00,0.2116E+00,0.2212E+00,0.2312E+00,
     +0.2414E+00,0.2519E+00,0.2627E+00,0.2738E+00,0.2851E+00,0.2966E+00,
     +0.3083E+00,0.3202E+00,0.3322E+00,0.3442E+00,0.3563E+00,0.3683E+00,
     +0.3801E+00,0.3917E+00,0.4029E+00,0.4137E+00,0.4239E+00,0.4333E+00,
     +0.4419E+00,0.4494E+00,0.4556E+00,0.4604E+00,0.4635E+00,0.4647E+00,
     +0.4638E+00,0.4604E+00,0.4545E+00,0.4457E+00,0.4338E+00,0.4188E+00,
     +0.4006E+00,0.3790E+00,0.3542E+00,0.3265E+00,0.2960E+00,0.2634E+00,
     +0.2292E+00,0.1944E+00,0.1598E+00,0.1266E+00,0.9574E-01,0.6837E-01,
     +0.5391E-01,0.4185E-01,0.3190E-01,0.2382E-01,0.1734E-01,0.1225E-01,
     +0.8330E-02,0.5397E-02,0.3280E-02,0.1826E-02,0.8955E-03,0.3605E-03,
     +0.1024E-03,0.1314E-04/
      DATA (XQDUM (I,9,2),I=1,104) /
     +0.1238E-01,0.1306E-01,0.1377E-01,0.1452E-01,0.1531E-01,0.1614E-01,
     +0.1701E-01,0.1793E-01,0.1890E-01,0.1992E-01,0.2099E-01,0.2212E-01,
     +0.2330E-01,0.2455E-01,0.2586E-01,0.2723E-01,0.2868E-01,0.3020E-01,
     +0.3179E-01,0.3347E-01,0.3522E-01,0.3707E-01,0.3900E-01,0.4103E-01,
     +0.4315E-01,0.4538E-01,0.4771E-01,0.5015E-01,0.5271E-01,0.5538E-01,
     +0.5818E-01,0.6110E-01,0.6415E-01,0.6733E-01,0.7065E-01,0.7411E-01,
     +0.7771E-01,0.8146E-01,0.8536E-01,0.8941E-01,0.9362E-01,0.9797E-01,
     +0.1025E+00,0.1071E+00,0.1120E+00,0.1169E+00,0.1220E+00,0.1273E+00,
     +0.1327E+00,0.1382E+00,0.1438E+00,0.1495E+00,0.1553E+00,0.1611E+00,
     +0.1670E+00,0.1729E+00,0.1788E+00,0.1846E+00,0.1903E+00,0.1959E+00,
     +0.2013E+00,0.2064E+00,0.2112E+00,0.2156E+00,0.2195E+00,0.2229E+00,
     +0.2256E+00,0.2276E+00,0.2288E+00,0.2290E+00,0.2281E+00,0.2261E+00,
     +0.2228E+00,0.2181E+00,0.2120E+00,0.2044E+00,0.1953E+00,0.1846E+00,
     +0.1725E+00,0.1591E+00,0.1444E+00,0.1288E+00,0.1126E+00,0.9606E-01,
     +0.7971E-01,0.6398E-01,0.4936E-01,0.3630E-01,0.2515E-01,0.1617E-01,
     +0.1184E-01,0.8491E-02,0.5948E-02,0.4054E-02,0.2674E-02,0.1695E-02,
     +0.1022E-02,0.5792E-03,0.3020E-03,0.1406E-03,0.5557E-04,0.1702E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,3),I=1,104) /
     +0.1687E+03,0.1611E+03,0.1538E+03,0.1469E+03,0.1402E+03,0.1337E+03,
     +0.1275E+03,0.1216E+03,0.1159E+03,0.1104E+03,0.1052E+03,0.1001E+03,
     +0.9530E+02,0.9067E+02,0.8624E+02,0.8198E+02,0.7791E+02,0.7401E+02,
     +0.7027E+02,0.6670E+02,0.6328E+02,0.6001E+02,0.5688E+02,0.5388E+02,
     +0.5102E+02,0.4829E+02,0.4568E+02,0.4319E+02,0.4081E+02,0.3854E+02,
     +0.3638E+02,0.3431E+02,0.3234E+02,0.3047E+02,0.2868E+02,0.2698E+02,
     +0.2537E+02,0.2383E+02,0.2237E+02,0.2098E+02,0.1965E+02,0.1840E+02,
     +0.1721E+02,0.1608E+02,0.1501E+02,0.1400E+02,0.1303E+02,0.1212E+02,
     +0.1126E+02,0.1045E+02,0.9682E+01,0.8956E+01,0.8271E+01,0.7626E+01,
     +0.7018E+01,0.6446E+01,0.5908E+01,0.5402E+01,0.4928E+01,0.4484E+01,
     +0.4068E+01,0.3680E+01,0.3318E+01,0.2981E+01,0.2668E+01,0.2378E+01,
     +0.2109E+01,0.1862E+01,0.1635E+01,0.1427E+01,0.1238E+01,0.1066E+01,
     +0.9115E+00,0.7726E+00,0.6488E+00,0.5393E+00,0.4433E+00,0.3597E+00,
     +0.2878E+00,0.2266E+00,0.1751E+00,0.1325E+00,0.9782E-01,0.7008E-01,
     +0.4841E-01,0.3192E-01,0.1978E-01,0.1120E-01,0.5460E-02,0.1893E-02,
     +0.5520E-03,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,4),I=1,104) /
     +0.3220E+02,0.3089E+02,0.2963E+02,0.2842E+02,0.2725E+02,0.2613E+02,
     +0.2504E+02,0.2399E+02,0.2299E+02,0.2202E+02,0.2108E+02,0.2018E+02,
     +0.1932E+02,0.1848E+02,0.1768E+02,0.1691E+02,0.1617E+02,0.1546E+02,
     +0.1477E+02,0.1411E+02,0.1348E+02,0.1287E+02,0.1228E+02,0.1172E+02,
     +0.1118E+02,0.1066E+02,0.1016E+02,0.9682E+01,0.9223E+01,0.8783E+01,
     +0.8360E+01,0.7955E+01,0.7566E+01,0.7193E+01,0.6836E+01,0.6493E+01,
     +0.6165E+01,0.5850E+01,0.5548E+01,0.5259E+01,0.4983E+01,0.4717E+01,
     +0.4463E+01,0.4220E+01,0.3987E+01,0.3764E+01,0.3550E+01,0.3346E+01,
     +0.3150E+01,0.2962E+01,0.2782E+01,0.2610E+01,0.2445E+01,0.2287E+01,
     +0.2136E+01,0.1992E+01,0.1853E+01,0.1720E+01,0.1594E+01,0.1472E+01,
     +0.1357E+01,0.1246E+01,0.1141E+01,0.1040E+01,0.9450E+00,0.8547E+00,
     +0.7693E+00,0.6889E+00,0.6133E+00,0.5427E+00,0.4770E+00,0.4163E+00,
     +0.3604E+00,0.3094E+00,0.2632E+00,0.2216E+00,0.1846E+00,0.1519E+00,
     +0.1234E+00,0.9864E-01,0.7748E-01,0.5962E-01,0.4476E-01,0.3262E-01,
     +0.2294E-01,0.1546E-01,0.9903E-02,0.5980E-02,0.3384E-02,0.1791E-02,
     +0.1183E-02,0.7849E-03,0.5225E-03,0.3480E-03,0.2305E-03,0.1504E-03,
     +0.9543E-04,0.5800E-04,0.3310E-04,0.1726E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,5),I=1,104) /
     +0.5802E+01,0.5577E+01,0.5359E+01,0.5149E+01,0.4946E+01,0.4751E+01,
     +0.4563E+01,0.4381E+01,0.4206E+01,0.4038E+01,0.3875E+01,0.3719E+01,
     +0.3568E+01,0.3423E+01,0.3283E+01,0.3149E+01,0.3019E+01,0.2895E+01,
     +0.2775E+01,0.2659E+01,0.2548E+01,0.2441E+01,0.2339E+01,0.2240E+01,
     +0.2145E+01,0.2054E+01,0.1966E+01,0.1882E+01,0.1800E+01,0.1723E+01,
     +0.1648E+01,0.1576E+01,0.1506E+01,0.1440E+01,0.1376E+01,0.1315E+01,
     +0.1256E+01,0.1199E+01,0.1144E+01,0.1092E+01,0.1041E+01,0.9930E+00,
     +0.9463E+00,0.9013E+00,0.8580E+00,0.8163E+00,0.7761E+00,0.7373E+00,
     +0.6999E+00,0.6638E+00,0.6288E+00,0.5951E+00,0.5625E+00,0.5309E+00,
     +0.5003E+00,0.4706E+00,0.4419E+00,0.4140E+00,0.3870E+00,0.3608E+00,
     +0.3355E+00,0.3109E+00,0.2872E+00,0.2643E+00,0.2422E+00,0.2210E+00,
     +0.2006E+00,0.1812E+00,0.1627E+00,0.1452E+00,0.1287E+00,0.1133E+00,
     +0.9894E-01,0.8571E-01,0.7359E-01,0.6257E-01,0.5265E-01,0.4379E-01,
     +0.3594E-01,0.2906E-01,0.2307E-01,0.1793E-01,0.1358E-01,0.9959E-02,
     +0.7020E-02,0.4713E-02,0.2981E-02,0.1756E-02,0.9522E-03,0.4721E-03,
     +0.2968E-03,0.1868E-03,0.1183E-03,0.7544E-04,0.4833E-04,0.3083E-04,
     +0.1931E-04,0.1168E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,6),I=1,104) /
     +0.5629E+01,0.5403E+01,0.5185E+01,0.4975E+01,0.4773E+01,0.4577E+01,
     +0.4389E+01,0.4208E+01,0.4033E+01,0.3865E+01,0.3702E+01,0.3546E+01,
     +0.3396E+01,0.3251E+01,0.3111E+01,0.2977E+01,0.2848E+01,0.2723E+01,
     +0.2604E+01,0.2489E+01,0.2378E+01,0.2271E+01,0.2169E+01,0.2071E+01,
     +0.1976E+01,0.1885E+01,0.1798E+01,0.1714E+01,0.1634E+01,0.1557E+01,
     +0.1482E+01,0.1411E+01,0.1343E+01,0.1277E+01,0.1214E+01,0.1154E+01,
     +0.1096E+01,0.1041E+01,0.9873E+00,0.9363E+00,0.8874E+00,0.8405E+00,
     +0.7956E+00,0.7525E+00,0.7112E+00,0.6716E+00,0.6337E+00,0.5974E+00,
     +0.5626E+00,0.5292E+00,0.4972E+00,0.4666E+00,0.4373E+00,0.4091E+00,
     +0.3822E+00,0.3564E+00,0.3317E+00,0.3080E+00,0.2853E+00,0.2637E+00,
     +0.2430E+00,0.2232E+00,0.2044E+00,0.1864E+00,0.1694E+00,0.1532E+00,
     +0.1379E+00,0.1235E+00,0.1100E+00,0.9733E-01,0.8556E-01,0.7466E-01,
     +0.6464E-01,0.5549E-01,0.4719E-01,0.3973E-01,0.3308E-01,0.2721E-01,
     +0.2207E-01,0.1763E-01,0.1384E-01,0.1064E-01,0.7983E-02,0.5817E-02,
     +0.4093E-02,0.2762E-02,0.1775E-02,0.1078E-02,0.6162E-03,0.3308E-03,
     +0.2210E-03,0.1483E-03,0.9984E-04,0.6722E-04,0.4495E-04,0.2956E-04,
     +0.1890E-04,0.1156E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,7),I=1,104) /
     +0.5513E+01,0.5287E+01,0.5069E+01,0.4859E+01,0.4657E+01,0.4462E+01,
     +0.4274E+01,0.4092E+01,0.3918E+01,0.3749E+01,0.3587E+01,0.3431E+01,
     +0.3281E+01,0.3136E+01,0.2996E+01,0.2862E+01,0.2733E+01,0.2609E+01,
     +0.2489E+01,0.2375E+01,0.2264E+01,0.2158E+01,0.2056E+01,0.1958E+01,
     +0.1864E+01,0.1773E+01,0.1686E+01,0.1603E+01,0.1523E+01,0.1446E+01,
     +0.1372E+01,0.1301E+01,0.1234E+01,0.1169E+01,0.1106E+01,0.1047E+01,
     +0.9896E+00,0.9349E+00,0.8826E+00,0.8325E+00,0.7846E+00,0.7388E+00,
     +0.6950E+00,0.6532E+00,0.6133E+00,0.5752E+00,0.5388E+00,0.5041E+00,
     +0.4710E+00,0.4395E+00,0.4095E+00,0.3809E+00,0.3538E+00,0.3280E+00,
     +0.3035E+00,0.2802E+00,0.2582E+00,0.2373E+00,0.2176E+00,0.1989E+00,
     +0.1813E+00,0.1648E+00,0.1492E+00,0.1346E+00,0.1209E+00,0.1081E+00,
     +0.9617E-01,0.8511E-01,0.7488E-01,0.6546E-01,0.5682E-01,0.4894E-01,
     +0.4179E-01,0.3535E-01,0.2960E-01,0.2451E-01,0.2004E-01,0.1616E-01,
     +0.1283E-01,0.1002E-01,0.7689E-02,0.5781E-02,0.4253E-02,0.3057E-02,
     +0.2143E-02,0.1463E-02,0.9715E-03,0.6269E-03,0.3922E-03,0.2365E-03,
     +0.1705E-03,0.1226E-03,0.8755E-04,0.6174E-04,0.4269E-04,0.2873E-04,
     +0.1862E-04,0.1148E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,8),I=1,104) /
     +0.5390E+01,0.5167E+01,0.4952E+01,0.4745E+01,0.4546E+01,0.4353E+01,
     +0.4168E+01,0.3989E+01,0.3817E+01,0.3652E+01,0.3492E+01,0.3338E+01,
     +0.3190E+01,0.3048E+01,0.2911E+01,0.2779E+01,0.2652E+01,0.2530E+01,
     +0.2413E+01,0.2301E+01,0.2192E+01,0.2088E+01,0.1988E+01,0.1892E+01,
     +0.1800E+01,0.1711E+01,0.1626E+01,0.1545E+01,0.1467E+01,0.1392E+01,
     +0.1320E+01,0.1251E+01,0.1185E+01,0.1121E+01,0.1061E+01,0.1003E+01,
     +0.9472E+00,0.8941E+00,0.8432E+00,0.7946E+00,0.7482E+00,0.7038E+00,
     +0.6615E+00,0.6210E+00,0.5824E+00,0.5456E+00,0.5105E+00,0.4770E+00,
     +0.4452E+00,0.4149E+00,0.3860E+00,0.3586E+00,0.3326E+00,0.3079E+00,
     +0.2844E+00,0.2622E+00,0.2412E+00,0.2213E+00,0.2026E+00,0.1849E+00,
     +0.1682E+00,0.1525E+00,0.1378E+00,0.1241E+00,0.1112E+00,0.9922E-01,
     +0.8809E-01,0.7778E-01,0.6826E-01,0.5953E-01,0.5154E-01,0.4427E-01,
     +0.3771E-01,0.3181E-01,0.2657E-01,0.2193E-01,0.1788E-01,0.1438E-01,
     +0.1139E-01,0.8871E-02,0.6785E-02,0.5088E-02,0.3734E-02,0.2677E-02,
     +0.1872E-02,0.1274E-02,0.8439E-03,0.5427E-03,0.3378E-03,0.2023E-03,
     +0.1450E-03,0.1036E-03,0.7343E-04,0.5135E-04,0.3519E-04,0.2345E-04,
     +0.1504E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,9),I=1,104) /
     +0.4059E+01,0.3881E+01,0.3709E+01,0.3543E+01,0.3384E+01,0.3231E+01,
     +0.3084E+01,0.2942E+01,0.2806E+01,0.2676E+01,0.2551E+01,0.2430E+01,
     +0.2315E+01,0.2204E+01,0.2097E+01,0.1995E+01,0.1897E+01,0.1803E+01,
     +0.1713E+01,0.1627E+01,0.1545E+01,0.1465E+01,0.1390E+01,0.1317E+01,
     +0.1248E+01,0.1181E+01,0.1118E+01,0.1057E+01,0.9992E+00,0.9438E+00,
     +0.8909E+00,0.8403E+00,0.7921E+00,0.7461E+00,0.7022E+00,0.6604E+00,
     +0.6206E+00,0.5827E+00,0.5465E+00,0.5122E+00,0.4795E+00,0.4484E+00,
     +0.4189E+00,0.3909E+00,0.3643E+00,0.3391E+00,0.3152E+00,0.2926E+00,
     +0.2712E+00,0.2510E+00,0.2319E+00,0.2138E+00,0.1968E+00,0.1808E+00,
     +0.1657E+00,0.1515E+00,0.1382E+00,0.1258E+00,0.1141E+00,0.1032E+00,
     +0.9305E-01,0.8360E-01,0.7482E-01,0.6669E-01,0.5918E-01,0.5226E-01,
     +0.4592E-01,0.4011E-01,0.3483E-01,0.3004E-01,0.2572E-01,0.2184E-01,
     +0.1839E-01,0.1534E-01,0.1266E-01,0.1033E-01,0.8327E-02,0.6619E-02,
     +0.5183E-02,0.3993E-02,0.3021E-02,0.2241E-02,0.1627E-02,0.1154E-02,
     +0.7980E-03,0.5367E-03,0.3501E-03,0.2207E-03,0.1336E-03,0.7693E-04,
     +0.5346E-04,0.3689E-04,0.2515E-04,0.1685E-04,0.1103E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA XMIN/5.E-05/,XMAX/.95/
      DATA ISTEP/0/
      IF(ISTEP.EQ.0) THEN
        DO 2 I=1,IX
          ENT(I)=LOG10(XCO(I))
    2   CONTINUE
        NENT(1)=IX
        NENT(2)=IQ
        DO 3 I=1,IQ
          ENT(IX+I)=LOG10(Q2(I))
    3   CONTINUE
        ISTEP=1
      ENDIF
      IF (STRFUN(1:2) .EQ. 'UP' ) THEN
      IFUN =1
      ELSE IF (STRFUN(1:2) .EQ. 'DO') THEN
      IFUN =2
      ELSE IF (STRFUN(1:2) .EQ. 'GL') THEN
      IFUN =3
      ELSE IF (STRFUN(1:2) .EQ. 'QB') THEN
      IFUN =4
      ELSE IF (STRFUN(1:2) .EQ. 'UB') THEN
      IFUN =5
      ELSE IF (STRFUN(1:2) .EQ. 'SB') THEN
      IFUN =6
      ELSE IF (STRFUN(1:2) .EQ. 'CB') THEN
      IFUN =7
      ELSE IF (STRFUN(1:2) .EQ. 'BB') THEN
      IFUN =8
      ELSE IF (STRFUN(1:2) .EQ. 'TB') THEN
      IFUN =9
      ENDIF
      FUNC=0.
C     IF(X.GT.XMIN.AND.X.LT.XMAX) THEN
      IF(X.LT.XMAX) THEN
      ARG(1)=LOG10(X)
      ARG(2)=LOG10(QSTAR2)
      FUNC =FINT(NARG,ARG,NENT,ENT,XQDUM(1,1,IFUN))
      ENDIF
      IF (FUNC.LT.0.) FUNC=0.
      END
