(module dotnet_compile
   (import type_type ast_var ast_node engine_param
	   engine_param
	   object_class     ; tclass
	   object_slots     ; slot
	   ast_env          ; find-global
	   module_module    ; *module*
;	   bas_bas
	   dotnet_extern dotnet_env dotnet_instr dotnet_expr dotnet_compiler
	   dotnet_init dotnet_constr dotnet_closure
	   dotnet_prelude dotnet_compress dotnet_lisp
	   backend_cplib)
   (export (dotnet-compile globals))
   )

(define (dotnet-compile globals)
      (compile globals) )

   
;;
;; AST to assembler
;;
(define (compile globals)
   (let ( (m (compile-module globals)) )
      (cons m (map compile-class (get-classes-to-be-compiled))) ))

;;;
;;; Compiling a classe
;;;
(define (compile-class class)
   (let* ( (env (instantiate::env))
	   (_ (jlib-declare env 'jobject))
           (me (compile-type-nowidening class env))
           (super (if (wide-class? class)
		      'jobject
		      (compile-type (tclass-its-super class) env)))
	   (fields (compile-class-fields env class me)) )
      ;; first element is used only by jdump to got the classfile name...
     `((class ,(tclass-id-mangling class))
       ,me ,super ()
        (declare
	   ,@(reverse (env-declarations env))
	   (init0 (method ,me (public) void "<init>"))
	   (sinit0 (method ,super (public) void "<init>")) )
	(fields ,@fields)
	(method init0 (t) ()
		(aload t)
		(invokespecial sinit0)
		(return) ))))


(define (compile-class-fields env class owner)
   (let ( (r '()) )
      (for-each (lambda (slot)
		   (let ( (type (compile-type (get-slot-type slot) env)) )
		      (if (and (not (slot-virtual? slot))
			       (eq? class (slot-class-owner slot)) )
			  (let ( (name (slot-name slot)) )
			     (set! r (cons 
				      (env-declare-field env name type owner)
				      r ))))))
		(tclass-slots class) )
      r ))

(define (get-slot-type slot)
   (or (slot-indexed slot) (slot-type slot)) )

;;;
;;; Compiling a module
;;;
(define (compile-module globals)
   (let* ( (env (compile-init globals))
	   (me (env-current-module env))
	   (super (jlib-declare env 'j_procedure))
	   (main (compile-main env))
	   (dlopen (compile-dlopen env))
	   (funs (map (lambda (v) (compile-globalfun v env)) globals))
	   (constructors (dotnet-constructors env me super))
	   (funcallers (dotnet-funcallers env me super)) )
      (jlib-declare env 'jstring)
      `(module ,me ,super ()
	       (declare
		,@(reverse (env-declarations env))
		(__the_module_name__ (field ,me (public static)
					    jstring "__the_module_name__" ))
		(constants (field ,me (public static)
				  (vector jobject) "constants") ))
	       (fields constants __the_module_name__ ,@(compile-fields env))
	       (sourcefile ,(get-sourcefile))
	       ,@constructors
	       ,@funcallers
	       ,@main
	       ,@dlopen
	       ,@funs )))

(define (compile-main env)
   (if (global? *main*)
       (let ( (name (gensym "main"))
	      (rname "Main")
	      (exc (jlib-declare env 'jthrowable)) )
	  (jlib-declare env 'listargv)
	  (jlib-declare env 'init_callback)
	  (env-declare env name
	     `(method ,(env-current-module env)
		      (public static) void ,rname (vector jstring)) )
	  `((method ,name (argv) ()
		    (invokestatic init_callback)
		    (try)
		    (aload argv)
		    (invokestatic listargv)
		    (invokestatic ,(get-global-name
				    env
				    (find-global 'bigloo_main *module*) ))
		    (pop)
		    (leave _return)
		    (catch ,exc)
		    (invokestatic ,(jlib-declare env 'internalerror))
		    (leave _return)
		    _return (return) )) )
       '() ))

(define (compile-dlopen env)
   (let ( (name (gensym "BGL_DYNAMIC_LOAD_INIT")) )
      (env-declare env name
	 `(method ,(env-current-module env)
		  (public static) void "BGL_DYNAMIC_LOAD_INIT") )
      `((method ,name () ()
		(iconst_0)
		(aconst_null)
		(invokestatic ,(get-global-name
		      env
		      (find-global 'module-initialization *module*) ))
		(pop)
		(return)))))
   
(define (compile-fields env)
   (let ( (r '()) (me (env-current-module env)) )
      (for-each
       (lambda (slot)
	  (let ( (val (cadr slot)) )
	     (if (and (eq? (car val) 'field)
		      (eq? (cadr val) me) )
		 (set! r (cons (car slot) r)) )))
       (env-declarations env) )
      r ))

;;
;; Compiling a method
;;
(define **bas** #t)

(define (compile-globalfun var env)
   ;(if **bas** (bas var))
   (let ( (m (compile-globalfun1 var env)) )
      m ))

(define (compile-globalfun1 var env)
   (with-access::global var (type module import value)
      (with-access::sfun value (args body)
	 (env-current-method-set! env var)
	 (env-vcount-set! env 0)
	 (env-code-set! env '())
	 (env-locals-set! env '())
	 (env-freelocals-set! env '())
	 (env-maplocals-set! env '())
	 (env-stack-set! env '())
	 (for-each
	  (lambda (a)
	     (env-set-name! env a 'P)
	     ;; 'begin' is set in compiler-body
	     (debug-declare-var-from env a 'begin 'end) )
	  args )
	 (set! body (compile-compress body))
	 (compile-prelude body)
	 (compiler-body body env)
	 (_label env 'end)
	 (let ( (rtype (compile-type type env)) )
	    (if *purify* (_checkcast env rtype))
	    (_return env rtype) )
	 `(method ,(get-global-name env var)
		  ,(compile-formals args env)
		  ,(reverse! (env-locals env))
		  ,@(reverse! (env-code env)) ))))

(define (compile-formals l env)
   (if (null? l)
       l
       (let ( (v (car l)) (rest (compile-formals (cdr l) env)) )
	  (let ( (type (compile-type v env))  (name (local-name v)) )
	     (cons (cons name type) rest) ))))

