;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Jvm/vmemq.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Aug 28 21:03:21 2001                          */
;*    Last change :  Tue Aug 28 21:31:12 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    This module implement a simple function that checks if a list of */
;*    variables is present in an expression.                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module jvm_vmemq
   (include "Ast/node.sch"
	    "Tools/location.sch")
   (import  tools_error
	    tools_shape
	    tools_error
	    type_cache
	    ast_sexp
	    ast_local
	    ast_apply
	    ast_app)
   (export (vmemq? ::pair-nil ::node)))

;*---------------------------------------------------------------------*/
;*    vmemq? ...                                                       */
;*---------------------------------------------------------------------*/
(define (vmemq? vars expr)
   (and (pair? vars) (do-vmemq? expr (map var-variable vars))))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ...                                                    */
;*---------------------------------------------------------------------*/
(define-generic (do-vmemq?::bool node::node vars)
   #f)

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::var ...                                              */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::var vars)
   (pair? (memq (var-variable node) vars)))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::sequence ...                                         */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::sequence vars)
   (do-vmemq*? (sequence-nodes node) vars))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::app ...                                              */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::app vars)
   (do-vmemq*? (app-args node) vars))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::app-ly ...                                           */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::app-ly vars)
   (or (do-vmemq? (app-ly-fun node) vars)
       (do-vmemq? (app-ly-arg node) vars)))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::funcall ...                                          */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::funcall vars)
   (or (do-vmemq? (funcall-fun node) vars)
       (do-vmemq*? (funcall-args node) vars)))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::extern ...                                           */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::extern vars)
   (do-vmemq*? (extern-expr* node) vars))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::cast ...                                             */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::cast vars)
   (do-vmemq? (cast-arg node) vars))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::setq ...                                             */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::setq vars)
   (or (do-vmemq? (setq-var node) vars)
       (do-vmemq? (setq-value node) vars)))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::conditional ...                                      */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::conditional vars)
   (or (do-vmemq? (conditional-test node) vars)
       (do-vmemq? (conditional-true node) vars)
       (do-vmemq? (conditional-false node) vars)))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::fail ...                                             */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::fail vars)
   (or (do-vmemq? (fail-proc node) vars)
       (do-vmemq? (fail-msg node) vars)
       (do-vmemq? (fail-obj node) vars)))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::select ...                                           */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::select vars)
   (or (do-vmemq? (select-test node) vars)
       (do-vmemq*? (map cdr (select-clauses node)) vars)))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::make-box ...                                         */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::make-box vars)
   (do-vmemq? (make-box-value node) vars))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::box-ref ...                                          */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::box-ref vars)
   (do-vmemq? (box-ref-var node) vars))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::box-set! ...                                         */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::box-set! vars)
   (or (do-vmemq? (box-set!-var node) vars)
       (do-vmemq? (box-set!-value node) vars)))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::let-fun ...                                          */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::let-fun vars)
   (or (do-vmemq? (let-fun-body node) vars)
       (do-vmemq*? (map (lambda (f) (sfun-body (local-value f)))
			(let-fun-locals node))
		   vars)))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::let-var ...                                          */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::let-var vars)
   (or (do-vmemq? (let-var-body node) vars)
       (do-vmemq*? (map cdr (let-var-bindings node)) vars)))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::set-ex-it ...                                        */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::set-ex-it vars)
   (or (do-vmemq? (set-ex-it-var node) vars)
       (do-vmemq? (set-ex-it-body node) vars)))

;*---------------------------------------------------------------------*/
;*    do-vmemq? ::jump-ex-it ...                                       */
;*---------------------------------------------------------------------*/
(define-method (do-vmemq? node::jump-ex-it vars)
   (or (do-vmemq? (jump-ex-it-exit node) vars)
       (do-vmemq? (jump-ex-it-value node) vars)))

;*---------------------------------------------------------------------*/
;*    do-vmemq*? ...                                                   */
;*---------------------------------------------------------------------*/
(define (do-vmemq*? nodes::pair-nil vars)
   (let loop ((nodes nodes))
      (cond
	 ((null? nodes)
	  #f)
	 ((do-vmemq? (car nodes) vars)
	  #t)
	 (else
	  (loop (cdr nodes))))))

