/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbcext;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;


public class ClientResultSetMetaDataSapDB
    implements ResultSetMetaData
{
    private ResultSetMetaData     originalMetaData;
    private ClientConnectionSapDB clientConnection;

    public ClientResultSetMetaDataSapDB(ResultSetMetaData originalMetaData, 
                                        ClientConnectionSapDB clientConnection)
    {
        this.originalMetaData=originalMetaData;
        this.clientConnection=clientConnection;
    }
    
    void exceptionOccurred(SQLException sqlEx) 
    {
        this.clientConnection.exceptionOccurred(sqlEx);
    }
    
    // Code for delegation of java.sql.ResultSetMetaData methods to originalMetaData

    public boolean isReadOnly(int param1) throws SQLException
    {
        try {
            return originalMetaData.isReadOnly(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getColumnCount() throws SQLException
    {
        try {
            return originalMetaData.getColumnCount();
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isAutoIncrement(int param1) throws SQLException
    {
        try {
            return originalMetaData.isAutoIncrement(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isCaseSensitive(int param1) throws SQLException
    {
        try {
            return originalMetaData.isCaseSensitive(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isSearchable(int param1) throws SQLException
    {
        try {
            return originalMetaData.isSearchable(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isCurrency(int param1) throws SQLException
    {
        try {
            return originalMetaData.isCurrency(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int isNullable(int param1) throws SQLException
    {
        try {
            return originalMetaData.isNullable(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isSigned(int param1) throws SQLException
    {
        try {
            return originalMetaData.isSigned(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getColumnDisplaySize(int param1) throws SQLException
    {
        try {
            return originalMetaData.getColumnDisplaySize(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getColumnLabel(int param1) throws SQLException
    {
        try {
            return originalMetaData.getColumnLabel(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getColumnName(int param1) throws SQLException
    {
        try {
            return originalMetaData.getColumnName(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getSchemaName(int param1) throws SQLException
    {
        try {
            return originalMetaData.getSchemaName(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getPrecision(int param1) throws SQLException
    {
        try {
            return originalMetaData.getPrecision(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getScale(int param1) throws SQLException
    {
        try {
            return originalMetaData.getScale(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getTableName(int param1) throws SQLException
    {
        try {
            return originalMetaData.getTableName(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getCatalogName(int param1) throws SQLException
    {
        try {
            return originalMetaData.getCatalogName(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public int getColumnType(int param1) throws SQLException
    {
        try {
            return originalMetaData.getColumnType(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getColumnTypeName(int param1) throws SQLException
    {
        try {
            return originalMetaData.getColumnTypeName(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isWritable(int param1) throws SQLException
    {
        try {
            return originalMetaData.isWritable(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public boolean isDefinitelyWritable(int param1) throws SQLException
    {
        try {
            return originalMetaData.isDefinitelyWritable(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

    public String getColumnClassName(int param1) throws SQLException
    {
        try {
            return originalMetaData.getColumnClassName(param1);
        } catch(SQLException sqlEx) {
            exceptionOccurred(sqlEx);
            throw sqlEx;
        }
    }

}
