/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.DBProcParameterInfo;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.ValueOverflow;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.ConversionExceptionSapDB;
import com.sap.dbtech.jdbc.translators.Putval;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.vsp00.DataType;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class DBTechTranslator {
    protected int logicalLength;
    protected int physicalLength;
    protected int bufpos;
    protected byte mode;
    protected byte ioType;
    protected byte dataType;
    protected boolean writeAllowed = false;
    private String colName;
    private int colIndex;
    public static final int nullDefineByte = 1;
    public static final int specialNullValueDefineByte = 2;
    public static final int unknownDefineByte = -1;

    protected DBTechTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mode = (byte)n;
        this.ioType = (byte)n2;
        this.dataType = (byte)n3;
        this.logicalLength = n4;
        this.physicalLength = n5;
        this.bufpos = n6;
    }

    public void allowWrites() {
        this.writeAllowed = true;
    }

    public InputStream getAsciiStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        throw this.newGetException("AsciiStream");
    }

    public BigDecimal getBigDecimal(int n, SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        throw this.newGetException("BigDecimal");
    }

    public BigDecimal getBigDecimal(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        throw this.newGetException("BigDecimal");
    }

    public InputStream getBinaryStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        throw this.newGetException("BinaryStream");
    }

    public Blob getBlob(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        throw this.newGetException("Blob");
    }

    public boolean getBoolean(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        throw this.newGetException("boolean");
    }

    public int getBufpos() {
        return this.bufpos;
    }

    public byte getByte(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        throw this.newGetException("byte");
    }

    public byte[] getBytes(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        throw this.newGetException("byte []");
    }

    public String getCatalogName() {
        return "";
    }

    public Reader getCharacterStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        throw this.newGetException("CharacterStream");
    }

    public Clob getClob(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        throw this.newGetException("Clob");
    }

    public int getColIndex() {
        return this.colIndex;
    }

    public String getColumnClassName() {
        String string;
        switch (this.dataType) {
            case 0: {
                string = "java.math.BigDecimal";
                break;
            }
            case 1: {
                string = "java.math.BigDecimal";
                break;
            }
            case 2: 
            case 3: {
                string = "java.lang.String";
                break;
            }
            case 4: {
                string = "byte[]";
                break;
            }
            case 5: {
                string = "byte[]";
                break;
            }
            case 10: {
                string = "java.sql.Date";
                break;
            }
            case 11: {
                string = "java.sql.Time";
                break;
            }
            case 12: {
                string = "java.math.BigDecimal";
                break;
            }
            case 13: {
                string = "java.sql.Timestamp";
                break;
            }
            case 14: {
                string = "java.lang.Object";
                break;
            }
            case 15: {
                string = "java.math.BigDecimal";
                break;
            }
            case 16: {
                string = "java.math.BigDecimal";
                break;
            }
            case 17: {
                string = "java.lang.Long";
                break;
            }
            case 18: {
                string = "java.io.InputStream";
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 20: {
                string = "java.io.InputStream";
                break;
            }
            case 8: 
            case 21: {
                string = "java.io.InputStream";
                break;
            }
            case 22: {
                string = "java.io.Reader";
                break;
            }
            case 23: {
                string = "java.lang.Boolean";
                break;
            }
            case 24: {
                string = "java.lang.String";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "java.lang.Object";
                break;
            }
            case 29: {
                string = "java.lang.Integer";
                break;
            }
            case 30: {
                string = "java.lang.Integer";
                break;
            }
            case 31: 
            case 32: {
                string = "java.lang.String";
                break;
            }
            case 33: {
                string = "byte[]";
                break;
            }
            case 34: {
                string = "java.lang.String";
                break;
            }
            case 35: {
                string = "java.io.Reader";
                break;
            }
            case 36: {
                string = "java.lang.String";
                break;
            }
            default: {
                string = "java.lang.Object";
            }
        }
        return string;
    }

    public int getColumnDisplaySize() {
        return this.logicalLength;
    }

    public String getColumnLabel() {
        return this.colName;
    }

    public String getColumnName() {
        return this.colName;
    }

    public int getColumnType() {
        int n;
        switch (this.dataType) {
            case 0: {
                n = 3;
                break;
            }
            case 1: {
                n = 6;
                break;
            }
            case 2: 
            case 3: {
                n = 1;
                break;
            }
            case 4: {
                n = -2;
                break;
            }
            case 5: {
                n = -2;
                break;
            }
            case 10: {
                n = 91;
                break;
            }
            case 11: {
                n = 92;
                break;
            }
            case 12: {
                n = 6;
                break;
            }
            case 13: {
                n = 93;
                break;
            }
            case 14: {
                n = 1111;
                break;
            }
            case 15: {
                n = 2;
                break;
            }
            case 16: {
                n = 1111;
                break;
            }
            case 17: {
                n = 1111;
                break;
            }
            case 18: {
                n = 1;
                break;
            }
            case 6: 
            case 7: 
            case 19: 
            case 20: {
                n = -1;
                break;
            }
            case 8: 
            case 21: {
                n = -4;
                break;
            }
            case 22: {
                n = -1;
                break;
            }
            case 23: {
                n = -7;
                break;
            }
            case 24: {
                n = 12;
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n = 1111;
                break;
            }
            case 29: {
                n = 5;
                break;
            }
            case 30: {
                n = 4;
                break;
            }
            case 31: 
            case 32: {
                n = 12;
                break;
            }
            case 33: {
                n = -3;
                break;
            }
            case 34: {
                n = 12;
                break;
            }
            case 35: {
                n = -1;
                break;
            }
            case 36: {
                n = 12;
                break;
            }
            default: {
                n = 1111;
            }
        }
        return n;
    }

    public String getColumnTypeName() {
        String string;
        switch (this.getColumnType()) {
            case -7: {
                string = "BOOLEAN";
                break;
            }
            case -6: {
                string = "TINYINT";
                break;
            }
            case 5: {
                string = "SMALLINT";
                break;
            }
            case 4: {
                string = "INTEGER";
                break;
            }
            case -5: {
                string = "BIGINT";
                break;
            }
            case 6: {
                string = "FLOAT";
                break;
            }
            case 7: {
                string = "FLOAT";
                break;
            }
            case 8: {
                string = "FLOAT";
                break;
            }
            case 2: {
                string = "FIXED";
                break;
            }
            case 3: {
                string = "FIXED";
                break;
            }
            case 1: {
                string = "CHAR";
                break;
            }
            case 12: {
                string = "VARCHAR";
                break;
            }
            case -1: {
                string = "LONG";
                break;
            }
            case 91: {
                string = "DATE";
                break;
            }
            case 92: {
                string = "TIME";
                break;
            }
            case 93: {
                string = "TIMESTAMP";
                break;
            }
            case -2: {
                string = "CHAR BYTE";
                break;
            }
            case -3: {
                string = "VARCHAR BYTE";
                break;
            }
            case -4: {
                string = "LONG BYTE";
                break;
            }
            case 0: {
                string = "NULL";
                break;
            }
            default: {
                string = MessageTranslator.translate("unknowntype");
            }
        }
        return string;
    }

    public Date getDate(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        throw this.newGetException("Date");
    }

    public double getDouble(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        throw this.newGetException("double");
    }

    public float getFloat(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        throw this.newGetException("float");
    }

    public int getInt(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        throw this.newGetException("int");
    }

    public long getLong(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        throw this.newGetException("long");
    }

    public Object getObject(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        throw this.newGetException("Object");
    }

    public int getPhysicalLength() {
        return this.physicalLength;
    }

    public int getPrecision() {
        return this.logicalLength;
    }

    public Putval getPutvalObject() {
        return null;
    }

    public int getScale() {
        return 0;
    }

    public String getSchemaName() {
        return "";
    }

    public short getShort(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        throw this.newGetException("short");
    }

    public String getString(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        Object object = this.getObject(sQLParamController, structuredMem);
        String string = object == null ? null : object.toString();
        return string;
    }

    public String getTableName() {
        return "";
    }

    public Time getTime(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        throw this.newGetException("Time");
    }

    public Timestamp getTimestamp(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        throw this.newGetException("Timestamp");
    }

    public InputStream getUnicodeStream(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        throw this.newGetException("UnicodeStream");
    }

    public int getParameterMode() {
        switch (this.ioType) {
            case 1: {
                return 4;
            }
            case 0: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public boolean isAutoIncrement() {
        return false;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean isCurrency() {
        return false;
    }

    public boolean isDefinitelyWritable() {
        return false;
    }

    public boolean isInput() {
        return this.ioType != 1;
    }

    public boolean isOutput() {
        return this.ioType != 0;
    }

    public boolean isLongKind() {
        boolean bl = false;
        switch (this.dataType) {
            case 6: 
            case 7: 
            case 8: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 34: 
            case 35: {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isNull(SQLParamController sQLParamController, StructuredMem structuredMem) {
        byte by = structuredMem.getInt1(this.bufpos - 1);
        boolean bl = by == -1;
        sQLParamController.setLastWasNull(bl);
        return bl;
    }

    public int checkDefineByte(SQLParamController sQLParamController, StructuredMem structuredMem) {
        byte by = structuredMem.getInt1(this.bufpos - 1);
        switch (by) {
            case -1: {
                sQLParamController.setLastWasNull(true);
                return 1;
            }
            case -2: {
                sQLParamController.setLastWasNull(false);
                return 2;
            }
        }
        sQLParamController.setLastWasNull(false);
        return -1;
    }

    public int isNullable() {
        int n = (this.mode & 1) != 0 ? 0 : ((this.mode & 2) != 0 ? 1 : 2);
        return n;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isSearchable() {
        return true;
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isWritable() {
        return this.writeAllowed;
    }

    public void put(DataPart dataPart, Object object) throws SQLException {
        if (this.ioType != 1) {
            if (object == null) {
                dataPart.putNull(this.bufpos, this.physicalLength - 1);
            } else {
                this.putSpecific(dataPart, object);
                dataPart.addArg(this.bufpos, this.physicalLength - 1);
            }
        }
    }

    public void putProcOutput(DataPart dataPart, Object object) throws SQLException {
        if (this.ioType != 0) {
            if (object == null) {
                dataPart.putNull(this.bufpos, this.physicalLength - 1);
            } else {
                this.putSpecific(dataPart, object);
                dataPart.addArg(this.bufpos, this.physicalLength - 1);
            }
        }
    }

    protected abstract void putSpecific(DataPart var1, Object var2) throws SQLException;

    public void setColIndex(int n) {
        this.colIndex = n;
    }

    public void setColName(String string) {
        this.colName = string;
    }

    public Object transAsciiStreamForInput(InputStream inputStream, int n) throws SQLException {
        return this.transObjectForInput(inputStream);
    }

    public Object transBigDecimalForInput(BigDecimal bigDecimal) throws SQLException {
        return this.transObjectForInput(bigDecimal);
    }

    public Object transBinaryStreamForInput(InputStream inputStream, int n) throws SQLException {
        System.out.println("Translating stream with length " + n);
        return this.transObjectForInput(inputStream);
    }

    public Object transBlobForInput(Blob blob) throws SQLException {
        return this.transObjectForInput(blob);
    }

    public Object transBooleanForInput(boolean bl) throws SQLException {
        if (bl) {
            return this.transIntForInput(1);
        }
        return this.transIntForInput(0);
    }

    public Object transByteForInput(byte by) throws SQLException {
        return this.transObjectForInput(new BigDecimal((double)by));
    }

    public Object transBytesForInput(byte[] byArray) throws SQLException {
        throw this.newGetException("Bytes");
    }

    public Object transCharacterStreamForInput(Reader reader, int n) throws SQLException {
        return this.transObjectForInput(reader);
    }

    public Object transClobForInput(Clob clob) throws SQLException {
        return this.transObjectForInput(clob);
    }

    public Object transDateForInput(Date date, Calendar calendar) throws SQLException {
        return this.transObjectForInput(date);
    }

    public Object transDoubleForInput(double d) throws SQLException {
        try {
            return this.transObjectForInput(new BigDecimal(d));
        }
        catch (NumberFormatException numberFormatException) {
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.special.number.unsupported", Double.toString(d)));
            }
            throw numberFormatException;
        }
    }

    public Object transFloatForInput(float f) throws SQLException {
        return this.transObjectForInput(new BigDecimal(f));
    }

    public Object transIntForInput(int n) throws SQLException {
        return this.transObjectForInput(new BigDecimal((double)n));
    }

    public Object transLongForInput(long l) throws SQLException {
        return this.transObjectForInput(new BigDecimal((double)l));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Object transObjectForInput(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        Object object2 = this.transSpecificForInput(object);
        if (object2 != null) {
            return object2;
        }
        if (object instanceof String) {
            return this.transStringForInput((String)object);
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) return this.transStringForInput(object.toString());
        String string = clazz.getName();
        if (string.equals("[B")) {
            return this.transBytesForInput((byte[])object);
        }
        if (!string.equals("[C")) throw this.newSetException(string);
        return this.transStringForInput(new String((char[])object));
    }

    public Object transShortForInput(short s) throws SQLException {
        return this.transObjectForInput(new BigDecimal((double)s));
    }

    protected abstract Object transSpecificForInput(Object var1) throws SQLException;

    public Object transStringForInput(String string) throws SQLException {
        throw this.newSetException("String");
    }

    public Object transTimeForInput(Time time, Calendar calendar) throws SQLException {
        return this.transObjectForInput(time);
    }

    public Object transTimestampForInput(Timestamp timestamp, Calendar calendar) throws SQLException {
        return this.transObjectForInput(timestamp);
    }

    public Object transUnicodeStreamForInput(InputStream inputStream) throws SQLException {
        return this.transObjectForInput(inputStream);
    }

    public Object cloneObjectForBatch(Object object) {
        return object;
    }

    protected ConversionExceptionSapDB newGetException(String string) {
        return new ConversionExceptionSapDB(MessageTranslator.translate("error.conversion.sqljava", this.getColumnTypeName(), string));
    }

    protected ConversionExceptionSapDB newSetException(String string) {
        return new ConversionExceptionSapDB(MessageTranslator.translate("error.conversion.javasql", string, this.getColumnTypeName()));
    }

    protected ConversionExceptionSapDB newParseException(String string, String string2) {
        if (string2 == null) {
            string2 = this.getColumnTypeName();
        }
        return new ConversionExceptionSapDB(MessageTranslator.translate("error.conversion.data", string, string2));
    }

    public byte bigDecimal2Byte(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            return 0;
        }
        return (byte)bigDecimal.intValue();
    }

    public double bigDecimal2Double(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            return 0.0;
        }
        return bigDecimal.doubleValue();
    }

    public float bigDecimal2Float(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            return 0.0f;
        }
        return (float)bigDecimal.doubleValue();
    }

    public int bigDecimal2Int(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            return 0;
        }
        return bigDecimal.intValue();
    }

    public long bigDecimal2Long(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            return 0L;
        }
        return bigDecimal.longValue();
    }

    public short bigDecimal2Short(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            return 0;
        }
        return (short)bigDecimal.intValue();
    }

    protected void checkFieldLimits(int n) throws SQLException {
        if (n > this.physicalLength - 1) {
            throw new ValueOverflow(DataType.stringValuesC[this.dataType], this.colIndex + 1);
        }
    }

    protected boolean isUnicodeColumn() {
        switch (this.dataType) {
            case 34: 
            case 35: {
                return true;
            }
        }
        return false;
    }

    public boolean isStreamKind() {
        return false;
    }

    public void setProcParamInfo(DBProcParameterInfo dBProcParameterInfo) throws SQLException {
    }

    static class CalendarUtil {
        CalendarUtil() {
        }

        static Timestamp getTimestampFromCalendar(Calendar calendar, int n) {
            Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
            timestamp.setNanos(n);
            return timestamp;
        }

        static Time getTimeFromCalendar(Calendar calendar) {
            return new Time(calendar.getTime().getTime());
        }

        static Date getDateFromCalendar(Calendar calendar) {
            return new Date(calendar.getTime().getTime());
        }
    }
}

